/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.clientbundle;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.java.ClasspathResourceUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gdt.eclipse.core.validation.ValidationResult;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResourceDependencyIndex;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.markers.ClientBundleProblem;
import com.google.gwt.eclipse.core.validators.clientbundle.ClientBundleValidationResult;
import com.google.gwt.eclipse.platform.clientbundle.ResourceTypeDefaultExtensions;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class ClientBundleValidator {
    public ValidationResult validate(CompilationUnit cu) {
        ICompilationUnit icu = JavaASTUtils.getCompilationUnit((ASTNode)cu);
        ClientBundleValidationVisitor visitor = new ClientBundleValidationVisitor(icu.getJavaProject());
        cu.accept((ASTVisitor)visitor);
        ClientBundleValidationResult result = visitor.getResult();
        ClientBundleResourceDependencyIndex.getInstance().putResourcesForCompilationUnit(icu, result.getPossibleResourcePaths());
        return result;
    }

    private static class ClientBundleValidationVisitor
    extends ASTVisitor {
        private final IJavaProject javaProject;
        private final ClientBundleValidationResult result = new ClientBundleValidationResult();

        private static String computeExpectedFileNameArgument(String nameWithoutExtension, String[] extensions) {
            if (extensions.length == 0) {
                return nameWithoutExtension;
            }
            if (extensions.length == 1) {
                return String.valueOf(nameWithoutExtension) + extensions[0];
            }
            int i = 0;
            while (i < extensions.length) {
                String ext = extensions[i];
                if (ext.length() > 1 && ext.startsWith(".")) {
                    extensions[i] = ext.substring(1);
                }
                ++i;
            }
            return String.valueOf(nameWithoutExtension) + " (supported extensions: " + StringUtilities.join((Object[])extensions, (String)", ") + ")";
        }

        private static IPath computeMissingResourceExpectedPath(IPath literalPath, IPath absResourcePath) {
            if (literalPath.segmentCount() == 1) {
                return absResourcePath;
            }
            return literalPath;
        }

        private static IPath getPackagePath(ASTNode node) {
            ICompilationUnit cu = JavaASTUtils.getCompilationUnit((ASTNode)node);
            IPackageFragment pckg = (IPackageFragment)cu.getParent();
            return new Path(pckg.getElementName().replace('.', '/'));
        }

        private static ITypeBinding getReturnTypeBinding(MethodDeclaration methodDecl) {
            Type returnType = methodDecl.getReturnType2();
            if (returnType != null) {
                return returnType.resolveBinding();
            }
            return null;
        }

        private static boolean isSourceAnnotation(ASTNode node) {
            if (node instanceof Annotation) {
                Annotation annotation = (Annotation)node;
                String typeName = annotation.getTypeName().getFullyQualifiedName();
                if (typeName.equals("com.google.gwt.resources.client.ClientBundle.Source")) {
                    return true;
                }
                String sourceAnnotationSimpleName = Signature.getSimpleName((String)"com.google.gwt.resources.client.ClientBundle.Source");
                if (typeName.equals(sourceAnnotationSimpleName)) {
                    return true;
                }
            }
            return false;
        }

        private static boolean shouldValidateType(TypeDeclaration type) {
            if (!type.isInterface()) {
                return false;
            }
            ITypeBinding typeBinding = type.resolveBinding();
            if (typeBinding == null) {
                return false;
            }
            if (!ClientBundleUtilities.isClientBundle(typeBinding)) {
                return false;
            }
            String typeName = typeBinding.getQualifiedName();
            return !typeName.equals("com.google.gwt.resources.client.ClientBundle") && !typeName.equals("com.google.gwt.resources.client.ClientBundleWithLookup");
        }

        public ClientBundleValidationVisitor(IJavaProject javaProject) {
            this.javaProject = javaProject;
        }

        public ClientBundleValidationResult getResult() {
            return this.result;
        }

        public boolean visit(TypeDeclaration type) {
            if (!ClientBundleValidationVisitor.shouldValidateType(type)) {
                return true;
            }
            CompilationUnit cu = (CompilationUnit)type.getRoot();
            MethodDeclaration[] methodDeclarationArray = type.getMethods();
            int n = methodDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration methodDecl = methodDeclarationArray[n2];
                if (!JavaASTUtils.hasErrors((ASTNode)methodDecl, (IProblem[])cu.getProblems())) {
                    this.validateReturnType(methodDecl);
                    this.validateParameterList(methodDecl);
                    this.validateResourceFile(methodDecl);
                }
                ++n2;
            }
            return true;
        }

        private void validateParameterList(MethodDeclaration methodDecl) {
            if (methodDecl.parameters().size() > 0) {
                this.result.addProblem((CategorizedProblem)ClientBundleProblem.createNonEmptyParameterList(methodDecl));
            }
        }

        private void validateResourceFile(MethodDeclaration methodDecl) {
            ITypeBinding returnTypeBinding = ClientBundleValidationVisitor.getReturnTypeBinding(methodDecl);
            if (returnTypeBinding == null || !ClientBundleUtilities.isResourceType(returnTypeBinding) || ClientBundleUtilities.isGwtCreateResource(returnTypeBinding)) {
                return;
            }
            try {
                List modifiers = (List)methodDecl.getStructuralProperty((StructuralPropertyDescriptor)methodDecl.getModifiersProperty());
                for (ASTNode node : modifiers) {
                    if (!ClientBundleValidationVisitor.isSourceAnnotation(node)) continue;
                    this.validateSourceAnnotationValues((Annotation)node);
                    return;
                }
                String resourceTypeName = returnTypeBinding.getErasure().getQualifiedName();
                IType resourceType = JavaModelSearch.findType((IJavaProject)this.javaProject, (String)resourceTypeName);
                if (resourceType == null) {
                    GWTPluginLog.logError("Could not find type " + resourceTypeName);
                    return;
                }
                IPath pckgPath = ClientBundleValidationVisitor.getPackagePath((ASTNode)methodDecl);
                String methodName = methodDecl.getName().getIdentifier();
                String[] defaultExtensions = ResourceTypeDefaultExtensions.getDefaultExtensions((IType)resourceType);
                if (defaultExtensions.length > 0) {
                    HashSet<IPath> possibleResourcePaths = new HashSet<IPath>();
                    String[] stringArray = defaultExtensions;
                    int n = defaultExtensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String defaultExtension = stringArray[n2];
                        possibleResourcePaths.add(pckgPath.append(String.valueOf(methodName) + defaultExtension));
                        ++n2;
                    }
                    this.result.addAllPossibleResourcePaths(possibleResourcePaths);
                    for (IPath possibleResourcePath : possibleResourcePaths) {
                        if (!ClasspathResourceUtilities.isResourceOnClasspath((IJavaProject)this.javaProject, (IPath)possibleResourcePath)) continue;
                        return;
                    }
                } else {
                    this.result.addProblem((CategorizedProblem)ClientBundleProblem.createSourceAnnotationRequired(methodDecl, resourceType.getFullyQualifiedName()));
                    return;
                }
                String expectedFileName = ClientBundleValidationVisitor.computeExpectedFileNameArgument(methodName, defaultExtensions);
                this.result.addProblem((CategorizedProblem)ClientBundleProblem.createMissingResourceFile((ASTNode)methodDecl.getName(), expectedFileName, pckgPath));
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
            }
        }

        private void validateReturnType(MethodDeclaration methodDecl) {
            ITypeBinding returnTypeBinding = ClientBundleValidationVisitor.getReturnTypeBinding(methodDecl);
            if (returnTypeBinding == null) {
                return;
            }
            if (ClientBundleUtilities.isResourceType(returnTypeBinding) || ClientBundleUtilities.isClientBundle(returnTypeBinding)) {
                return;
            }
            this.result.addProblem((CategorizedProblem)ClientBundleProblem.createInvalidReturnType(methodDecl.getReturnType2()));
        }

        private void validateSourceAnnotationValue(StringLiteral literalNode) throws JavaModelException {
            String value = literalNode.getLiteralValue();
            Path literalPath = new Path(value);
            this.result.addPossibleResourcePath((IPath)literalPath);
            IPath fullResourcePathIfPackageRelative = ClientBundleValidationVisitor.getPackagePath((ASTNode)literalNode).append((IPath)literalPath);
            this.result.addPossibleResourcePath(fullResourcePathIfPackageRelative);
            if (ClasspathResourceUtilities.isResourceOnClasspath((IJavaProject)this.javaProject, (IPath)literalPath)) {
                return;
            }
            if (!ClasspathResourceUtilities.isResourceOnClasspath((IJavaProject)this.javaProject, (IPath)fullResourcePathIfPackageRelative)) {
                IPath expectedResourcePath = ClientBundleValidationVisitor.computeMissingResourceExpectedPath((IPath)literalPath, fullResourcePathIfPackageRelative);
                ClientBundleProblem problem = ClientBundleProblem.createMissingResourceFile((ASTNode)literalNode, literalPath.lastSegment(), expectedResourcePath.removeLastSegments(1));
                this.result.addProblem((CategorizedProblem)problem);
            }
        }

        private void validateSourceAnnotationValues(Annotation annotation) throws JavaModelException {
            Expression exp = JavaASTUtils.getAnnotationValue((Annotation)annotation);
            if (exp == null) {
                return;
            }
            if (exp instanceof StringLiteral) {
                this.validateSourceAnnotationValue((StringLiteral)exp);
            }
            if (exp instanceof ArrayInitializer) {
                ArrayInitializer array = (ArrayInitializer)exp;
                for (Expression item : array.expressions()) {
                    if (!(item instanceof StringLiteral)) continue;
                    this.validateSourceAnnotationValue((StringLiteral)item);
                }
            }
        }
    }
}

