/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.java;

import com.google.gdt.eclipse.core.BuilderUtilities;
import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.validation.ValidationResult;
import com.google.gwt.dev.util.Empty;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResourceDependencyIndex;
import com.google.gwt.eclipse.core.markers.GWTJavaProblem;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.search.IIndexedJavaRef;
import com.google.gwt.eclipse.core.search.IndexedJsniJavaRef;
import com.google.gwt.eclipse.core.search.JavaRefIndex;
import com.google.gwt.eclipse.core.search.JsniJavaRefParamType;
import com.google.gwt.eclipse.core.uibinder.model.UiBinderSubtypeToOwnerIndex;
import com.google.gwt.eclipse.core.uibinder.model.UiBinderSubtypeToUiXmlIndex;
import com.google.gwt.eclipse.core.uibinder.model.reference.UiBinderReferenceManager;
import com.google.gwt.eclipse.core.uibinder.validators.UiBinderJavaValidator;
import com.google.gwt.eclipse.core.validators.clientbundle.ClientBundleValidator;
import com.google.gwt.eclipse.core.validators.java.JavaValidationResult;
import com.google.gwt.eclipse.core.validators.java.JavaValidationVisitor;
import com.google.gwt.eclipse.core.validators.java.JsniJavaRef;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.dom.ASTBatchParser;

public class JavaCompilationParticipant
extends CompilationParticipant {
    private static final String[] NO_STRINGS = new String[0];
    private static final CategorizedProblem[] EMPTY_PROBLEMS = new CategorizedProblem[0];
    private static final ICompilationUnit[] NO_UNITS = new ICompilationUnit[0];
    private static final Map<IProject, Job> validationJobs = new HashMap<IProject, Job>();

    public static void cleanBuildArtifacts(IProject project) {
        try {
            project.deleteMarkers("com.gwtplugins.gwt.eclipse.core.javaProblemMarker", true, 2);
            JavaRefIndex.getInstance().clear(project);
            ClientBundleResourceDependencyIndex.getInstance().clear(project);
            UiBinderReferenceManager.INSTANCE.getReferenceManager().removeSourceReferences(project);
            UiBinderReferenceManager.INSTANCE.getSubtypeToOwnerIndex().clear(project);
            UiBinderReferenceManager.INSTANCE.getSubtypeToUiXmlIndex().clear(project);
            UiBinderReferenceManager.INSTANCE.getUiXmlReferencedFieldIndex().clear(JavaCore.create((IProject)project));
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
        }
    }

    public static JavaValidationResult validateCompilationUnit(ASTNode ast) {
        ICompilationUnit cu = JavaASTUtils.getCompilationUnit((ASTNode)ast);
        if (!cu.getJavaProject().isOnClasspath((IJavaElement)cu)) {
            return new JavaValidationResult();
        }
        JavaValidationVisitor visitor = new JavaValidationVisitor();
        ast.accept((ASTVisitor)visitor);
        if (cu.getOwner() == null) {
            List<JsniJavaRef> jsniJavaRefs = visitor.getValidationResult().getJavaRefs();
            JavaCompilationParticipant.indexJavaRefs(cu, jsniJavaRefs);
        }
        return visitor.getValidationResult();
    }

    private static void indexJavaRefs(ICompilationUnit cu, List<JsniJavaRef> jsniRefs) {
        HashSet<IIndexedJavaRef> indexRefs = new HashSet<IIndexedJavaRef>(jsniRefs.size());
        for (JsniJavaRef jsniRef : jsniRefs) {
            int paramTypeOffset;
            indexRefs.add(new IndexedJsniJavaRef(jsniRef));
            if (!jsniRef.isMethod() || jsniRef.matchesAnyOverload() || (paramTypeOffset = jsniRef.getParamTypesOffset()) <= -1) continue;
            String[] stringArray = jsniRef.paramTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String paramType = stringArray[n2];
                JsniJavaRefParamType paramTypeRef = JsniJavaRefParamType.parse(jsniRef.getSource(), paramTypeOffset, paramType);
                if (paramTypeRef != null) {
                    indexRefs.add(paramTypeRef);
                }
                paramTypeOffset += paramType.length();
                ++n2;
            }
        }
        JavaRefIndex.getInstance().add(cu.getPath(), indexRefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStarting(final BuildContext[] files, boolean isBatch) {
        if (isBatch) {
            assert (files.length > 0);
            IProject project = files[0].getFile().getProject();
            JavaCompilationParticipant javaCompilationParticipant = this;
            synchronized (javaCompilationParticipant) {
                Job job = validationJobs.get(project);
                if (job != null) {
                    job.cancel();
                }
                job = new Job("Validating GWT components"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("validating", files.length);
                        JavaCompilationParticipant.this.handleBuildStarting(files, monitor);
                        monitor.done();
                        return new JobStatus(0, (Job)this, "done");
                    }
                };
                validationJobs.put(project, job);
                job.schedule();
            }
        } else {
            this.handleBuildStarting(files, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanStarting(IJavaProject project) {
        JavaCompilationParticipant javaCompilationParticipant = this;
        synchronized (javaCompilationParticipant) {
            Job buildJob = validationJobs.get(project.getProject());
            if (buildJob != null) {
                buildJob.cancel();
            }
        }
        JavaCompilationParticipant.cleanBuildArtifacts(project.getProject());
    }

    public boolean isActive(IJavaProject project) {
        boolean active = project.exists() && GWTNature.isGWTProject(project.getProject());
        return active;
    }

    public void reconcile(ReconcileContext context) {
        ICompilationUnit cu = context.getWorkingCopy();
        try {
            CompilationUnit ast = null;
            try {
                ast = context.getAST4();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (ast == null) {
                GWTPluginLog.logError("Could not get AST for " + cu.getPath());
                return;
            }
            CategorizedProblem[] currentProblems = context.getProblems("com.gwtplugins.gwt.eclipse.core.javaProblemMarker");
            JavaValidationResult result = JavaCompilationParticipant.validateCompilationUnit((ASTNode)ast);
            List<GWTJavaProblem> gwtCoreProblems = result.getProblems();
            ArrayList<Object> finalProblemSet = new ArrayList<Object>();
            if (currentProblems != null) {
                finalProblemSet.addAll(Arrays.asList(currentProblems));
            }
            finalProblemSet.addAll(gwtCoreProblems);
            context.putProblems("com.gwtplugins.gwt.eclipse.core.javaProblemMarker", finalProblemSet.size() > 0 ? finalProblemSet.toArray(EMPTY_PROBLEMS) : null);
            RemoteServiceValidator rsv = new RemoteServiceValidator();
            ValidationResult validationResult = rsv.validate((ASTNode)ast);
            List rpcProblems = validationResult.getProblems();
            context.putProblems("com.gwtplugins.gwt.eclipse.core.rpcProblemMarker", rpcProblems.size() > 0 ? rpcProblems.toArray(EMPTY_PROBLEMS) : null);
            ClientBundleValidator cbv = new ClientBundleValidator();
            ValidationResult cbvResult = cbv.validate(ast);
            List cbProblems = cbvResult.getProblems();
            context.putProblems("com.gwtplugins.gwt.eclipse.core.clientBundleProblemMarker", cbProblems.size() > 0 ? cbProblems.toArray(EMPTY_PROBLEMS) : null);
            UiBinderJavaValidator uiv = new UiBinderJavaValidator(ast, new UiBinderSubtypeToOwnerIndex(UiBinderReferenceManager.INSTANCE.getSubtypeToOwnerIndex()), new UiBinderSubtypeToUiXmlIndex(UiBinderReferenceManager.INSTANCE.getSubtypeToUiXmlIndex()), UiBinderReferenceManager.INSTANCE.getUiXmlReferencedFieldIndex(), null);
            ValidationResult uivResult = uiv.validate();
            List uivProblems = uivResult.getProblems();
            context.putProblems("com.gwtplugins.gwt.eclipse.core.uiBinderJavaProblemMarker", uivProblems.size() > 0 ? uivProblems.toArray(EMPTY_PROBLEMS) : null);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            GWTPluginLog.logError(e, "Unexpected error while validating {0}", cu.getElementName());
        }
    }

    private void handleBuildStarting(BuildContext[] files, final IProgressMonitor monitor) {
        UiBinderSubtypeToOwnerIndex prebuildOwnerIndex = new UiBinderSubtypeToOwnerIndex(UiBinderReferenceManager.INSTANCE.getSubtypeToOwnerIndex());
        final LinkedHashMap<ICompilationUnit, BuildContext> compilationUnitToBuildContext = new LinkedHashMap<ICompilationUnit, BuildContext>();
        BuildContext[] buildContextArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            BuildContext buildContext = buildContextArray[n2];
            ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)buildContext.getFile());
            compilationUnitToBuildContext.put(cu, buildContext);
            ++n2;
        }
        final HashSet<ICompilationUnit> validatedCompilationUnits = new HashSet<ICompilationUnit>();
        new ASTBatchParser().createASTs(compilationUnitToBuildContext.keySet().toArray(NO_UNITS), NO_STRINGS, new ASTRequestor(){

            public void acceptAST(ICompilationUnit source, CompilationUnit ast) {
                BuildContext buildContext = (BuildContext)compilationUnitToBuildContext.get(source);
                IFile file = buildContext.getFile();
                if (monitor != null) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.subTask(source.getElementName());
                    monitor.worked(1);
                }
                try {
                    ICompilationUnit cu = source;
                    validatedCompilationUnits.add(cu);
                    try {
                        if (!cu.isConsistent()) {
                            ast = cu.reconcile(4, true, null, null);
                            if (!$assertionsDisabled && !cu.isConsistent()) {
                                throw new AssertionError();
                            }
                        }
                    }
                    catch (JavaModelException e) {
                        GWTPluginLog.logError(e);
                        return;
                    }
                    JavaValidationResult result = JavaCompilationParticipant.validateCompilationUnit((ASTNode)ast);
                    ArrayList<GWTJavaProblem> problems = new ArrayList<GWTJavaProblem>(result.getProblems());
                    RemoteServiceValidator rsv = new RemoteServiceValidator();
                    ValidationResult validationResult = rsv.validate((ASTNode)ast);
                    problems.addAll(validationResult.getProblems());
                    ClientBundleValidator cbv = new ClientBundleValidator();
                    ValidationResult cbvResult = cbv.validate(ast);
                    problems.addAll(cbvResult.getProblems());
                    UiBinderJavaValidator uiv = new UiBinderJavaValidator(ast, UiBinderReferenceManager.INSTANCE.getSubtypeToOwnerIndex(), UiBinderReferenceManager.INSTANCE.getSubtypeToUiXmlIndex(), UiBinderReferenceManager.INSTANCE.getUiXmlReferencedFieldIndex(), UiBinderReferenceManager.INSTANCE.getReferenceManager());
                    ValidationResult uivResult = uiv.validate();
                    problems.addAll(uivResult.getProblems());
                    buildContext.recordNewProblems(problems.toArray(EMPTY_PROBLEMS));
                    ArrayList<String> typeDependencies = new ArrayList<String>();
                    for (JsniJavaRef javaRef : result.getJavaRefs()) {
                        if (typeDependencies.contains(javaRef.dottedClassName())) continue;
                        typeDependencies.add(javaRef.dottedClassName());
                    }
                    typeDependencies.addAll(validationResult.getTypeDependencies());
                    typeDependencies.addAll(uivResult.getTypeDependencies());
                    buildContext.recordDependencies(typeDependencies.toArray(Empty.STRINGS));
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    GWTPluginLog.logError(e, "Unexpected error while validating {0}", file.getName());
                }
            }
        }, null);
        this.revalidateOwnerTypes(prebuildOwnerIndex, validatedCompilationUnits);
    }

    private void revalidateOwnerTypes(UiBinderSubtypeToOwnerIndex preBuildOwnerIndex, Set<ICompilationUnit> validatedCompilationUnits) {
        UiBinderSubtypeToOwnerIndex postBuildOwnerIndex = UiBinderReferenceManager.INSTANCE.getSubtypeToOwnerIndex();
        HashSet<UiBinderSubtypeToOwnerIndex.UiBinderSubtypeAndOwner> subtypesAndOwners = new HashSet<UiBinderSubtypeToOwnerIndex.UiBinderSubtypeAndOwner>(postBuildOwnerIndex.getAllUiBinderTypesAndOwners());
        subtypesAndOwners.addAll(preBuildOwnerIndex.getAllUiBinderTypesAndOwners());
        HashSet<ICompilationUnit> cusToTouch = new HashSet<ICompilationUnit>();
        for (UiBinderSubtypeToOwnerIndex.UiBinderSubtypeAndOwner entry : subtypesAndOwners) {
            ICompilationUnit compilationUnit;
            IType ownerType;
            if (!validatedCompilationUnits.contains(entry.getUiBinderType().getCompilationUnit()) || (ownerType = entry.findOwnerType()) == null || entry.hasCommonCompilationUnit() || (compilationUnit = ownerType.getCompilationUnit()) == null || !compilationUnit.exists()) continue;
            cusToTouch.add(compilationUnit);
        }
        if (!cusToTouch.isEmpty()) {
            BuilderUtilities.revalidateCompilationUnits(cusToTouch, (String)"Revalidating UiBinder owner classes");
        }
    }
}

