/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.java;

import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.dev.util.JsniRef;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.markers.GWTProblemType;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.validators.java.UnresolvedJsniJavaRefException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;

public class JsniJavaRef
extends JsniRef {
    public static String CTOR_NAME = "new";
    private int offset = 0;
    private IPath source = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsniJavaRef findEnclosingJavaRef(ITextSelection sel, ITextSelection jsniBlock, IDocument document) {
        boolean enteredParamTypes;
        int end;
        int jsniEnd;
        int start;
        try {
            int jsniStart = jsniBlock.getOffset();
            start = sel.getOffset();
            while (true) {
                if (start <= jsniStart) {
                    return null;
                }
                if (document.getChar(start) == '@') {
                    jsniEnd = jsniBlock.getOffset() + jsniBlock.getLength();
                    end = sel.getOffset() + sel.getLength() - 1;
                    enteredParamTypes = false;
                    break;
                }
                --start;
            }
        }
        catch (BadLocationException e) {
            return null;
        }
        while (true) {
            if (end >= jsniEnd) {
                return null;
            }
            char ch = document.getChar(end++);
            if (!enteredParamTypes) {
                String javaRefSoFar;
                if (ch == '@' || Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '$' || ch == ':') continue;
                if (ch == '(') {
                    enteredParamTypes = true;
                    continue;
                }
                if (ch == ')' && (javaRefSoFar = document.get(start, end - start)).indexOf(40) > -1) {
                    return JsniJavaRef.parse(document.get(start, end - start));
                }
                return JsniJavaRef.parse(document.get(start, --end - start));
            }
            if (ch == ')') break;
        }
        return JsniJavaRef.parse(document.get(start, end - start));
    }

    public static JsniJavaRef parse(String refString) {
        JsniRef ref = JsniRef.parse((String)refString);
        if (ref == null) {
            return null;
        }
        return new JsniJavaRef(ref);
    }

    public JsniJavaRef(JsniJavaRef ref) {
        this((JsniRef)ref);
        this.source = ref.source;
        this.offset = ref.offset;
    }

    private JsniJavaRef(JsniRef ref) {
        super(ref.className(), 0, ref.memberName(), ref.paramTypesString(), ref.isMethod() && !ref.matchesAnyOverload() ? ref.paramTypes() : null);
    }

    public String dottedClassName() {
        return this.className().replace('$', '.');
    }

    public boolean equals(Object obj) {
        return obj instanceof JsniJavaRef && this.toString().equals(obj.toString());
    }

    public int getClassOffset() {
        return this.offset + 1;
    }

    public int getMemberOffset() {
        return this.getClassOffset() + this.className().length() + 2;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getParamTypesOffset() {
        if (this.paramTypesString() == null) {
            return -1;
        }
        return this.getMemberOffset() + this.memberName().length() + 1;
    }

    public IPath getSource() {
        return this.source;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isConstructor() {
        return this.isMethod() && CTOR_NAME.equals(this.memberName());
    }

    public String readableMemberSignature() {
        String sig = this.memberName();
        if (this.isMethod()) {
            if (this.isConstructor()) {
                sig = this.dottedClassName();
            }
            ArrayList<String> readableParamTypes = new ArrayList<String>();
            if (this.matchesAnyOverload()) {
                readableParamTypes.add("*");
            } else {
                String[] stringArray = this.paramTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String paramType = stringArray[n2];
                    paramType = paramType.replace('/', '.');
                    paramType = Signature.toString((String)paramType);
                    readableParamTypes.add(paramType);
                    ++n2;
                }
            }
            sig = String.valueOf(sig) + "(" + Util.join(readableParamTypes, ", ") + ")";
        }
        return sig;
    }

    public IJavaElement resolveJavaElement(IJavaProject project) throws UnresolvedJsniJavaRefException {
        ITypeHierarchy hierarchy;
        IField element = null;
        if (this.className().equals("null")) {
            throw new UnresolvedJsniJavaRefException(null, this);
        }
        IType type = JavaModelSearch.findType((IJavaProject)project, (String)this.dottedClassName());
        if (type == null) {
            throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_UNRESOLVED_TYPE, this);
        }
        if (type.isBinary()) {
            IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)type.getAncestor(3);
            try {
                IClasspathEntry cpEntry = pkgRoot.getRawClasspathEntry();
                if (cpEntry.getEntryKind() == 5 && cpEntry.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                    throw new UnresolvedJsniJavaRefException(null, this);
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
                throw new UnresolvedJsniJavaRefException(null, this);
            }
        }
        try {
            hierarchy = type.newSupertypeHierarchy(null);
        }
        catch (JavaModelException e) {
            GWTPluginLog.logError(e, "Error creating type hierarchy for " + this.className());
            throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_UNRESOLVED_TYPE, this);
        }
        if (this.isMethod()) {
            if (this.isConstructor()) {
                if (this.matchesAnyOverload()) {
                    element = JavaModelSearch.findFirstCtor((IType)type);
                } else {
                    String[] ctorParamTypes = this.paramTypes();
                    try {
                        IJavaElement typeParent = type.getParent();
                        if (typeParent.getElementType() == 7 && !Flags.isStatic((int)type.getFlags())) {
                            String enclosingTypeParam;
                            if (ctorParamTypes.length == 0) {
                                throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_NO_MATCHING_CTOR, this);
                            }
                            IType parentType = (IType)typeParent;
                            String enclosingTypeName = parentType.getFullyQualifiedName('.');
                            if (!enclosingTypeName.equals(enclosingTypeParam = JavaModelSearch.getQualifiedTypeName((String)ctorParamTypes[0]))) {
                                throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_NO_MATCHING_CTOR, this);
                            }
                            ctorParamTypes = new String[this.paramTypes().length - 1];
                            System.arraycopy(this.paramTypes(), 1, ctorParamTypes, 0, ctorParamTypes.length);
                        }
                    }
                    catch (JavaModelException e) {
                        GWTPluginLog.logError(e);
                    }
                    if ((element = JavaModelSearch.findCtorInHierarchy((ITypeHierarchy)hierarchy, (IType)type, (String[])ctorParamTypes)) == null) {
                        throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_NO_MATCHING_CTOR, this);
                    }
                }
            } else {
                element = JavaModelSearch.findMethodInHierarchy((ITypeHierarchy)hierarchy, (IType)type, (String)this.memberName());
                if (element == null) {
                    try {
                        if (type.isEnum() && this.memberName().equals("values") && !this.matchesAnyOverload() && this.paramTypes().length == 0) {
                            throw new UnresolvedJsniJavaRefException(null, this);
                        }
                    }
                    catch (JavaModelException e) {
                        GWTPluginLog.logError(e);
                    }
                    throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_MISSING_METHOD, this);
                }
                if (!this.matchesAnyOverload() && (element = JavaModelSearch.findMethodInHierarchy((ITypeHierarchy)hierarchy, (IType)type, (String)this.memberName(), (String[])this.paramTypes())) == null) {
                    try {
                        if (type.isEnum() && this.memberName().equals("valueOf") && this.paramTypes().length == 1 && this.paramTypes()[0].equals("Ljava/lang/String;")) {
                            throw new UnresolvedJsniJavaRefException(null, this);
                        }
                    }
                    catch (JavaModelException e) {
                        GWTPluginLog.logError(e);
                    }
                    throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_NO_MATCHING_METHOD, this);
                }
            }
        } else {
            assert (this.isField());
            element = JavaModelSearch.findFieldInHierarchy((ITypeHierarchy)hierarchy, (IType)type, (String)this.memberName());
            if (element == null) {
                throw new UnresolvedJsniJavaRefException(GWTProblemType.JSNI_JAVA_REF_MISSING_FIELD, this);
            }
        }
        assert (element != null);
        return element;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setSource(IPath source) {
        this.source = source;
    }

    public String simpleClassName() {
        String[] classParts = this.dottedClassName().split("\\.");
        return classParts[classParts.length - 1];
    }
}

