/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.java;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.CorrelationFactory;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.js.JsParser;
import com.google.gwt.dev.js.JsParserException;
import com.google.gwt.dev.js.ast.JsBlock;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsExprStmt;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsProgram;
import com.google.gwt.dev.js.ast.JsScope;
import com.google.gwt.dev.js.ast.JsVisitable;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.markers.GWTJavaProblem;
import com.google.gwt.eclipse.core.markers.GWTProblemType;
import com.google.gwt.eclipse.core.validators.java.JavaValidationResult;
import com.google.gwt.eclipse.core.validators.java.JsniJavaRef;
import com.google.gwt.eclipse.core.validators.java.UnresolvedJsniJavaRefException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public final class JsniParser {
    public static final String JSNI_BLOCK_END = "}-*/";
    public static final String JSNI_BLOCK_START = "/*-{";
    private static final String JS_FUNCTION_FOOTER = "}";
    private static final String JS_FUNCTION_HEADER = "function(){";

    public static String extractMethodBody(String jsniMethod) {
        int startPos = jsniMethod.indexOf(JSNI_BLOCK_START);
        int endPos = jsniMethod.lastIndexOf(JSNI_BLOCK_END);
        if (startPos < 0 || endPos < 0) {
            return null;
        }
        return jsniMethod.substring(startPos += JSNI_BLOCK_START.length(), endPos);
    }

    public static ITypedRegion getEnclosingJsniRegion(ITextSelection selection, IDocument document) {
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)"___gwt_partitioning", (int)selection.getOffset(), (boolean)false);
            if (region.getType().equals("__jsni_method")) {
                int regionEnd = region.getOffset() + region.getLength();
                int selectionEnd = selection.getOffset() + selection.getLength();
                if (region.getOffset() <= selection.getOffset() && regionEnd >= selectionEnd) {
                    return region;
                }
            }
        }
        catch (BadLocationException e) {
            GWTPluginLog.logError(e);
        }
        return null;
    }

    public static JavaValidationResult parse(MethodDeclaration method) {
        JavaValidationResult result = new JavaValidationResult();
        try {
            try {
                result.addAllJavaRefs(JsniParser.findJavaRefs(method));
                for (JsniJavaRef ref : result.getJavaRefs()) {
                    GWTJavaProblem problem = JsniParser.validateJavaRef(method, ref);
                    if (problem == null) continue;
                    result.addProblem(problem);
                }
            }
            catch (JavaScriptParseException e) {
                int offset = e.getOffset() + method.getStartPosition();
                result.addProblem(GWTJavaProblem.create((ASTNode)method, offset, 1, GWTProblemType.JSNI_PARSE_ERROR, e.getMessage()));
            }
            catch (IOException e) {
                GWTPluginLog.logError(e, "IO error while parsing JSNI method " + method.getName());
            }
            catch (InternalCompilerException e) {
                String errorMsg = "Unexpected error parsing JSNI method " + method.getName() + ": " + e.getMessage();
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                GWTPluginLog.logError(cause, errorMsg);
            }
        }
        catch (BadLocationException e) {
            GWTPluginLog.logError(e, "Error translating JS parse error location in " + method.getName());
        }
        return result;
    }

    public static JsBlock parse(String jsniMethod) throws IOException, BadLocationException, JavaScriptParseException {
        String jsni = JsniParser.extractMethodBody(jsniMethod);
        if (jsni == null) {
            return null;
        }
        jsni = JS_FUNCTION_HEADER + jsni + JS_FUNCTION_FOOTER;
        try {
            return JsniParser.parseFunctionBlock(jsni, 0);
        }
        catch (JsParserException e) {
            JsParserException.SourceDetail source = e.getSourceDetail();
            DefaultLineTracker lineTracker = new DefaultLineTracker();
            lineTracker.set(jsni);
            int offset = lineTracker.getLineOffset(source.getLine()) + source.getLineOffset() - 1;
            offset -= JS_FUNCTION_HEADER.length();
            offset += jsniMethod.indexOf(JSNI_BLOCK_START);
            offset += JSNI_BLOCK_START.length();
            String errorMessage = e.getMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                char[] errorChars = e.getMessage().toCharArray();
                errorChars[0] = Character.toUpperCase(errorChars[0]);
                errorMessage = new String(errorChars);
            }
            throw new JavaScriptParseException(errorMessage, offset);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private static List<JsniJavaRef> findJavaRefs(final MethodDeclaration jsniMethod) throws IOException, JavaScriptParseException, BadLocationException {
        final String jsniSource = JavaASTUtils.getSource((ASTNode)jsniMethod);
        ICompilationUnit cu = JavaASTUtils.getCompilationUnit((ASTNode)jsniMethod);
        final IPath cuPath = cu.getResource().getFullPath();
        final ArrayList<JsniJavaRef> javaRefs = new ArrayList<JsniJavaRef>();
        JsBlock js = JsniParser.parse(jsniSource);
        if (js != null) {
            new JsVisitor(){

                public void endVisit(JsNameRef x, JsContext ctx) {
                    JsniJavaRef javaRef;
                    String ident = x.getIdent();
                    if (ident.indexOf("@") != -1 && (javaRef = JsniJavaRef.parse(ident)) != null) {
                        javaRef.setSource(cuPath);
                        int fromIndex = 0;
                        if (javaRefs.size() > 0) {
                            fromIndex = ((JsniJavaRef)((Object)javaRefs.get(javaRefs.size() - 1))).getOffset() - jsniMethod.getStartPosition() + 1;
                        }
                        int offset = jsniSource.indexOf(ident, fromIndex) + jsniMethod.getStartPosition();
                        javaRef.setOffset(offset);
                        javaRefs.add(javaRef);
                    }
                }
            }.accept((JsVisitable)js);
        }
        return javaRefs;
    }

    private static JsBlock parseFunctionBlock(String js, final int startLine) throws JsParserException, IOException, NullPointerException {
        JsProgram jsPgm = new JsProgram();
        StringReader r = new StringReader(js);
        List stmts = JsParser.parse((SourceInfo)new SourceInfoAdapter(){

            @Override
            public int getStartLine() {
                return startLine;
            }
        }, (JsScope)jsPgm.getScope(), (Reader)r);
        JsFunction fn = (JsFunction)((JsExprStmt)stmts.get(0)).getExpression();
        return fn.getBody();
    }

    private static GWTJavaProblem validateJavaRef(MethodDeclaration jsniMethod, JsniJavaRef ref) {
        ICompilationUnit cu = JavaASTUtils.getCompilationUnit((ASTNode)jsniMethod);
        try {
            ref.resolveJavaElement(cu.getJavaProject());
            return null;
        }
        catch (UnresolvedJsniJavaRefException e) {
            if (e.getProblemType() == null) {
                return null;
            }
            int offset = 0;
            int length = 0;
            String[] messageArgs = new String[]{};
            switch (e.getProblemType()) {
                case JSNI_JAVA_REF_UNRESOLVED_TYPE: {
                    offset = ref.getClassOffset();
                    length = ref.className().length();
                    messageArgs = new String[]{ref.className()};
                    break;
                }
                case JSNI_JAVA_REF_NO_MATCHING_CTOR: {
                    offset = ref.getMemberOffset();
                    length = ref.memberName().length();
                    messageArgs = new String[]{ref.readableMemberSignature(), ref.simpleClassName()};
                    break;
                }
                case JSNI_JAVA_REF_MISSING_METHOD: {
                    offset = ref.getMemberOffset();
                    length = ref.memberName().length();
                    messageArgs = new String[]{ref.simpleClassName(), ref.memberName()};
                    break;
                }
                case JSNI_JAVA_REF_NO_MATCHING_METHOD: {
                    offset = ref.getMemberOffset();
                    length = ref.memberName().length();
                    messageArgs = new String[]{ref.readableMemberSignature(), ref.simpleClassName()};
                    break;
                }
                case JSNI_JAVA_REF_MISSING_FIELD: {
                    offset = ref.getMemberOffset();
                    length = ref.memberName().length();
                    messageArgs = new String[]{ref.className(), ref.memberName()};
                    break;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
            return GWTJavaProblem.create((ASTNode)jsniMethod, offset, length, e.getProblemType(), messageArgs);
        }
    }

    private JsniParser() {
    }

    public static class JavaScriptParseException
    extends Exception {
        private final int offset;

        public JavaScriptParseException(String message, int offset) {
            super(message);
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    private static class SourceInfoAdapter
    implements SourceInfo {
        private SourceInfoAdapter() {
        }

        public void addCorrelation(Correlation c) {
        }

        public void copyMissingCorrelationsFrom(SourceInfo other) {
        }

        public List<Correlation> getAllCorrelations() {
            return Collections.emptyList();
        }

        public List<Correlation> getAllCorrelations(Correlation.Axis axis) {
            return Collections.emptyList();
        }

        public int getEndPos() {
            return -1;
        }

        public String getFileName() {
            return "unknown";
        }

        public Correlation getPrimaryCorrelation(Correlation.Axis axis) {
            return null;
        }

        public Set<Correlation> getPrimaryCorrelations() {
            return Collections.emptySet();
        }

        public Correlation[] getPrimaryCorrelationsArray() {
            return null;
        }

        public int getStartLine() {
            return -1;
        }

        public int getStartPos() {
            return -1;
        }

        public SourceInfo makeChild(Class<?> caller, String description) {
            return this;
        }

        public SourceInfo makeChild(Class<?> caller, String description, SourceInfo ... merge) {
            return this;
        }

        public void merge(SourceInfo ... sourceInfos) {
        }

        public Correlation getCorrelation(Correlation.Axis axis) {
            return null;
        }

        public Correlation[] getCorrelations() {
            return null;
        }

        public CorrelationFactory getCorrelator() {
            return null;
        }

        public SourceOrigin getOrigin() {
            return null;
        }

        public SourceInfo makeChild() {
            return null;
        }

        public SourceInfo makeChild(SourceOrigin origin) {
            return null;
        }
    }
}

