/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.eclipse.core.validators.rpc.PairedInterfaceValidator;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.TypeRules;

abstract class AbstractPairedInterfaceValidator
implements PairedInterfaceValidator {
    AbstractPairedInterfaceValidator() {
    }

    protected static boolean canAssign(ITypeBinding lhs, ITypeBinding rhs) {
        if (AbstractPairedInterfaceValidator.containsTypeVariableReferences(lhs) || AbstractPairedInterfaceValidator.containsTypeVariableReferences(rhs)) {
            lhs = lhs.getErasure();
            rhs = rhs.getErasure();
        }
        if (lhs.isArray() && rhs.isArray() && lhs.getDimensions() == rhs.getDimensions()) {
            while (lhs.isArray()) {
                lhs = lhs.getComponentType();
            }
            while (rhs.isArray()) {
                rhs = rhs.getComponentType();
            }
            if (lhs.isPrimitive() && rhs.isPrimitive()) {
                return lhs.getKey().equals(rhs.getKey());
            }
        }
        return TypeRules.canAssign((ITypeBinding)lhs, (ITypeBinding)rhs);
    }

    protected static boolean containsTypeVariableReferences(ITypeBinding typeBinding) {
        ITypeBinding bound;
        if (typeBinding.isTypeVariable()) {
            return true;
        }
        if (typeBinding.isArray()) {
            return AbstractPairedInterfaceValidator.containsTypeVariableReferences(typeBinding.getComponentType());
        }
        if (typeBinding.isParameterizedType()) {
            ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
            int i = 0;
            while (i < typeArguments.length) {
                if (AbstractPairedInterfaceValidator.containsTypeVariableReferences(typeArguments[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (typeBinding.isWildcardType() && (bound = typeBinding.getBound()) != null) {
            return AbstractPairedInterfaceValidator.containsTypeVariableReferences(bound);
        }
        return false;
    }

    @Override
    public List<CategorizedProblem> validate(TypeDeclaration changedInterface, ITypeBinding dependentTypeBinding) {
        CompilationUnit compilationUnit = this.getCompilationUnit((ASTNode)changedInterface);
        if (JavaASTUtils.hasErrors((ASTNode)changedInterface, (IProblem[])compilationUnit.getProblems())) {
            return Collections.emptyList();
        }
        if (dependentTypeBinding == null) {
            return this.doMissingDependentInterface(changedInterface);
        }
        ArrayList<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
        MethodDeclaration[] methodDeclarationArray = changedInterface.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            List<CategorizedProblem> methodProblems = this.doValidateMethodOnChangedType(methodDeclaration, dependentTypeBinding);
            problems.addAll(methodProblems);
            ++n2;
        }
        ArrayList<ITypeBinding> superTypeBindings = new ArrayList<ITypeBinding>();
        RemoteServiceUtilities.expandSuperInterfaces(dependentTypeBinding, superTypeBindings);
        for (ITypeBinding typeBinding : superTypeBindings) {
            IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
            int n3 = iMethodBindingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethodBinding methodBinding = iMethodBindingArray[n4];
                List<CategorizedProblem> dependentMethodProblems = this.doValidateMethodOnDependentInterface(methodBinding, changedInterface, typeBinding);
                problems.addAll(dependentMethodProblems);
                ++n4;
            }
        }
        return problems;
    }

    protected abstract List<CategorizedProblem> doMissingDependentInterface(TypeDeclaration var1);

    protected abstract List<CategorizedProblem> doValidateMethodOnChangedType(MethodDeclaration var1, ITypeBinding var2);

    protected abstract List<CategorizedProblem> doValidateMethodOnDependentInterface(IMethodBinding var1, TypeDeclaration var2, ITypeBinding var3);

    protected CompilationUnit getCompilationUnit(ASTNode node) {
        ASTNode root = node.getRoot();
        assert (root.getNodeType() == 15);
        return (CompilationUnit)root;
    }
}

