/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.validators.rpc.AbstractPairedInterfaceValidator;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblem;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblemFactory;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.Bindings;

class AsynchronousInterfaceValidator
extends AbstractPairedInterfaceValidator {
    AsynchronousInterfaceValidator() {
    }

    @Override
    public List<CategorizedProblem> validate(TypeDeclaration changedInterface, ITypeBinding dependentTypeBinding) {
        if (dependentTypeBinding != null && !RemoteServiceUtilities.isSynchronousInterface(dependentTypeBinding)) {
            return Collections.emptyList();
        }
        return super.validate(changedInterface, dependentTypeBinding);
    }

    @Override
    protected List<CategorizedProblem> doMissingDependentInterface(TypeDeclaration changedInterface) {
        return Collections.emptyList();
    }

    @Override
    protected List<CategorizedProblem> doValidateMethodOnChangedType(MethodDeclaration methodDeclaration, ITypeBinding dependentTypeBinding) {
        MethodDeclaration node = methodDeclaration;
        IMethodBinding methodBinding = node.resolveBinding();
        List parameters = node.parameters();
        SingleVariableDeclaration lastParameter = parameters.isEmpty() ? null : (SingleVariableDeclaration)parameters.get(parameters.size() - 1);
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        if (!RemoteServiceUtilities.hasAsyncCallbackParameter(parameterTypes)) {
            RemoteServiceProblem problem = RemoteServiceProblemFactory.newNoAsyncCallbackParameter(methodDeclaration);
            if (problem != null) {
                return Collections.singletonList(problem);
            }
            return Collections.emptyList();
        }
        if (!this.hasValidReturnType(methodBinding.getReturnType())) {
            RemoteServiceProblem problem = RemoteServiceProblemFactory.newInvalidAsyncReturnType(methodDeclaration);
            if (problem != null) {
                return Collections.singletonList(problem);
            }
            return Collections.emptyList();
        }
        String[] parameterQualifiedNames = RemoteServiceUtilities.computeSyncParameterTypes(methodBinding);
        String methodName = methodBinding.getName();
        IMethodBinding dependentMethod = Bindings.findMethodInHierarchy((ITypeBinding)dependentTypeBinding, (String)methodName, (String[])parameterQualifiedNames);
        if (dependentMethod == null) {
            RemoteServiceProblem problem = RemoteServiceProblemFactory.newMissingSyncMethodOnAsync(methodDeclaration, dependentTypeBinding);
            if (problem != null) {
                return Collections.singletonList(problem);
            }
            return Collections.emptyList();
        }
        return this.doValidateReturnTypes(node, lastParameter, parameterTypes, dependentMethod);
    }

    @Override
    protected List<CategorizedProblem> doValidateMethodOnDependentInterface(IMethodBinding methodBinding, TypeDeclaration changedInterface, ITypeBinding dependentInterfaceBinding) {
        RemoteServiceProblem problem;
        String[] parameters = RemoteServiceUtilities.computeAsyncParameterTypes(methodBinding);
        String methodName = methodBinding.getName();
        if (Bindings.findMethodInHierarchy((ITypeBinding)changedInterface.resolveBinding(), (String)methodName, (String[])parameters) == null && (problem = RemoteServiceProblemFactory.newMissingAsyncMethodOnAsync(methodBinding, changedInterface)) != null) {
            return Collections.singletonList(problem);
        }
        return Collections.emptyList();
    }

    private List<CategorizedProblem> doValidateReturnTypes(MethodDeclaration node, SingleVariableDeclaration lastParameter, ITypeBinding[] parameterTypes, IMethodBinding dependentMethod) {
        ITypeBinding asyncCallbackParam = parameterTypes[parameterTypes.length - 1];
        if (asyncCallbackParam.isParameterizedType()) {
            ParameterizedType parameterizedType;
            List types;
            RemoteServiceProblem problem;
            ITypeBinding syncReturnTypeBinding;
            ITypeBinding[] typeArguments = asyncCallbackParam.getTypeArguments();
            ITypeBinding typeBinding = syncReturnTypeBinding = dependentMethod.getReturnType();
            if (syncReturnTypeBinding.isPrimitive()) {
                String qualifiedWrapperTypeName = JavaASTUtils.getWrapperTypeName((String)syncReturnTypeBinding.getQualifiedName());
                typeBinding = node.getAST().resolveWellKnownType(qualifiedWrapperTypeName);
            }
            boolean compatible = false;
            if (typeBinding != null) {
                compatible = AsynchronousInterfaceValidator.canAssign(typeArguments[0], typeBinding);
            }
            if (!compatible && (problem = RemoteServiceProblemFactory.newAsyncCallbackTypeArgumentMismatchOnAsync((Type)(types = (parameterizedType = (ParameterizedType)lastParameter.getType()).typeArguments()).get(0), typeArguments[0], syncReturnTypeBinding)) != null) {
                return Collections.singletonList(problem);
            }
        }
        return Collections.emptyList();
    }

    private boolean hasValidReturnType(ITypeBinding returnTypeBinding) {
        return Util.VALID_ASYNC_RPC_RETURN_TYPES.contains(returnTypeBinding.getQualifiedName());
    }
}

