/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblem;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblemType;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;

class RemoteServiceProblemFactory {
    private static final String[] NO_STRINGS = new String[0];

    RemoteServiceProblemFactory() {
    }

    static RemoteServiceProblem newAsyncCallbackTypeArgumentMismatchOnAsync(Type callbackTypeArgument, ITypeBinding callbackTypeArgumentBinding, ITypeBinding syncReturnType) {
        String[] arguments = new String[]{callbackTypeArgumentBinding.getName(), syncReturnType.getName()};
        String[] problemArgs = new String[]{"async"};
        return RemoteServiceProblem.create((ASTNode)callbackTypeArgument, RemoteServiceProblemType.ASYNCCALLBACK_TYPE_ARGUMENT_MISMATCH, arguments, problemArgs);
    }

    static RemoteServiceProblem newAsyncCallbackTypeArgumentMismatchOnSync(MethodDeclaration syncMethodDeclaration, ITypeBinding callbackTypeArgumentBinding) {
        String[] arguments = new String[]{callbackTypeArgumentBinding.getName(), syncMethodDeclaration.resolveBinding().getReturnType().getName()};
        String[] problemArgs = new String[]{"sync"};
        return RemoteServiceProblem.create((ASTNode)syncMethodDeclaration.getReturnType2(), RemoteServiceProblemType.ASYNCCALLBACK_TYPE_ARGUMENT_MISMATCH, arguments, problemArgs);
    }

    static RemoteServiceProblem newInvalidAsyncReturnType(MethodDeclaration methodDeclaration) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int n = Util.VALID_ASYNC_RPC_RETURN_TYPES.size();
        while (i < n) {
            if (i > 0) {
                if (i == n - 1) {
                    sb.append(" or ");
                } else {
                    sb.append(", ");
                }
            }
            String validReturnType = Util.VALID_ASYNC_RPC_RETURN_TYPES.get(i);
            sb.append(Signature.getSimpleName((String)validReturnType));
            ++i;
        }
        return RemoteServiceProblem.create((ASTNode)methodDeclaration.getReturnType2(), RemoteServiceProblemType.INVALID_ASYNC_RETURN_TYPE, new String[]{sb.toString()}, NO_STRINGS);
    }

    static RemoteServiceProblem newMissingAsyncMethodOnAsync(IMethodBinding syncMethodBinding, TypeDeclaration asyncTypeDeclaration) {
        String[] messageArgs = new String[]{asyncTypeDeclaration.getName().getIdentifier(), RemoteServiceProblemFactory.toAsyncMethodSignature(syncMethodBinding)};
        String[] problemArgs = new String[]{"async", syncMethodBinding.getKey()};
        return RemoteServiceProblem.create((ASTNode)asyncTypeDeclaration.getName(), RemoteServiceProblemType.MISSING_ASYNC_METHOD, messageArgs, problemArgs);
    }

    static RemoteServiceProblem newMissingAsyncMethodOnSync(MethodDeclaration syncMethodDeclaration, ITypeBinding asyncTypeBinding) {
        String[] messageArgs = new String[]{asyncTypeBinding.getName(), syncMethodDeclaration.getName().getIdentifier()};
        String[] problemArgs = new String[]{"sync"};
        return RemoteServiceProblem.create((ASTNode)syncMethodDeclaration.getName(), RemoteServiceProblemType.MISSING_ASYNC_METHOD, messageArgs, problemArgs);
    }

    static RemoteServiceProblem newMissingAsyncType(TypeDeclaration syncTypeDeclaration) {
        ITypeBinding syncTypeBinding = syncTypeDeclaration.resolveBinding();
        String computeAsyncTypeName = RemoteServiceUtilities.computeAsyncTypeName(syncTypeBinding.getName());
        return RemoteServiceProblem.create((ASTNode)syncTypeDeclaration.getName(), RemoteServiceProblemType.MISSING_ASYNC_TYPE, new String[]{computeAsyncTypeName}, new String[]{syncTypeBinding.getQualifiedName()});
    }

    static RemoteServiceProblem newMissingSyncMethodOnAsync(MethodDeclaration asyncMethodDeclaration, ITypeBinding syncTypeBinding) {
        String methodName = asyncMethodDeclaration.resolveBinding().getName();
        String[] messageArgs = new String[]{syncTypeBinding.getName(), methodName};
        String[] problemArgs = new String[]{"async"};
        return RemoteServiceProblem.create((ASTNode)asyncMethodDeclaration.getName(), RemoteServiceProblemType.MISSING_SYNC_METHOD, messageArgs, problemArgs);
    }

    static RemoteServiceProblem newMissingSyncMethodOnSync(TypeDeclaration syncTypeDeclaration, IMethodBinding asyncMethodBinding) {
        String[] messageArgs = new String[]{syncTypeDeclaration.getName().getIdentifier(), RemoteServiceProblemFactory.toSyncMethodSignature(asyncMethodBinding)};
        String[] problemArgs = new String[]{"sync", asyncMethodBinding.getKey()};
        return RemoteServiceProblem.create((ASTNode)syncTypeDeclaration.getName(), RemoteServiceProblemType.MISSING_SYNC_METHOD, messageArgs, problemArgs);
    }

    static RemoteServiceProblem newNoAsyncCallbackParameter(MethodDeclaration methodDeclaration) {
        return RemoteServiceProblem.create((ASTNode)methodDeclaration.getName(), RemoteServiceProblemType.MISSING_ASYNCCALLBACK_PARAMETER, NO_STRINGS, NO_STRINGS);
    }

    static String toAsyncMethodSignature(IMethodBinding syncMethod) {
        StringBuilder sb = new StringBuilder();
        sb.append(syncMethod.getName());
        sb.append("(");
        ITypeBinding[] parameterTypes = syncMethod.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(parameterTypes[i].getName());
            ++i;
        }
        if (parameterTypes.length > 0) {
            sb.append(", ");
        }
        sb.append("AsyncCallback<");
        ITypeBinding returnType = syncMethod.getReturnType();
        if (returnType.isPrimitive()) {
            sb.append(Signature.getSimpleName((String)JavaASTUtils.getWrapperTypeName((String)returnType.getName())));
        } else {
            sb.append(returnType.getName());
        }
        sb.append(">");
        sb.append(")");
        return sb.toString();
    }

    static String toSyncMethodSignature(IMethodBinding asyncMethodSignature) {
        StringBuilder sb = new StringBuilder();
        ITypeBinding[] parameterTypes = asyncMethodSignature.getParameterTypes();
        sb.append(asyncMethodSignature.getName());
        sb.append("(");
        int i = 0;
        while (i < parameterTypes.length - 1) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(parameterTypes[i].getName());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }
}

