/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import com.google.gdt.eclipse.core.markers.GdtProblemCategory;
import com.google.gdt.eclipse.core.markers.GdtProblemSeverity;
import com.google.gdt.eclipse.core.markers.IGdtProblemType;

public enum RemoteServiceProblemType implements IGdtProblemType
{
    MISSING_ASYNC_TYPE(301, "Missing asynchronous interface", "Missing asynchronous interface {0}", GdtProblemSeverity.ERROR),
    MISSING_ASYNC_METHOD(302, "Missing method on asynchronous interface", "{0} is missing method {1}", GdtProblemSeverity.ERROR),
    MISSING_SYNC_METHOD(303, "Missing method on synchronous interface", "{0} is missing method {1}", GdtProblemSeverity.ERROR),
    MISSING_ASYNCCALLBACK_PARAMETER(304, "Missing AsyncCallback parameter", "Last parameter must be of type AsyncCallback.", GdtProblemSeverity.ERROR),
    ASYNCCALLBACK_TYPE_ARGUMENT_MISMATCH(305, "Incompatible AsyncCallback parameterization", "AsyncCallback parameterization {0} is not compatible with the synchronous return type {1}", GdtProblemSeverity.ERROR),
    INVALID_ASYNC_RETURN_TYPE(306, "Invalid asynchronous method return type", "Asynchronous methods can only return {0}", GdtProblemSeverity.ERROR);

    private final GdtProblemSeverity defaultSeverity;
    private final String description;
    private final String message;
    private final int problemId;

    public static RemoteServiceProblemType getProblemType(int problemId) {
        RemoteServiceProblemType[] remoteServiceProblemTypeArray = RemoteServiceProblemType.values();
        int n = remoteServiceProblemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteServiceProblemType type = remoteServiceProblemTypeArray[n2];
            if (type.getProblemId() == problemId) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private RemoteServiceProblemType(int problemId, String description, String message, GdtProblemSeverity defaultSeverity) {
        this.problemId = problemId;
        this.description = description;
        this.message = message;
        this.defaultSeverity = defaultSeverity;
    }

    public GdtProblemCategory getCategory() {
        return GdtProblemCategory.GWT_RPC;
    }

    public GdtProblemSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMessage() {
        return this.message;
    }

    public int getProblemId() {
        return this.problemId;
    }
}

