/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public class RemoteServiceUtilities {
    public static final String ASYNCCALLBACK_QUALIFIED_NAME = "com.google.gwt.user.client.rpc.AsyncCallback";
    private static final String ASYNC_TYPE_NAME_SUFFIX = "Async";
    private static final String[] NO_STRINGS = new String[0];
    private static final String REMOTE_SERVICE_QUALIFIED_NAME = "com.google.gwt.user.client.rpc.RemoteService";
    private static final String RPC_SERVICE_QUALIFIED_NAME = "com.google.gwt.rpc.client.RpcService";

    public static String[] computeAsyncParameterTypes(IMethod syncMethod) throws RemoteServiceException {
        ArrayList<String> parameters = new ArrayList<String>();
        String[] stringArray = syncMethod.getParameterTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String parameterSig = stringArray[n2];
            parameters.add(RemoteServiceUtilities.resolveToQualifiedErasure(syncMethod.getDeclaringType(), parameterSig));
            ++n2;
        }
        return RemoteServiceUtilities.computeAsyncParameterTypes(parameters);
    }

    public static String[] computeAsyncParameterTypes(IMethodBinding syncMethodBinding) {
        ArrayList<String> parameters = new ArrayList<String>();
        ITypeBinding[] iTypeBindingArray = syncMethodBinding.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeBinding = iTypeBindingArray[n2];
            parameters.add(typeBinding.getErasure().getQualifiedName());
            ++n2;
        }
        return RemoteServiceUtilities.computeAsyncParameterTypes(parameters);
    }

    public static String computeAsyncTypeName(String qualifiedSyncTypeName) {
        return String.valueOf(qualifiedSyncTypeName) + ASYNC_TYPE_NAME_SUFFIX;
    }

    public static String computeMethodSignature(String returnType, String methodName, String[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(returnType);
        sb.append(" ");
        sb.append(methodName);
        sb.append("(");
        sb.append(StringUtilities.join((Object[])parameterTypes, (String)", "));
        sb.append(")");
        return sb.toString();
    }

    public static String[] computeSyncParameterTypes(IMethod asyncMethod) throws RemoteServiceException {
        ArrayList<String> parameters = new ArrayList<String>();
        String[] asyncParamTypeSigs = asyncMethod.getParameterTypes();
        int i = 0;
        while (i < asyncParamTypeSigs.length - 1) {
            parameters.add(RemoteServiceUtilities.resolveToQualifiedErasure(asyncMethod.getDeclaringType(), asyncParamTypeSigs[i]));
            ++i;
        }
        return parameters.toArray(NO_STRINGS);
    }

    public static String computeSyncTypeName(String qualifiedAsyncTypeName) {
        if (!RemoteServiceUtilities.isAsyncTypeName(qualifiedAsyncTypeName)) {
            return null;
        }
        return qualifiedAsyncTypeName.substring(0, qualifiedAsyncTypeName.length() - ASYNC_TYPE_NAME_SUFFIX.length());
    }

    public static void expandSuperInterfaces(ITypeBinding binding, List<ITypeBinding> bindings) {
        ITypeBinding[] intfs;
        if (bindings.contains(binding)) {
            return;
        }
        bindings.add(binding);
        ITypeBinding[] iTypeBindingArray = intfs = binding.getInterfaces();
        int n = intfs.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding intf = iTypeBindingArray[n2];
            RemoteServiceUtilities.expandSuperInterfaces(intf, bindings);
            ++n2;
        }
    }

    public static IType findAsyncType(TypeDeclaration syncTypeDeclaration) {
        IJavaProject javaProject = JavaASTUtils.getCompilationUnit((ASTNode)syncTypeDeclaration).getJavaProject();
        String syncQualifiedTypeName = syncTypeDeclaration.resolveBinding().getQualifiedName();
        String asyncQualifiedTypeName = RemoteServiceUtilities.computeAsyncTypeName(syncQualifiedTypeName);
        return JavaModelSearch.findType((IJavaProject)javaProject, (String)asyncQualifiedTypeName);
    }

    public static IType findSyncType(TypeDeclaration asyncTypeDeclaration) {
        IJavaProject javaProject = JavaASTUtils.getCompilationUnit((ASTNode)asyncTypeDeclaration).getJavaProject();
        String asyncQualifiedTypeName = asyncTypeDeclaration.resolveBinding().getQualifiedName();
        String syncQualifiedTypeName = RemoteServiceUtilities.computeSyncTypeName(asyncQualifiedTypeName);
        return JavaModelSearch.findType((IJavaProject)javaProject, (String)syncQualifiedTypeName);
    }

    public static boolean isAsyncInterface(IType type) throws JavaModelException {
        return RemoteServiceUtilities.resolveSyncType(type) != null;
    }

    public static boolean isAsyncTypeName(String typeName) {
        return typeName.endsWith(ASYNC_TYPE_NAME_SUFFIX);
    }

    public static boolean isSyncInterface(IType type) throws JavaModelException {
        IJavaProject javaProject = type.getJavaProject();
        if (!GWTNature.isGWTProject(javaProject.getProject())) {
            return false;
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType remoteServiceInterface = javaProject.findType(REMOTE_SERVICE_QUALIFIED_NAME);
        return remoteServiceInterface != null && hierarchy.contains(remoteServiceInterface);
    }

    public static IType resolveAsyncType(IType syncInterface) throws JavaModelException {
        String asyncQualifiedName = RemoteServiceUtilities.computeAsyncTypeName(syncInterface.getFullyQualifiedName('.'));
        return syncInterface.getJavaProject().findType(asyncQualifiedName);
    }

    public static IType resolveSyncType(IType asyncInterface) throws JavaModelException {
        String asyncQualifiedName = asyncInterface.getFullyQualifiedName('.');
        String syncQualifiedName = RemoteServiceUtilities.computeSyncTypeName(asyncQualifiedName);
        if (syncQualifiedName == null) {
            return null;
        }
        return asyncInterface.getJavaProject().findType(syncQualifiedName);
    }

    static String[] computeSyncParameterTypes(IMethodBinding asyncMethodBinding) {
        ArrayList<String> parameters = new ArrayList<String>();
        ITypeBinding[] parameterTypes = asyncMethodBinding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length - 1) {
            parameters.add(parameterTypes[i].getErasure().getQualifiedName());
            ++i;
        }
        return parameters.toArray(NO_STRINGS);
    }

    static ITypeBinding getAsyncCallbackParam(IMethodBinding methodBinding) {
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        if (RemoteServiceUtilities.hasAsyncCallbackParameter(parameterTypes)) {
            return parameterTypes[parameterTypes.length - 1];
        }
        return null;
    }

    static boolean hasAsyncCallbackParameter(ITypeBinding[] parameterTypes) {
        if (parameterTypes.length == 0) {
            return false;
        }
        ITypeBinding lastParameter = parameterTypes[parameterTypes.length - 1];
        ITypeBinding erasure = lastParameter.getErasure();
        if (erasure == null) {
            return lastParameter.getQualifiedName().startsWith(ASYNCCALLBACK_QUALIFIED_NAME);
        }
        return erasure.getQualifiedName().equals(ASYNCCALLBACK_QUALIFIED_NAME);
    }

    static boolean isSynchronousInterface(ITypeBinding typeBinding) {
        String qualifiedName = typeBinding.getQualifiedName();
        if (qualifiedName.equals(REMOTE_SERVICE_QUALIFIED_NAME) || qualifiedName.equals(RPC_SERVICE_QUALIFIED_NAME)) {
            return false;
        }
        ITypeBinding remoteServiceBinding = Bindings.findTypeInHierarchy((ITypeBinding)typeBinding, (String)REMOTE_SERVICE_QUALIFIED_NAME);
        return remoteServiceBinding != null;
    }

    private static String[] computeAsyncParameterTypes(List<String> qualifiedSyncParamTypes) {
        qualifiedSyncParamTypes.add(ASYNCCALLBACK_QUALIFIED_NAME);
        return qualifiedSyncParamTypes.toArray(NO_STRINGS);
    }

    private static String resolveToQualifiedErasure(IType context, String typeSignature) throws RemoteServiceException {
        try {
            String typeErasureSig = Signature.getTypeErasure((String)typeSignature);
            String type = Signature.getSignatureSimpleName((String)typeErasureSig);
            String qualifiedErasure = JavaModelSearch.resolveTypeName((IType)context, (String)type);
            if (qualifiedErasure == null) {
                throw new RemoteServiceException("Could not resolve type " + type);
            }
            return qualifiedErasure;
        }
        catch (JavaModelException e) {
            throw new RemoteServiceException(e);
        }
    }
}

