/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.validation.ValidationResult;
import com.google.gwt.eclipse.core.validators.rpc.AsynchronousInterfaceValidator;
import com.google.gwt.eclipse.core.validators.rpc.PairedInterfaceValidator;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import com.google.gwt.eclipse.core.validators.rpc.SynchronousInterfaceValidator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class RemoteServiceValidator {
    public ValidationResult validate(ASTNode ast) {
        assert (ast.getNodeType() == 15);
        CompilationUnit compilationUnit = (CompilationUnit)ast;
        IJavaProject javaProject = compilationUnit.getJavaElement().getJavaProject();
        RemoteServiceValidationVisitor remoteServiceValidationVisitor = new RemoteServiceValidationVisitor(javaProject);
        ast.accept((ASTVisitor)remoteServiceValidationVisitor);
        return new ValidationResult(remoteServiceValidationVisitor.problems, remoteServiceValidationVisitor.dependentTypes);
    }

    private static class RemoteServiceValidationVisitor
    extends ASTVisitor {
        private final PairedInterfaceValidator asynchronousInterfaceValidator = new AsynchronousInterfaceValidator();
        private final List<String> dependentTypes = new ArrayList<String>();
        private final IJavaProject javaProject;
        private final List<CategorizedProblem> problems = new ArrayList<CategorizedProblem>();
        private final PairedInterfaceValidator synchronousInterfaceValidator = new SynchronousInterfaceValidator();

        public RemoteServiceValidationVisitor(IJavaProject javaProject) {
            this.javaProject = javaProject;
        }

        public boolean visit(TypeDeclaration changedType) {
            PairedInterfaceValidator validator;
            String dependentTypeQualifiedName;
            if (!changedType.isInterface()) {
                return true;
            }
            ITypeBinding typeBinding = changedType.resolveBinding();
            if (typeBinding == null) {
                return true;
            }
            String typeQualifiedName = typeBinding.getQualifiedName();
            TypeDeclaration dependentType = null;
            if (RemoteServiceUtilities.isSynchronousInterface(typeBinding)) {
                dependentTypeQualifiedName = RemoteServiceUtilities.computeAsyncTypeName(typeQualifiedName);
                dependentType = JavaASTUtils.findTypeDeclaration((IJavaProject)this.javaProject, (String)dependentTypeQualifiedName);
                validator = this.synchronousInterfaceValidator;
            } else {
                validator = this.asynchronousInterfaceValidator;
                dependentTypeQualifiedName = RemoteServiceUtilities.computeSyncTypeName(typeQualifiedName);
                if (dependentTypeQualifiedName == null) {
                    return true;
                }
                dependentType = JavaASTUtils.findTypeDeclaration((IJavaProject)this.javaProject, (String)dependentTypeQualifiedName);
            }
            this.dependentTypes.add(dependentTypeQualifiedName);
            ITypeBinding dependentTypeBinding = null;
            if (dependentType != null) {
                dependentTypeBinding = dependentType.resolveBinding();
            }
            this.problems.addAll(validator.validate(changedType, dependentTypeBinding));
            return true;
        }
    }
}

