/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gwt.eclipse.core.validators.rpc.AbstractPairedInterfaceValidator;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblem;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceProblemFactory;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import com.google.gwt.eclipse.core.validators.rpc.ValidationSuppressionVisitor;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.Bindings;

class SynchronousInterfaceValidator
extends AbstractPairedInterfaceValidator {
    SynchronousInterfaceValidator() {
    }

    @Override
    protected List<CategorizedProblem> doMissingDependentInterface(TypeDeclaration changedInterface) {
        ValidationSuppressionVisitor warningSuppressionVisitor = new ValidationSuppressionVisitor();
        List modifiers = changedInterface.modifiers();
        for (ASTNode modifier : modifiers) {
            modifier.accept((ASTVisitor)warningSuppressionVisitor);
        }
        if (warningSuppressionVisitor.shouldSuppressValidation()) {
            return Collections.emptyList();
        }
        RemoteServiceProblem problem = RemoteServiceProblemFactory.newMissingAsyncType(changedInterface);
        if (problem != null) {
            return Collections.singletonList(problem);
        }
        return Collections.emptyList();
    }

    @Override
    protected List<CategorizedProblem> doValidateMethodOnChangedType(MethodDeclaration methodDeclaration, ITypeBinding dependentTypeBinding) {
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        String[] parameters = RemoteServiceUtilities.computeAsyncParameterTypes(methodBinding);
        String methodName = methodBinding.getName();
        IMethodBinding dependentMethod = Bindings.findMethodInHierarchy((ITypeBinding)dependentTypeBinding, (String)methodName, (String[])parameters);
        if (dependentMethod == null) {
            RemoteServiceProblem problem = RemoteServiceProblemFactory.newMissingAsyncMethodOnSync(methodDeclaration, dependentTypeBinding);
            if (problem != null) {
                return Collections.singletonList(problem);
            }
            return Collections.emptyList();
        }
        ITypeBinding asyncCallbackType = RemoteServiceUtilities.getAsyncCallbackParam(dependentMethod);
        assert (asyncCallbackType != null);
        if (asyncCallbackType.isParameterizedType()) {
            RemoteServiceProblem problem;
            ITypeBinding[] typeArguments;
            ITypeBinding returnType;
            ITypeBinding typeBinding = returnType = methodBinding.getReturnType();
            if (returnType.isPrimitive()) {
                typeBinding = methodDeclaration.getAST().resolveWellKnownType(JavaASTUtils.getWrapperTypeName((String)returnType.getQualifiedName()));
            }
            if (!SynchronousInterfaceValidator.canAssign(typeBinding, (typeArguments = asyncCallbackType.getTypeArguments())[0]) && (problem = RemoteServiceProblemFactory.newAsyncCallbackTypeArgumentMismatchOnSync(methodDeclaration, typeArguments[0])) != null) {
                return Collections.singletonList(problem);
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected List<CategorizedProblem> doValidateMethodOnDependentInterface(IMethodBinding dependentMethodBinding, TypeDeclaration changedInterface, ITypeBinding dependentTypeBinding) {
        RemoteServiceProblem problem1;
        String[] parameters = RemoteServiceUtilities.computeSyncParameterTypes(dependentMethodBinding);
        if (Bindings.findMethodInHierarchy((ITypeBinding)changedInterface.resolveBinding(), (String)dependentMethodBinding.getName(), (String[])parameters) == null && (problem1 = RemoteServiceProblemFactory.newMissingSyncMethodOnSync(changedInterface, dependentMethodBinding)) != null) {
            return Collections.singletonList(problem1);
        }
        return Collections.emptyList();
    }
}

