/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.validators.rpc;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

final class ValidationSuppressionVisitor
extends ASTVisitor {
    private boolean suppressValidation;

    ValidationSuppressionVisitor() {
    }

    public boolean shouldSuppressValidation() {
        return this.suppressValidation;
    }

    public boolean visit(NormalAnnotation node) {
        IAnnotationBinding resolvedAnnotationBinding = node.resolveAnnotationBinding();
        this.processAnnotationBinding(resolvedAnnotationBinding);
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        IAnnotationBinding resolvedAnnotationBinding = node.resolveAnnotationBinding();
        this.processAnnotationBinding(resolvedAnnotationBinding);
        return false;
    }

    private boolean computeSuppressWarning(IMemberValuePairBinding iMemberValuePairBinding) {
        if (!"value".equals(iMemberValuePairBinding.getName())) {
            return false;
        }
        Object value = iMemberValuePairBinding.getValue();
        return this.findString(value, "rpc-validation");
    }

    private boolean findString(Object o, String string) {
        if (o instanceof Object[]) {
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object v = objectArray[n2];
                if (this.findString(v, string)) {
                    return true;
                }
                ++n2;
            }
        } else if (o instanceof String) {
            return o.equals(string);
        }
        return false;
    }

    private void processAnnotationBinding(IAnnotationBinding resolvedAnnotationBinding) {
        ITypeBinding annotationType;
        if (resolvedAnnotationBinding != null && (annotationType = resolvedAnnotationBinding.getAnnotationType()) != null && annotationType.getQualifiedName().equals(SuppressWarnings.class.getName())) {
            IMemberValuePairBinding[] allMemberValuePairs;
            IMemberValuePairBinding[] iMemberValuePairBindingArray = allMemberValuePairs = resolvedAnnotationBinding.getAllMemberValuePairs();
            int n = allMemberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePairBinding iMemberValuePairBinding = iMemberValuePairBindingArray[n2];
                if (this.computeSuppressWarning(iMemberValuePairBinding)) {
                    this.suppressValidation = true;
                    break;
                }
                ++n2;
            }
        }
    }
}

