/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gwt.eclipse.core.GWTPlugin;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class AbstractNewFileWizard
extends Wizard
implements INewWizard {
    private IResource initialSelectedResource;
    private IStructuredSelection selection;

    public static IResource getSelectedResource(IStructuredSelection selection) {
        IFile file;
        Object selectedElement = null;
        if (selection != null) {
            selectedElement = selection.getFirstElement();
        }
        if (selectedElement instanceof IResource) {
            return (IResource)selectedElement;
        }
        if (selectedElement instanceof IJavaElement) {
            return ((IJavaElement)selectedElement).getResource();
        }
        if (selectedElement instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)selectedElement;
            return (IResource)adaptable.getAdapter(IResource.class);
        }
        IEditorPart editor = GWTPlugin.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && (file = ResourceUtils.getEditorInput((IEditorPart)editor)) != null) {
            return file;
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        IFile file = this.createNewFile();
        if (file != null) {
            ResourceUtils.openInDefaultEditor((Shell)this.getShell(), (IFile)file, (boolean)true);
            return true;
        }
        return false;
    }

    protected String getFileExtension() {
        return null;
    }

    protected abstract IPath getFilePath();

    protected InputStream getInitialContents() {
        return null;
    }

    protected IResource getInitialSelectedResource() {
        if (this.initialSelectedResource == null) {
            this.initialSelectedResource = AbstractNewFileWizard.getSelectedResource(this.selection);
        }
        return this.initialSelectedResource;
    }

    protected IStructuredSelection getSelection() {
        return this.selection;
    }

    private IFile createNewFile() {
        IPath newFilePath = this.getNormalizedFilePath();
        final IFile newFileHandle = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(newFilePath);
        final InputStream initialContents = this.getInitialContents();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFileOperation op = new CreateFileOperation(newFileHandle, null, initialContents, IDEWorkbenchMessages.WizardNewFileCreationPage_title);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)AbstractNewFileWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    AbstractNewFileWizard.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)AbstractNewFileWizard.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), (String)"createNewFile()", (Throwable)e.getCause());
                                MessageDialog.openError((Shell)AbstractNewFileWizard.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)e.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()));
            return null;
        }
        return newFileHandle;
    }

    private IPath getNormalizedFilePath() {
        IPath newFilePath = this.getFilePath();
        String newFilename = newFilePath.lastSegment();
        String ext = this.getFileExtension();
        if (ext != null && ext.length() != 0 && !newFilename.endsWith("." + ext)) {
            return newFilePath.addFileExtension(ext);
        }
        return newFilePath;
    }
}

