/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.internal.WorkbenchImages;

public class HostPagePathSelectionDialog
extends ElementTreeSelectionDialog {
    private final HostPagePathTreeItem[] rootTreeItems;

    public static IPath show(Shell shell, IProject project, IPath initialPath) {
        HostPagePathSelectionDialog dialog = new HostPagePathSelectionDialog(shell, project);
        dialog.setInitialPath(project.getFullPath().append(initialPath));
        if (dialog.open() == 0) {
            HostPagePathTreeItem selection = (HostPagePathTreeItem)dialog.getFirstResult();
            return selection.getPath();
        }
        return null;
    }

    private HostPagePathSelectionDialog(Shell parent, IProject project) {
        super(parent, (ILabelProvider)new HostPagePathLabelProvider(), (ITreeContentProvider)new HostPagePathContentProvider());
        this.setTitle("Existing Folder Selection");
        this.setMessage("Choose a location for the HTML page");
        this.rootTreeItems = HostPagePathTreeItem.createRootItems(project);
        this.setInput(this.rootTreeItems);
        this.setComparator(new ViewerComparator());
    }

    private void setInitialPath(IPath initialPath) {
        if (!initialPath.isEmpty()) {
            HostPagePathTreeItem[] hostPagePathTreeItemArray = this.rootTreeItems;
            int n = this.rootTreeItems.length;
            int n2 = 0;
            while (n2 < n) {
                HostPagePathTreeItem treeItem = hostPagePathTreeItemArray[n2];
                HostPagePathTreeItem initialSelection = treeItem.findPath(initialPath);
                if (initialSelection != null) {
                    this.setInitialSelection(initialSelection);
                    return;
                }
                ++n2;
            }
        }
    }

    private static class HostPagePathContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        private HostPagePathContentProvider() {
        }

        public Object[] getChildren(Object element) {
            return ((HostPagePathTreeItem)element).getChildren();
        }

        public Object getParent(Object element) {
            return ((HostPagePathTreeItem)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((HostPagePathTreeItem)element).getChildren().length > 0;
        }
    }

    private static class HostPagePathLabelProvider
    extends LabelProvider {
        private final Image image = WorkbenchImages.getImage((String)"IMG_OBJ_FOLDER");

        public Image getImage(Object element) {
            return this.image;
        }

        public String getText(Object element) {
            HostPagePathTreeItem treeItem = (HostPagePathTreeItem)element;
            if (treeItem.isDeclaredPublicPath()) {
                ModuleFile moduleFile = treeItem.getModuleFile();
                IPath publicPath = treeItem.getPath().removeFirstSegments(moduleFile.getFile().getFullPath().segmentCount() - 1);
                return new Path(moduleFile.getQualifiedName()).append(publicPath).toString();
            }
            return treeItem.getPath().lastSegment();
        }
    }

    private static class HostPagePathTreeItem {
        private final List<HostPagePathTreeItem> children = new ArrayList<HostPagePathTreeItem>();
        private ModuleFile moduleFile;
        private final HostPagePathTreeItem parent;
        private final IPath path;

        public static HostPagePathTreeItem[] createRootItems(IProject project) {
            IFolder warFolder;
            ArrayList<HostPagePathTreeItem> rootItems = new ArrayList<HostPagePathTreeItem>();
            if (WebAppUtilities.isWebApp((IProject)project) && (warFolder = WebAppUtilities.getWarSrc((IProject)project)).exists()) {
                rootItems.add(new HostPagePathTreeItem(warFolder, null));
            }
            IModule[] iModuleArray = ModuleUtils.findAllModules(JavaCore.create((IProject)project), false);
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                rootItems.addAll(HostPagePathTreeItem.createItemsForModule((ModuleFile)module));
                ++n2;
            }
            return rootItems.toArray(new HostPagePathTreeItem[0]);
        }

        private static List<HostPagePathTreeItem> createItemsForModule(ModuleFile moduleFile) {
            ArrayList<HostPagePathTreeItem> publicPathItems = new ArrayList<HostPagePathTreeItem>();
            for (IPath publicPath : moduleFile.getPublicPaths()) {
                publicPathItems.add(new HostPagePathTreeItem(moduleFile, publicPath));
            }
            return publicPathItems;
        }

        private static List<IFolder> getSubfolders(IFolder folder) {
            ArrayList<IFolder> folders = new ArrayList<IFolder>();
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member.getType() == 2 && !member.isDerived() && !member.getName().startsWith(".")) {
                        folders.add((IFolder)member);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                GWTPluginLog.logError(e);
            }
            return folders;
        }

        private HostPagePathTreeItem(IFolder folder, HostPagePathTreeItem parent) {
            this.parent = parent;
            this.path = folder.getFullPath();
            for (IFolder subfolder : HostPagePathTreeItem.getSubfolders(folder)) {
                this.children.add(new HostPagePathTreeItem(subfolder, this));
            }
        }

        private HostPagePathTreeItem(ModuleFile moduleFile, IPath publicPath) {
            this.parent = null;
            this.moduleFile = moduleFile;
            this.path = moduleFile.getFile().getFullPath().removeLastSegments(1).append(publicPath);
            IResource publicFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(this.path);
            if (publicFolder != null) {
                for (IFolder subFolder : HostPagePathTreeItem.getSubfolders((IFolder)publicFolder)) {
                    this.children.add(new HostPagePathTreeItem(subFolder, this));
                }
            }
        }

        public HostPagePathTreeItem findPath(IPath path) {
            if (this.path.equals((Object)path)) {
                return this;
            }
            if (this.path.isPrefixOf(path)) {
                HostPagePathTreeItem[] hostPagePathTreeItemArray = this.getChildren();
                int n = hostPagePathTreeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HostPagePathTreeItem childTreeItem = hostPagePathTreeItemArray[n2];
                    HostPagePathTreeItem foundPath = childTreeItem.findPath(path);
                    if (foundPath != null) {
                        return foundPath;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public HostPagePathTreeItem[] getChildren() {
            return this.children.toArray(new HostPagePathTreeItem[0]);
        }

        public ModuleFile getModuleFile() {
            return this.moduleFile;
        }

        public HostPagePathTreeItem getParent() {
            return this.parent;
        }

        public IPath getPath() {
            return this.path;
        }

        public boolean isDeclaredPublicPath() {
            return this.moduleFile != null;
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

