/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.AdapterUtilities;
import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleResource;
import com.google.gwt.eclipse.core.clientbundle.ClientBundleUtilities;
import com.google.gwt.eclipse.core.clientbundle.ui.BundledResourcesSelectionBlock;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewClientBundleWizardPage
extends NewTypeWizardPage {
    private BundledResourcesSelectionBlock bundledResourcesBlock;

    public NewClientBundleWizardPage() {
        super(false, "NewClientBundleWizardPage");
        this.setTitle("ClientBundle");
        this.setDescription("Create a new ClientBundle interface.");
        this.bundledResourcesBlock = new BundledResourcesSelectionBlock("Bundled resources:", new BundledResourcesFieldAdapter());
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createBundledResourcesControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_interface_wizard_page_context");
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            this.initBundledResources(javaProject, selection);
        }
        if (!this.newTypeExtendsClientBundle()) {
            this.addSuperInterface("com.google.gwt.resources.client.ClientBundle");
        }
        this.doStatusUpdate();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected IStatus containerChanged() {
        IStatus superStatus = super.containerChanged();
        if (superStatus.getSeverity() == 4) {
            return superStatus;
        }
        if (ClientBundleUtilities.findClientBundleType(this.getJavaProject()) == null) {
            return StatusUtilities.newErrorStatus((String)"Project must be using GWT 2.0 or later to use ClientBundle.", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        this.bundledResourcesBlock.setJavaProject(this.getJavaProject());
        return superStatus;
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        boolean addComments = this.isAddComments();
        final MultiStatus status = new MultiStatus("com.gwtplugins.gwt.eclipse.core", 0, "Click the Details button for more information", null);
        for (ClientBundleResource resource : this.bundledResourcesBlock.getResources()) {
            try {
                resource.addToClientBundle(newType, imports, addComments, monitor);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
            }
        }
        if (!status.isOK()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)NewClientBundleWizardPage.this.getShell(), (String)"Error Adding Resources", (String)"One or more selected resources could not be added to the ClientBundle.", (IStatus)status);
                }
            });
        }
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container" || fieldName == "NewTypeWizardPage.interfaces") {
            boolean enable;
            boolean bl = enable = this.fSuperInterfacesStatus.getSeverity() != 4 && this.fContainerStatus.getSeverity() != 4;
            if (enable ^ this.bundledResourcesBlock.isEnabled()) {
                this.bundledResourcesBlock.setEnabled(enable);
            }
        }
        this.doStatusUpdate();
    }

    protected IStatus packageChanged() {
        IStatus superStatus = super.packageChanged();
        this.bundledResourcesBlock.setPackage(this.getPackageFragment());
        return superStatus;
    }

    protected IStatus superInterfacesChanged() {
        IStatus superStatus = super.superInterfacesChanged();
        if (superStatus.getSeverity() == 4) {
            return superStatus;
        }
        if (!this.newTypeExtendsClientBundle()) {
            return StatusUtilities.newErrorStatus((String)"ClientBundle interface must extend com.google.gwt.resources.client.ClientBundle", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        String[] extendedInterfaces = this.getSuperInterfaces().toArray(new String[0]);
        this.bundledResourcesBlock.setExtendedInterfaces(extendedInterfaces);
        return superStatus;
    }

    private void createBundledResourcesControls(Composite parent, int columns) {
        this.bundledResourcesBlock.doFillIntoGrid(parent, columns);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperInterfacesStatus, this.getBundledResourcesStatus()};
        this.updateStatus(status);
    }

    private IStatus getBundledResourcesStatus() {
        IStatus status = this.bundledResourcesBlock.getStatus();
        if (status.isOK()) {
            return status;
        }
        return new Status(status.getSeverity(), status.getPlugin(), "Bundled resource problem: " + status.getMessage());
    }

    private void initBundledResources(IJavaProject javaProject, IStructuredSelection selection) {
        ArrayList<ClientBundleResource> resources = new ArrayList<ClientBundleResource>();
        for (Object element : selection) {
            ClientBundleResource resource;
            IFile file = (IFile)AdapterUtilities.getAdapter(element, IFile.class);
            if (file == null || (resource = ClientBundleResource.createFromFile(javaProject, file)) == null) continue;
            resources.add(resource);
        }
        this.bundledResourcesBlock.setResources(resources);
    }

    private boolean newTypeExtendsClientBundle() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        for (Object superInterface : this.getSuperInterfaces()) {
            String interfaceTypeName = (String)superInterface;
            try {
                if (!ClientBundleUtilities.isClientBundle(javaProject, interfaceTypeName)) continue;
                return true;
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
            }
        }
        return false;
    }

    private class BundledResourcesFieldAdapter
    implements BundledResourcesSelectionBlock.IResourcesChangeListener {
        private BundledResourcesFieldAdapter() {
        }

        @Override
        public void onResourcesChanged() {
            NewClientBundleWizardPage.this.doStatusUpdate();
        }
    }
}

