/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.wizards.NewEntryPointWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class NewEntryPointWizard
extends NewElementWizard {
    private NewEntryPointWizardPage wizardPage;

    public NewEntryPointWizard() {
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(GWTPlugin.getDefault().getImageDescriptor("com.gwtplugins.gwt.eclipse.core.images.newEntryPointLarge"));
        this.setWindowTitle("New Entry Point Class");
    }

    public void addPages() {
        if (this.wizardPage == null) {
            this.wizardPage = new NewEntryPointWizardPage();
            this.wizardPage.init(this.getSelection());
        }
        this.addPage((IWizardPage)this.wizardPage);
    }

    public IJavaElement getCreatedElement() {
        return this.wizardPage.getCreatedType();
    }

    public boolean performFinish() {
        IResource resource;
        boolean res = super.performFinish();
        if (res && (resource = this.wizardPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            this.openResource((IFile)resource);
        }
        return res;
    }

    protected boolean canRunForked() {
        return false;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.wizardPage.createType(monitor);
        String typeName = this.wizardPage.getCreatedType().getFullyQualifiedName();
        ModuleFile module = this.wizardPage.getModule();
        try {
            for (String existingEntryPoint : module.getEntryPoints()) {
                if (!typeName.equals(existingEntryPoint)) continue;
                return;
            }
            module.addEntryPoint(typeName);
        }
        catch (Exception e) {
            throw new CoreException(Util.newErrorStatus(e.getMessage()));
        }
    }
}

