/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gwt.eclipse.core.dialogs.ModuleSelectionDialogButtonField;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.wizards.AbstractNewFileWizard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewEntryPointWizardPage
extends NewTypeWizardPage {
    private static final String MODULE = "NewEntryPointWizardPage.module";
    private SelectionButtonDialogFieldGroup methodStubsButtons;
    private ModuleFile module;
    private ModuleSelectionDialogButtonField moduleField;
    private IStatus moduleStatus;
    private JavaElementLabelProvider javaLabelProvider = new JavaElementLabelProvider();

    public NewEntryPointWizardPage() {
        super(true, "Entry Point Class");
        this.setTitle("Entry Point Class");
        this.setDescription("Create a new entry point class.");
        this.moduleField = new ModuleSelectionDialogButtonField((WizardPage)this, new ModuleFieldAdapter());
        String[] buttonNames = new String[]{NewWizardMessages.NewClassWizardPage_methods_constructors, NewWizardMessages.NewClassWizardPage_methods_inherited};
        this.methodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames, 1);
        this.methodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
        this.moduleStatus = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createModuleControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        ArrayList<String> superInterfaces = new ArrayList<String>();
        superInterfaces.add("com.google.gwt.core.client.EntryPoint");
        this.setSuperInterfaces(superInterfaces, true);
    }

    public ModuleFile getModule() {
        return this.module;
    }

    public void init(IStructuredSelection selection) {
        IJavaElement initialJavaElement = this.getInitialJavaElement(selection);
        this.initContainerPage(initialJavaElement);
        this.initTypePage(initialJavaElement);
        IResource initialResource = AbstractNewFileWizard.getSelectedResource(selection);
        if (initialResource.getType() == 8 && initialJavaElement != null) {
            initialResource = initialJavaElement.getResource();
        }
        this.initEntryPointPage(initialResource);
        this.doStatusUpdate();
        this.setMethodStubSelection(false, true);
    }

    public boolean isCreateConstructors() {
        return this.methodStubsButtons.isSelected(0);
    }

    public boolean isCreateInherited() {
        return this.methodStubsButtons.isSelected(1);
    }

    public void setMethodStubSelection(boolean createCtors, boolean createInherited) {
        this.methodStubsButtons.setSelection(0, createCtors);
        this.methodStubsButtons.setSelection(1, createInherited);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected IStatus containerChanged() {
        IJavaProject javaProject;
        IStatus status = super.containerChanged();
        if (!status.isOK()) {
            this.moduleField.setGWTProject(null);
            if (status.getSeverity() == 4) {
                return status;
            }
            if (status.getSeverity() == 2) {
                return Util.newErrorStatus(status.getMessage());
            }
        }
        if (JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)(javaProject = this.getJavaProject())) && GWTNature.isGWTProject(javaProject.getProject())) {
            this.moduleField.setGWTProject(javaProject);
        } else {
            this.moduleField.setGWTProject(null);
            status = Util.newErrorStatus("The source folder does not belong to a GWT Project.");
        }
        return status;
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        boolean doConstr = this.isCreateConstructors();
        boolean doInherited = this.isCreateInherited();
        this.createInheritedMethods(newType, doConstr, doInherited, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor != null) {
            monitor.done();
        }
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container" || fieldName == "NewTypeWizardPage.package") {
            this.moduleStatus = this.moduleChanged();
            this.fPackageStatus = this.packageChanged();
        }
        this.doStatusUpdate();
    }

    protected IStatus packageChanged() {
        IPackageFragment pckg;
        IStatus status = super.packageChanged();
        if (status.getSeverity() != 4 && (pckg = this.getPackageFragment()) != null && this.module != null && !pckg.getElementName().startsWith(this.module.getPackageName())) {
            status = Util.newErrorStatus("''{0}'' is not in a client source path of module ''{1}''", this.javaLabelProvider.getText((Object)pckg), this.module.getQualifiedName());
        }
        return status;
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.methodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this.methodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
    }

    private void createModuleControls(Composite composite, int columns) {
        this.moduleField.doFillIntoGrid(composite, columns);
        Text text = this.moduleField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.convertWidthInCharsToPixels(40));
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.moduleStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    private void entryPointFieldChanged(DialogField field) {
        if (field == this.moduleField) {
            this.moduleStatus = this.moduleChanged();
            this.fPackageStatus = this.packageChanged();
        }
        this.handleFieldChanged(MODULE);
    }

    private void initEntryPointPage(IResource resource) {
        if (resource.getType() == 8 || !resource.isAccessible()) {
            return;
        }
        if (this.moduleField.init(resource)) {
            if (this.moduleStatus.isOK()) {
                this.initPackageFromModule();
            } else {
                this.moduleField.setText("");
            }
        }
    }

    private boolean initPackageFromModule() {
        IJavaElement javaElement;
        IFolder folder;
        List moduleSrcPaths = this.module.getSourcePaths();
        if (moduleSrcPaths.size() == 1 && (folder = this.module.getFolder((IPath)moduleSrcPaths.get(0))) != null && (javaElement = JavaCore.create((IFolder)folder)) != null && javaElement.getElementType() == 4) {
            this.setPackageFragment((IPackageFragment)javaElement, true);
            return true;
        }
        return false;
    }

    private IStatus moduleChanged() {
        StatusInfo status = new StatusInfo();
        this.module = null;
        this.moduleField.enableButton(this.getPackageFragmentRoot() != null && this.getPackageFragmentRoot().exists() && JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)this.getJavaProject()) && GWTNature.isGWTProject(this.getJavaProject().getProject()));
        IStatus fieldStatus = this.moduleField.getStatus();
        if (!fieldStatus.isOK()) {
            status.setError(fieldStatus.getMessage());
            return status;
        }
        this.module = this.moduleField.getModule();
        return status;
    }

    private class ModuleFieldAdapter
    implements IDialogFieldListener {
        private ModuleFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewEntryPointWizardPage.this.entryPointFieldChanged(field);
        }
    }
}

