/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.ResourceUtils;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gdt.eclipse.core.sdk.Sdk;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.wizards.AbstractNewFileWizard;
import com.google.gwt.eclipse.core.wizards.NewHostPageWizardPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public class NewHostPageWizard
extends AbstractNewFileWizard {
    private NewHostPageWizardPage wizardPage;

    private static IPath getPathRelativeToAncestor(IPath path, IPath ancestor) {
        if (ancestor.isPrefixOf(path)) {
            return path.removeFirstSegments(ancestor.segmentCount());
        }
        return null;
    }

    private static String getRelativeUrl(IPath fromFile, IPath refFile) {
        IPath fromContainer = fromFile.removeLastSegments(1);
        IPath refFileContainer = refFile.removeLastSegments(1);
        Path commonAncestor = new Path("");
        int matchingSegments = fromContainer.matchingFirstSegments(refFileContainer);
        int i = 0;
        while (i < matchingSegments) {
            commonAncestor = commonAncestor.append(fromContainer.segment(i));
            ++i;
        }
        StringBuilder sb = new StringBuilder();
        int fromLevelsFromCommon = fromContainer.segmentCount() - matchingSegments;
        int i2 = 0;
        while (i2 < fromLevelsFromCommon) {
            sb.append("../");
            ++i2;
        }
        IPath refFilePathRelativeToCommon = NewHostPageWizard.getPathRelativeToAncestor(refFile, (IPath)commonAncestor);
        sb.append(refFilePathRelativeToCommon.toString());
        return sb.toString();
    }

    public void addPages() {
        this.wizardPage = new NewHostPageWizardPage();
        this.wizardPage.init(this.getInitialSelectedResource());
        this.addPage((IWizardPage)this.wizardPage);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setHelpAvailable(false);
        this.setWindowTitle("New HTML Page");
        this.setDefaultPageImageDescriptor(GWTPlugin.getDefault().getImageDescriptor("com.gwtplugins.gwt.eclipse.core.images.newHostPageLarge"));
    }

    @Override
    public boolean performFinish() {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.wizardPage.getPath());
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                GWTPluginLog.logError(e);
                return false;
            }
        }
        return super.performFinish();
    }

    @Override
    protected String getFileExtension() {
        return "html";
    }

    @Override
    protected IPath getFilePath() {
        IPath containerPath = this.wizardPage.getPath();
        IPath pagePath = containerPath.append(this.wizardPage.getFileName());
        return pagePath;
    }

    @Override
    protected InputStream getInitialContents() {
        ArrayList<String> startupScriptPaths = new ArrayList<String>();
        for (ModuleFile moduleFile : this.wizardPage.getModules()) {
            String startupScriptPath = this.determineStartupScriptPath(this.getFilePath(), moduleFile);
            if (startupScriptPath != null) {
                startupScriptPaths.add(startupScriptPath);
                continue;
            }
            GWTPluginLog.logWarning("Could not calculate startup script reference for module " + moduleFile.getQualifiedName() + "; skipping.");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(this.getDocType()) + "\n");
        sb.append("<html>\n");
        sb.append("  <head>\n");
        sb.append("    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n");
        String hostPageName = new Path(this.wizardPage.getFileName()).removeFileExtension().toString();
        sb.append("    <title>" + hostPageName + "</title>\n");
        for (String startupScriptPath : startupScriptPaths) {
            sb.append("    <script type=\"text/javascript\" language=\"javascript\" src=\"" + startupScriptPath + "\"></script>\n");
        }
        if (startupScriptPaths.size() == 0) {
            sb.append("    <!-- Could not find GWT module loading script. Is this page in a valid location? -->\n");
            sb.append("    <!-- <script type=\"text/javascript\" language=\"javascript\" src=\"(gwt module name here).nocache.js\"></script> -->\n");
        }
        sb.append("  </head>\n");
        sb.append("\n");
        sb.append("  <body>\n");
        if (this.wizardPage.isHistorySupportIncluded()) {
            sb.append("    <iframe src=\"javascript:''\" id=\"__gwt_historyFrame\" tabIndex='-1' style=\"position:absolute;width:0;height:0;border:0\"></iframe>\n");
        }
        sb.append("\n");
        sb.append("  </body>\n");
        sb.append("</html>");
        String html = sb.toString();
        ByteArrayInputStream stream = new ByteArrayInputStream(html.getBytes());
        return stream;
    }

    private String determineStartupScriptPath(IPath workspaceRelativeHtmlPath, ModuleFile referencedModule) {
        IPath outRelativeHtmlPath = this.getOutDirRelativeHtmlPath(workspaceRelativeHtmlPath);
        if (outRelativeHtmlPath == null) {
            return null;
        }
        IPath outRelativeStartupScriptPath = this.getOutDirRelativeStartupScriptPath(referencedModule);
        return NewHostPageWizard.getRelativeUrl(outRelativeHtmlPath, outRelativeStartupScriptPath);
    }

    private String getDocType() {
        try {
            String firstLine;
            URLClassLoader cl;
            String hostPageTemplate;
            int firstLineEnding;
            IProject project = this.wizardPage.getProject();
            GwtSdk sdk = GwtSdk.findSdkFor(JavaCore.create((IProject)project));
            if (sdk != null && (firstLineEnding = (hostPageTemplate = ResourceUtils.getResourceAsString((ClassLoader)(cl = sdk.createClassLoader()), (String)"com/google/gwt/user/tools/templates/sample/_warFolder_/_moduleShortName_.htmlsrc")).indexOf(10)) > -1 && (firstLine = hostPageTemplate.substring(0, firstLineEnding)).toUpperCase().contains("DOCTYPE")) {
                return firstLine.trim();
            }
        }
        catch (CoreException e) {
            GWTPluginLog.logError(e);
        }
        catch (MalformedURLException e) {
            GWTPluginLog.logError(e);
        }
        catch (Sdk.SdkException e) {
            GWTPluginLog.logError(e);
        }
        return "<!doctype html>";
    }

    private IPath getOutDirRelativeHtmlPath(IPath workspaceRelativeHtmlPath) {
        IPath warRelativePath;
        IFolder warFolder;
        IProject project = this.wizardPage.getProject();
        if (WebAppUtilities.isWebApp((IProject)project) && (warFolder = WebAppUtilities.getWarSrc((IProject)project)).exists() && (warRelativePath = NewHostPageWizard.getPathRelativeToAncestor(workspaceRelativeHtmlPath, warFolder.getFullPath())) != null) {
            return warRelativePath;
        }
        IModule[] iModuleArray = ModuleUtils.findAllModules(JavaCore.create((IProject)this.wizardPage.getProject()), false);
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            ModuleFile moduleFile = (ModuleFile)module;
            IPath moduleContainerPath = moduleFile.getFile().getParent().getFullPath();
            for (IPath modulePublicPath : module.getPublicPaths()) {
                IPath workspaceRelativePublicPath = moduleContainerPath.append(modulePublicPath);
                IPath publicRelativeHtmlPath = NewHostPageWizard.getPathRelativeToAncestor(workspaceRelativeHtmlPath, workspaceRelativePublicPath);
                if (publicRelativeHtmlPath == null) continue;
                return new Path(moduleFile.getCompiledName()).append(publicRelativeHtmlPath);
            }
            ++n2;
        }
        return null;
    }

    private IPath getOutDirRelativeStartupScriptPath(ModuleFile referencedModule) {
        String compiledName = referencedModule.getCompiledName();
        return new Path(compiledName).append(String.valueOf(compiledName) + ".nocache.js");
    }
}

