/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.WebAppUtilities;
import com.google.gwt.eclipse.core.launch.ui.EntryPointModulesSelectionBlock;
import com.google.gwt.eclipse.core.modules.ModuleFile;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.properties.GWTProjectProperties;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.wizards.AbstractNewFileWizard;
import com.google.gwt.eclipse.core.wizards.HostPagePathSelectionDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewHostPageWizardPage
extends WizardPage {
    private String fileName;
    private StringDialogField fileNameField;
    private SelectionButtonDialogFieldGroup hostPageElementsButtons;
    private IPath hostPagePath;
    private IProject hostPageProject;
    private EntryPointModulesSelectionBlock modulesBlock;
    private IStatus pageStatus;
    private boolean pageVisible;
    private StringButtonDialogField pathField;
    private StringButtonDialogField projectField;

    protected NewHostPageWizardPage() {
        super("newHostPage");
        this.setTitle("HTML page");
        this.setDescription("Create a new HTML page.");
        ProjectFieldAdapter projectAdapter = new ProjectFieldAdapter();
        this.projectField = new StringButtonDialogField((IStringButtonAdapter)projectAdapter);
        this.projectField.setDialogFieldListener((IDialogFieldListener)projectAdapter);
        this.projectField.setLabelText("Project:");
        this.projectField.setButtonLabel("Browse...");
        PathFieldAdapter publicPathAdapter = new PathFieldAdapter();
        this.pathField = new StringButtonDialogField((IStringButtonAdapter)publicPathAdapter);
        this.pathField.setDialogFieldListener((IDialogFieldListener)publicPathAdapter);
        this.pathField.setLabelText("Path:");
        this.pathField.setButtonLabel("Browse...");
        this.fileNameField = new StringDialogField();
        this.fileNameField.setDialogFieldListener((IDialogFieldListener)new HostPageFieldAdapter(null, null));
        this.fileNameField.setLabelText("File name:");
        this.modulesBlock = new EntryPointModulesSelectionBlock("Modules:", new HostPageFieldAdapter(null, null));
        String[] buttonNames = new String[]{"Support for browser history (Back, Forward, bookmarks)"};
        this.hostPageElementsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames, 1);
        this.hostPageElementsButtons.setLabelText("Which elements do you want to include in your page?");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int columns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        this.createProjectControls(composite, columns);
        this.createPathControls(composite, columns);
        this.createSeparator(composite, columns);
        this.createFileNameControls(composite, columns);
        this.createModulesComponent(composite, columns);
        this.createPageElementsControls(composite, columns);
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<ModuleFile> getModules() {
        ArrayList<ModuleFile> modules = new ArrayList<ModuleFile>();
        for (String moduleName : this.modulesBlock.getModules()) {
            ModuleFile module = (ModuleFile)ModuleUtils.findModule(this.getJavaProject(), moduleName, false);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    public IPath getPath() {
        return this.hostPagePath;
    }

    public IProject getProject() {
        return this.hostPageProject;
    }

    public void init(IResource selection) {
        if (this.initProject(selection)) {
            this.initPath(selection);
            this.initModules(selection);
        }
        this.setPageElementsSelection(true);
        this.validateFields();
    }

    public boolean isHistorySupportIncluded() {
        return this.hostPageElementsButtons.isSelected(0);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.pageVisible = visible;
        if (visible) {
            this.setFocus();
            if (this.pageStatus.matches(4)) {
                StatusInfo status = new StatusInfo();
                status.setError("");
                this.pageStatus = status;
            }
        }
    }

    private IPath choosePath(IPath initialPath) {
        return HostPagePathSelectionDialog.show(this.getShell(), this.hostPageProject, initialPath);
    }

    private IJavaProject chooseProject() {
        IJavaProject[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)Util.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
            projects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> gwtProjects = new ArrayList<IJavaProject>();
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            if (GWTNature.isGWTProject(project.getProject())) {
                gwtProjects.add(project);
            }
            ++n2;
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection");
        dialog.setMessage("Choose a project for the new HTML page");
        dialog.setElements((Object[])gwtProjects.toArray(new IJavaProject[0]));
        dialog.setInitialSelections(new Object[]{this.getJavaProject()});
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private void createFileNameControls(Composite composite, int columns) {
        this.fileNameField.doFillIntoGrid(composite, columns - 1);
        DialogField.createEmptySpace((Composite)composite);
        this.setFieldWidthHint(this.fileNameField);
        Text text = this.fileNameField.getTextControl(null);
        LayoutUtil.setHorizontalGrabbing((Control)text);
    }

    private void createModulesComponent(Composite parent, int columns) {
        this.modulesBlock.doFillIntoGrid(parent, columns);
    }

    private void createPageElementsControls(Composite composite, int nColumns) {
        Label labelControl = this.hostPageElementsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, (int)nColumns);
        DialogField.createEmptySpace((Composite)composite);
        Composite buttonGroup = this.hostPageElementsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, (int)(nColumns - 1));
    }

    private void createPathControls(Composite composite, int columns) {
        this.pathField.doFillIntoGrid(composite, columns);
        this.setFieldWidthHint((StringDialogField)this.pathField);
    }

    private void createProjectControls(Composite composite, int columns) {
        this.projectField.doFillIntoGrid(composite, columns);
        this.setFieldWidthHint((StringDialogField)this.projectField);
    }

    private void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    private IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.hostPageProject);
    }

    private boolean initModules(IResource selection) {
        if (ModuleUtils.isModuleXml(selection)) {
            ModuleFile module = ModuleUtils.create((IFile)selection);
            List<String> moduleNames = Arrays.asList(module.getQualifiedName());
            this.modulesBlock.setModules(moduleNames);
        } else {
            this.modulesBlock.setModules(GWTProjectProperties.getEntryPointModules(this.hostPageProject));
        }
        this.modulesBlock.setDefaultModules(GWTProjectProperties.getEntryPointModules(this.hostPageProject));
        return true;
    }

    private boolean initPath(IResource selection) {
        if (!WebAppUtilities.isWebApp((IProject)this.hostPageProject)) {
            return false;
        }
        IFolder container = null;
        try {
            IFolder warFolder = WebAppUtilities.getWarSrc((IProject)this.hostPageProject);
            if (selection.getType() == 2 && warFolder.getFullPath().isPrefixOf(selection.getFullPath())) {
                container = (IFolder)selection;
                return true;
            }
            if (warFolder.exists()) {
                container = warFolder;
                return true;
            }
            return false;
        }
        finally {
            if (container != null) {
                this.pathField.setText(container.getFullPath().removeFirstSegments(1).toString());
            }
        }
    }

    private boolean initProject(IResource selection) {
        IProject project = selection.getProject();
        if (project != null && GWTNature.isGWTProject(project)) {
            this.projectField.setText(project.getFullPath().makeRelative().toString());
            return true;
        }
        return false;
    }

    private void setFieldWidthHint(StringDialogField field) {
        Text text = field.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.convertWidthInCharsToPixels(40));
    }

    private void setFocus() {
        this.fileNameField.setFocus();
    }

    private void setPageElementsSelection(boolean historySupport) {
        this.hostPageElementsButtons.setSelection(0, historySupport);
    }

    private void updateModulesIfProjectChanged() {
        if (this.hostPageProject != null) {
            if (this.hostPageProject != null && !this.getJavaProject().equals(this.modulesBlock.getJavaProject())) {
                this.modulesBlock.setJavaProject(this.getJavaProject());
                this.modulesBlock.setDefaultModules(GWTProjectProperties.getEntryPointModules(this.hostPageProject));
                this.modulesBlock.setModules(GWTProjectProperties.getEntryPointModules(this.hostPageProject));
            }
        } else {
            this.modulesBlock.setJavaProject(null);
            this.modulesBlock.setDefaultModules(Collections.emptyList());
            this.modulesBlock.setModules(Collections.emptyList());
        }
    }

    private void updateStatus(IStatus status) {
        this.pageStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.pageVisible) {
            if (status.isOK()) {
                this.setErrorMessage(null);
                this.setMessage(null);
            } else {
                StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
            }
        }
    }

    private void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere((IStatus[])status));
    }

    private void validateFields() {
        IStatus projectStatus = this.validateProject();
        IStatus moduleStatus = this.validateModules();
        IStatus pathStatus = this.validatePath();
        IStatus fileNameStatus = this.validateFileName();
        this.updateStatus(new IStatus[]{projectStatus, moduleStatus, pathStatus, fileNameStatus});
    }

    private IStatus validateFileName() {
        this.fileName = null;
        String str = this.fileNameField.getText().trim();
        if (str.length() == 0) {
            return Util.newErrorStatus("Enter a file name");
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(str, 1);
        if (nameStatus.matches(4)) {
            return Util.newErrorStatus("Invalid file name. {0}", nameStatus.getMessage());
        }
        if (this.hostPagePath != null) {
            IPath htmlFilePath = this.hostPagePath.append(str).removeFileExtension().addFileExtension(((AbstractNewFileWizard)this.getWizard()).getFileExtension());
            IFile htmlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(htmlFilePath);
            if (htmlFile.exists()) {
                return Util.newErrorStatus("''{0}'' already exists", htmlFilePath.toString());
            }
        }
        this.fileName = str;
        return Status.OK_STATUS;
    }

    private IStatus validateModules() {
        this.updateModulesIfProjectChanged();
        if (this.modulesBlock.getModules().isEmpty()) {
            return StatusUtilities.newErrorStatus((String)"Add one or more modules", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        return StatusUtilities.OK_STATUS;
    }

    private IStatus validatePath() {
        this.hostPagePath = null;
        this.pathField.enableButton(this.hostPageProject != null);
        String str = this.pathField.getText().trim();
        if (str.length() == 0) {
            return Util.newErrorStatus("Enter the file path");
        }
        if (this.hostPageProject == null) {
            return Status.OK_STATUS;
        }
        IPath path = new Path(this.hostPageProject.getName()).append(str).makeAbsolute();
        IStatus pathStatus = ResourcesPlugin.getWorkspace().validatePath(path.toString(), 2);
        if (pathStatus.matches(4)) {
            return Util.newErrorStatus("Invalid path. {0}", pathStatus.getMessage());
        }
        this.hostPagePath = path;
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (!folder.exists()) {
            return Util.newWarningStatus(MessageFormat.format("The path ''{0}'' does not exist.  It will be created when you click Finish.", path.toString()));
        }
        return Status.OK_STATUS;
    }

    private IStatus validateProject() {
        this.hostPageProject = null;
        String str = this.projectField.getText().trim();
        if (str.length() == 0) {
            return Util.newErrorStatus("Enter the project name");
        }
        Path path = new Path(str);
        if (path.segmentCount() != 1) {
            return Util.newErrorStatus("Invalid project path");
        }
        IProject project = Util.getWorkspaceRoot().getProject(str);
        if (!project.exists()) {
            return Util.newErrorStatus("Project does not exist");
        }
        if (!project.isOpen()) {
            return Util.newErrorStatus("Project is not open");
        }
        if (!GWTNature.isGWTProject(project)) {
            return Util.newErrorStatus("Project is not a GWT project");
        }
        this.hostPageProject = project;
        return Status.OK_STATUS;
    }

    private class HostPageFieldAdapter
    implements IDialogFieldListener,
    EntryPointModulesSelectionBlock.IModulesChangeListener {
        private HostPageFieldAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            NewHostPageWizardPage.this.validateFields();
        }

        @Override
        public void onModulesChanged() {
            NewHostPageWizardPage.this.validateFields();
        }

        /* synthetic */ HostPageFieldAdapter(HostPageFieldAdapter hostPageFieldAdapter, HostPageFieldAdapter hostPageFieldAdapter2) {
            this();
        }
    }

    private class PathFieldAdapter
    extends HostPageFieldAdapter
    implements IStringButtonAdapter {
        private PathFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IPath path = NewHostPageWizardPage.this.choosePath((IPath)new Path(NewHostPageWizardPage.this.pathField.getText()));
            if (path != null) {
                NewHostPageWizardPage.this.pathField.setText(path.removeFirstSegments(1).toString());
            }
        }
    }

    private class ProjectFieldAdapter
    extends HostPageFieldAdapter
    implements IStringButtonAdapter {
        private ProjectFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IJavaProject jproject = NewHostPageWizardPage.this.chooseProject();
            if (jproject != null) {
                IPath path = jproject.getProject().getFullPath().makeRelative();
                NewHostPageWizardPage.this.projectField.setText(path.toString());
            }
        }
    }
}

