/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.runtime.GwtSdk;
import com.google.gwt.eclipse.core.util.Util;
import com.google.gwt.eclipse.core.wizards.AbstractNewFileWizard;
import com.google.gwt.eclipse.core.wizards.NewModuleWizardPage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class NewModuleWizard
extends AbstractNewFileWizard {
    private static final String NO_VERSION_FOUND_DTD = "<!DOCTYPE module PUBLIC \"-//Google Inc.//DTD GWT//EN\" \"http://gwtproject.org/doctype/2.8.1/gwt-module.dtd\">";
    private NewModuleWizardPage newModuleWizardPage;

    public void addPages() {
        this.newModuleWizardPage = new NewModuleWizardPage();
        this.newModuleWizardPage.initModulePage(this.getSelection());
        this.addPage((IWizardPage)this.newModuleWizardPage);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setHelpAvailable(false);
        this.setWindowTitle("New GWT Module");
        this.setDefaultPageImageDescriptor(GWTPlugin.getDefault().getImageDescriptor("com.gwtplugins.gwt.eclipse.core.images.newModuleLarge"));
    }

    @Override
    public boolean performFinish() {
        IPackageFragmentRoot root = this.newModuleWizardPage.getPackageFragmentRoot();
        String packName = this.newModuleWizardPage.getModulePackageName();
        try {
            IFolder folder;
            IFolder publicFolder;
            IPackageFragment createdPackageFragment = root.createPackageFragment(packName, false, (IProgressMonitor)new NullProgressMonitor());
            if (this.newModuleWizardPage.shouldCreateClientPackage()) {
                String clientPackName = null;
                clientPackName = packName == null || packName.length() == 0 ? "client" : String.valueOf(packName) + ".client";
                root.createPackageFragment(clientPackName, false, (IProgressMonitor)new NullProgressMonitor());
            }
            if (this.newModuleWizardPage.shouldCreatePublicPath() && !(publicFolder = (folder = (IFolder)createdPackageFragment.getCorrespondingResource()).getFolder("public")).exists()) {
                publicFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"An error occurred while attempting to create a new GWT Module", (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e));
            GWTPluginLog.logError(e, "Unable to create new GWT Module with source folder: {0}, name: {1}, package: {2}, createClientPackage: {4}, createPublicPath: {5}", this.newModuleWizardPage.getPackageFragmentRootText(), this.newModuleWizardPage.getModuleName(), this.newModuleWizardPage.shouldCreateClientPackage(), this.newModuleWizardPage.shouldCreatePublicPath());
            return false;
        }
        return super.performFinish();
    }

    @Override
    protected String getFileExtension() {
        return "gwt.xml";
    }

    @Override
    protected IPath getFilePath() {
        return this.newModuleWizardPage.getModulePath();
    }

    @Override
    protected InputStream getInitialContents() {
        String versionNum;
        ArrayList<String> contents = new ArrayList<String>();
        IPackageFragmentRoot root = this.newModuleWizardPage.getPackageFragmentRoot();
        IJavaProject javaProject = root.getJavaProject();
        contents.add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        String gwtModuleDtd = NO_VERSION_FOUND_DTD;
        GwtSdk runtime = GwtSdk.findSdkFor(javaProject);
        if (runtime != null && !(versionNum = runtime.getVersion()).endsWith(".999") && !versionNum.startsWith("0.0")) {
            gwtModuleDtd = "<!DOCTYPE module PUBLIC \"-//Google Inc.//DTD Google Web Toolkit " + versionNum + "//EN\" \"http://google-web-toolkit.googlecode.com/svn/tags/" + versionNum + "/distro-source/core/src/gwt-module.dtd\">";
        }
        contents.add(gwtModuleDtd);
        contents.add("<module>");
        List<IModule> moduleInherits = this.newModuleWizardPage.getModuleInherits();
        for (IModule moduleInherit : moduleInherits) {
            contents.add("\t<inherits name=\"" + moduleInherit.getQualifiedName() + "\" />");
        }
        contents.add("\t<source path=\"client\"/>");
        contents.add("</module>");
        String xml = Util.join(contents, System.getProperty("line.separator"));
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes());
        return stream;
    }
}

