/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.JavaProjectUtilities;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.dialogs.ModuleSelectionDialog;
import com.google.gwt.eclipse.core.modules.IModule;
import com.google.gwt.eclipse.core.modules.ModuleUtils;
import com.google.gwt.eclipse.core.nature.GWTNature;
import com.google.gwt.eclipse.core.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class NewModuleWizardPage
extends NewContainerWizardPage {
    private static int ADD_INHERITS_BUTTON_GROUP_INDEX = 0;
    private static int CLIENT_PACKAGE_CHECKBOX_GROUP_INDEX = 1;
    private static int PUBLIC_PATH_CHECKBOX_GROUP_INDEX = 0;
    private static int REMOVE_INHERITS_BUTTON_GROUP_INDEX = 2;
    protected IStatus moduleContainerStatus;
    protected IStatus moduleNameStatus;
    protected IStatus modulePackageStatus;
    private SelectionButtonDialogFieldGroup moduleCreateElementsCheckboxes;
    private ListDialogField<IModule> moduleInheritsDialogField;
    private StringDialogField moduleNameField;
    private JavaPackageCompletionProcessor modulePackageCompletionProcessor;
    private StringButtonStatusDialogField modulePackageField;

    public NewModuleWizardPage() {
        super("newModuleWizardPage");
        this.setTitle("New GWT Module");
        this.setDescription("Create a new GWT Module.");
        ModuleDialogFieldAdapter adapter = new ModuleDialogFieldAdapter();
        this.modulePackageField = new StringButtonStatusDialogField((IStringButtonAdapter)adapter);
        this.modulePackageField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.modulePackageField.setLabelText("Package:");
        this.modulePackageField.setButtonLabel(NewWizardMessages.NewTypeWizardPage_package_button);
        this.modulePackageField.setStatusWidthHint(NewWizardMessages.NewTypeWizardPage_default);
        this.modulePackageCompletionProcessor = new JavaPackageCompletionProcessor();
        this.moduleNameField = new StringDialogField();
        this.moduleNameField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.moduleNameField.setLabelText("Module name:");
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.NewTypeWizardPage_interfaces_add;
        stringArray[2] = NewWizardMessages.NewTypeWizardPage_interfaces_remove;
        String[] addButtons = stringArray;
        this.moduleInheritsDialogField = new ListDialogField((IListAdapter)adapter, addButtons, (ILabelProvider)new ModuleSelectionLabelProvider());
        this.moduleInheritsDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.moduleInheritsDialogField.setTableColumns(new ListDialogField.ColumnsDescription(1, false));
        this.moduleInheritsDialogField.setLabelText("Inherited modules:");
        this.moduleInheritsDialogField.setRemoveButtonIndex(REMOVE_INHERITS_BUTTON_GROUP_INDEX);
        String[] buttonNames = new String[]{"Create public resource path", "Create package for client source"};
        this.moduleCreateElementsCheckboxes = new SelectionButtonDialogFieldGroup(32, buttonNames, 1);
        this.moduleContainerStatus = new StatusInfo();
        this.modulePackageStatus = new StatusInfo();
        this.moduleNameStatus = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createModuleNameControls(composite, nColumns);
        this.createModuleInheritsControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    public List<IModule> getModuleInherits() {
        return new ArrayList<IModule>(this.moduleInheritsDialogField.getElements());
    }

    public String getModuleName() {
        return this.moduleNameField.getText();
    }

    public String getModulePackageName() {
        return this.modulePackageField.getText();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    public boolean shouldCreateClientPackage() {
        return true;
    }

    public boolean shouldCreatePublicPath() {
        return false;
    }

    protected void createModuleInheritsControls(Composite composite, int nColumns) {
        this.moduleInheritsDialogField.doFillIntoGrid(composite, nColumns);
    }

    protected void createModuleNameControls(Composite composite, int nColumns) {
        this.moduleNameField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        Text moduleNameText = this.moduleNameField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)moduleNameText, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)moduleNameText);
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.modulePackageField.doFillIntoGrid(composite, nColumns);
        Text modulePackageText = this.modulePackageField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)modulePackageText, (int)this.getMaxFieldWidth());
        ControlContentAssistHelper.createTextContentAssistant((Text)modulePackageText, (IContentAssistProcessor)this.modulePackageCompletionProcessor);
        TextFieldNavigationHandler.install((Text)modulePackageText);
    }

    protected void doFieldChange(String fieldName, DialogField field) {
        if ("NewContainerWizardPage.container".equals(fieldName)) {
            this.moduleContainerStatus = this.moduleContainerChanged();
            this.modulePackageStatus = this.packageChanged();
            this.moduleNameStatus = this.nameChanged();
        } else if (field == this.modulePackageField) {
            this.modulePackageStatus = this.packageChanged();
            this.moduleNameStatus = this.nameChanged();
        } else if (field == this.moduleNameField) {
            this.moduleNameStatus = this.nameChanged();
        }
        this.doStatusUpdate();
    }

    protected IPath getModulePath() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPath rootPath = root.getPath();
        String packageName = this.getModulePackageName();
        if (packageName != null && packageName.length() > 0) {
            rootPath = rootPath.append(packageName.replace('.', '/'));
        }
        IPath moduleFilePath = rootPath.append(this.getModuleName());
        moduleFilePath = moduleFilePath.addFileExtension("gwt.xml");
        return moduleFilePath;
    }

    protected void handleFieldChanged(String fieldName) {
        this.doFieldChange(fieldName, null);
    }

    protected void initModulePage(IStructuredSelection selection) {
        IPackageFragment pf;
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        String pName = "";
        if (jelem != null && (pf = (IPackageFragment)jelem.getAncestor(4)) != null) {
            pName = pf.getElementName();
        }
        this.modulePackageField.setText(pName);
        this.modulePackageCompletionProcessor.setPackageFragmentRoot(this.getPackageFragmentRoot());
        this.moduleCreateElementsCheckboxes.setSelection(CLIENT_PACKAGE_CHECKBOX_GROUP_INDEX, true);
        this.moduleCreateElementsCheckboxes.setSelection(PUBLIC_PATH_CHECKBOX_GROUP_INDEX, true);
        this.doFieldChange("NewContainerWizardPage.container", null);
    }

    private void addCommonGWTModulesAsDefaultInherits() {
        IModule gwtUserModule;
        IJavaProject javaProject = this.getJavaProject();
        assert (JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)javaProject) && GWTNature.isGWTProject(javaProject.getProject()));
        if (javaProject.getResource().isAccessible() && (gwtUserModule = ModuleUtils.findModule(javaProject, "com.google.gwt.user.User", true)) != null) {
            this.addModuleIfNotAlreadyInList(gwtUserModule);
        }
    }

    private void addModuleIfNotAlreadyInList(IModule module) {
        for (Object elem : this.moduleInheritsDialogField.getElements()) {
            IModule curModule = (IModule)elem;
            if (!curModule.getQualifiedName().equals(module.getQualifiedName())) continue;
            return;
        }
        this.moduleInheritsDialogField.addElement((Object)module);
    }

    private IPackageFragment choosePackage() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (root != null && root.exists()) {
                packages = root.getChildren();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_title);
        dialog.setMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_description);
        dialog.setEmptyListMessage(NewWizardMessages.NewTypeWizardPage_ChoosePackageDialog_empty);
        dialog.setElements(packages);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.moduleContainerStatus, this.modulePackageStatus, this.moduleNameStatus};
        this.updateStatus(status);
    }

    private void moduleAddInheritsButtonPressed() {
        IModule module = ModuleSelectionDialog.show(this.getShell(), this.getPackageFragmentRoot().getJavaProject(), true);
        if (module == null) {
            return;
        }
        this.addModuleIfNotAlreadyInList(module);
    }

    private IStatus moduleContainerChanged() {
        if (!(this.getPackageFragmentRoot() != null && this.getPackageFragmentRoot().exists() && JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)this.getJavaProject()) && GWTNature.isGWTProject(this.getJavaProject().getProject()))) {
            this.modulePackageField.enableButton(false);
            this.moduleInheritsDialogField.enableButton(ADD_INHERITS_BUTTON_GROUP_INDEX, false);
        } else {
            this.modulePackageField.enableButton(true);
            this.moduleInheritsDialogField.enableButton(ADD_INHERITS_BUTTON_GROUP_INDEX, true);
        }
        this.modulePackageCompletionProcessor.setPackageFragmentRoot(this.getPackageFragmentRoot());
        if (this.fContainerStatus.getSeverity() == 4) {
            return this.fContainerStatus;
        }
        if (this.fContainerStatus.getSeverity() == 2) {
            return Util.newErrorStatus(this.fContainerStatus.getMessage());
        }
        if (JavaProjectUtilities.isJavaProjectNonNullAndExists((IJavaProject)this.getJavaProject()) && !GWTNature.isGWTProject(this.getJavaProject().getProject())) {
            return Util.newErrorStatus("The source folder is not part of a GWT Project.");
        }
        if (this.moduleInheritsDialogField.getElements().isEmpty()) {
            this.addCommonGWTModulesAsDefaultInherits();
        }
        return this.fContainerStatus;
    }

    private void moduleDialogFieldChanged(DialogField field) {
        this.doFieldChange(null, field);
    }

    private void modulePackageBrowseButtonPressed() {
        IPackageFragment result = this.choosePackage();
        if (result != null) {
            this.modulePackageField.setText(result.getElementName());
        }
        this.doFieldChange(null, (DialogField)this.modulePackageField);
    }

    private void moduleRemoveInheritsButtonPressed() {
        this.moduleInheritsDialogField.removeElements(this.moduleInheritsDialogField.getSelectedElements());
    }

    private IStatus nameChanged() {
        return ModuleUtils.validateSimpleModuleName(this.moduleNameField.getText());
    }

    private IStatus packageChanged() {
        String packName = this.modulePackageField.getText();
        IStatus validatePackageStatus = Util.validatePackageName(packName);
        if (validatePackageStatus.getSeverity() == 4) {
            return validatePackageStatus;
        }
        if (packName.length() == 0) {
            this.modulePackageField.setStatus(NewWizardMessages.NewTypeWizardPage_default);
        } else {
            this.modulePackageField.setStatus("");
        }
        IJavaProject project = this.getJavaProject();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (project != null && root != null && project.exists() && packName.length() > 0) {
            try {
                IPath packagePath;
                IPath rootPath = root.getPath();
                IPath outputPath = project.getOutputLocation();
                if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                    return Util.newErrorStatus(NewWizardMessages.NewTypeWizardPage_error_ClashOutputLocation);
                }
            }
            catch (JavaModelException e) {
                GWTPluginLog.logError(e);
            }
        }
        return validatePackageStatus;
    }

    private void setFocus() {
        if (this.moduleNameField.isEnabled()) {
            this.moduleNameField.setFocus();
        } else {
            this.setFocusOnContainer();
        }
    }

    private class ModuleDialogFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter<IModule> {
        private ModuleDialogFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            if (field == NewModuleWizardPage.this.modulePackageField) {
                NewModuleWizardPage.this.modulePackageBrowseButtonPressed();
            }
        }

        public void customButtonPressed(ListDialogField<IModule> field, int index) {
            if (index == ADD_INHERITS_BUTTON_GROUP_INDEX) {
                NewModuleWizardPage.this.moduleAddInheritsButtonPressed();
            } else {
                NewModuleWizardPage.this.moduleRemoveInheritsButtonPressed();
            }
        }

        public void dialogFieldChanged(DialogField field) {
            NewModuleWizardPage.this.moduleDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField<IModule> field) {
        }

        public void selectionChanged(ListDialogField<IModule> field) {
        }
    }

    public static class ModuleSelectionLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            assert (element instanceof IModule);
            return GWTPlugin.getDefault().getImage("com.gwtplugins.gwt.eclipse.core.images.moduleIcon");
        }

        public String getText(Object element) {
            assert (element instanceof IModule);
            return ((IModule)element).getQualifiedName();
        }
    }
}

