/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards;

import com.google.gdt.eclipse.core.StatusUtilities;
import com.google.gdt.eclipse.core.java.JavaModelSearch;
import com.google.gwt.eclipse.core.GWTPluginLog;
import com.google.gwt.eclipse.core.preferences.GWTPreferences;
import com.google.gwt.eclipse.core.uibinder.resources.HtmlBasedUiBinderResourceCreator;
import com.google.gwt.eclipse.core.uibinder.resources.UiBinderResourceCreator;
import com.google.gwt.eclipse.core.uibinder.resources.WidgetBasedUiBinderResourceCreator;
import com.google.gwt.eclipse.core.wizards.AbstractNewTypeWizardPage;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NewUiBinderWizardPage
extends AbstractNewTypeWizardPage {
    private static final int HTML_UI_INDEX = 1;
    private static final int WIDGETS_UI_INDEX = 0;
    private SelectionButtonDialogField addSampleContentButton;
    private SelectionButtonDialogFieldGroup uiTypeButtons = new SelectionButtonDialogFieldGroup(16, new String[]{"GWT widge&ts", "&HTML"}, 4);
    private IFile uiXmlFile;

    public NewUiBinderWizardPage() {
        super("UiBinder", "Create a new UiBinder template and owner class.", true, "NewUiBinderWizardPage");
        this.uiTypeButtons.setLabelText("&Create UI based on:");
        this.uiTypeButtons.setSelection(0, true);
        this.addSampleContentButton = new SelectionButtonDialogField(32);
        this.addSampleContentButton.setLabelText("Generate &sample content");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createUiTypeControls(composite, nColumns);
        this.createSampleContentControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        super.createType(monitor);
        IPath uiXmlPath = this.getUiXmlFilePath();
        if (uiXmlPath == null) {
            GWTPluginLog.logError("Unable to compute path of new UiBinder template file");
            return;
        }
        this.uiXmlFile = this.createResourceCreator().createUiXmlFile(uiXmlPath, this.isAddComments(), this.isAddSampleContent());
        GWTPreferences.setUiBinderWizardGenerateContentDefault(this.isAddSampleContent());
    }

    public String getSuperClass() {
        return this.createResourceCreator().getOwnerSuperclass();
    }

    public List<String> getSuperInterfaces() {
        return this.createResourceCreator().getOwnerSuperinterfaces(this.isAddSampleContent());
    }

    public IFile getUiXmlFile() {
        return this.uiXmlFile;
    }

    public boolean isAddSampleContent() {
        return this.addSampleContentButton.isSelected();
    }

    public void setAddSampleContent(boolean addContent) {
        this.addSampleContentButton.setSelection(addContent);
    }

    protected IStatus containerChanged() {
        IStatus superStatus = super.containerChanged();
        if (superStatus.getSeverity() == 4) {
            return superStatus;
        }
        if (JavaModelSearch.findType((IJavaProject)this.getJavaProject(), (String)"com.google.gwt.uibinder.client.UiBinder") == null) {
            return StatusUtilities.newErrorStatus((String)"Project must be using GWT 2.0 or later to use UiBinder.", (String)"com.gwtplugins.gwt.eclipse.core");
        }
        return superStatus;
    }

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createResourceCreator().createOwnerClassMembers(newType, imports, this.isAddComments(), this.isAddSampleContent(), monitor);
    }

    @Override
    protected void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus};
        this.updateStatus(status);
    }

    protected void initTypePage(IJavaElement elem) {
        super.initTypePage(elem);
        this.setAddSampleContent(GWTPreferences.getUiBinderWizardGenerateContentDefault());
    }

    protected IStatus typeNameChanged() {
        IStatus ownerClassNameStatus = super.typeNameChanged();
        if (ownerClassNameStatus.getSeverity() == 4) {
            return ownerClassNameStatus;
        }
        StatusInfo uiXmlNameStatus = new StatusInfo();
        IPath uiXmlFilePath = this.getUiXmlFilePath();
        if (uiXmlFilePath != null && ResourcesPlugin.getWorkspace().getRoot().exists(uiXmlFilePath)) {
            uiXmlNameStatus.setError(MessageFormat.format("{0} already exists.", uiXmlFilePath.lastSegment()));
        }
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{ownerClassNameStatus, uiXmlNameStatus});
    }

    private UiBinderResourceCreator createResourceCreator() {
        if (this.isWidgetBasedUi()) {
            return new WidgetBasedUiBinderResourceCreator();
        }
        if (this.isHtmlBasedUi()) {
            return new HtmlBasedUiBinderResourceCreator();
        }
        GWTPluginLog.logWarning("UiBinder wizard: No UI type selection");
        return new WidgetBasedUiBinderResourceCreator();
    }

    private void createSampleContentControls(Composite composite, int columns) {
        Label label = new Label(composite, 0);
        label.setText("Do you want to add sample content?");
        label.setLayoutData((Object)new GridData(4, 2, false, false, columns, 1));
        DialogField.createEmptySpace((Composite)composite);
        this.addSampleContentButton.doFillIntoGrid(composite, columns - 1);
    }

    private void createUiTypeControls(Composite composite, int columns) {
        this.uiTypeButtons.doFillIntoGrid(composite, columns);
    }

    private IPath getUiXmlFilePath() {
        IPackageFragment pckgFragment = this.getPackageFragment();
        if (pckgFragment == null) {
            return null;
        }
        return pckgFragment.getResource().getFullPath().append(String.valueOf(this.getTypeName()) + ".ui.xml");
    }

    private boolean isHtmlBasedUi() {
        return this.uiTypeButtons.isSelected(1);
    }

    private boolean isWidgetBasedUi() {
        return this.uiTypeButtons.isSelected(0);
    }
}

