/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.eclipse.core.wizards.rpc;

import com.google.gdt.eclipse.core.JavaASTUtils;
import com.google.gdt.eclipse.core.StringUtilities;
import com.google.gwt.eclipse.core.GWTPlugin;
import com.google.gwt.eclipse.core.validators.rpc.RemoteServiceUtilities;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewInterfaceWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewAsyncRemoteServiceInterfaceCreationWizardPage
extends NewInterfaceWizardPage {
    private static final String[] NO_STRINGS = new String[0];
    private final ITypeBinding syncTypeBinding;
    private final StringButtonDialogField syncTypeDialogField;

    public static List<IMethodBinding> computeSyncMethodsThatNeedAsyncVersions(ITypeBinding syncTypeBinding, ITypeBinding asyncTypeBinding) {
        List<IMethodBinding> overridableSyncMethods = NewAsyncRemoteServiceInterfaceCreationWizardPage.computeOverridableMethodsForInterface(syncTypeBinding);
        ArrayList<IMethodBinding> remainingMethods = new ArrayList<IMethodBinding>();
        for (IMethodBinding overridableSyncMethod : overridableSyncMethods) {
            IMethod syncMethod = (IMethod)overridableSyncMethod.getJavaElement();
            String[] asyncParameterTypes = RemoteServiceUtilities.computeAsyncParameterTypes(overridableSyncMethod);
            if (Bindings.findMethodInHierarchy((ITypeBinding)asyncTypeBinding, (String)syncMethod.getElementName(), (String[])asyncParameterTypes) != null) continue;
            remainingMethods.add(overridableSyncMethod);
        }
        return remainingMethods;
    }

    public static String createMethodContents(IType newType, ImportManagerAdapter imports, IMethodBinding overridableSyncMethod, boolean addComments) throws CoreException, JavaModelException {
        StringBuilder sb = new StringBuilder();
        IMethod syncMethod = (IMethod)overridableSyncMethod.getJavaElement();
        if (addComments) {
            String lineDelimiter = "\n";
            String comment = StubUtility.getMethodComment((ICompilationUnit)newType.getCompilationUnit(), (String)newType.getFullyQualifiedName(), (String)syncMethod.getElementName(), (String[])NO_STRINGS, (String[])NO_STRINGS, (String)"V", (String[])NO_STRINGS, (IMethod)syncMethod, (boolean)true, (String)lineDelimiter);
            if (comment != null) {
                sb.append(comment);
                sb.append(lineDelimiter);
            }
        }
        ITypeParameter[] typeParameters = syncMethod.getTypeParameters();
        ITypeBinding[] typeParameterBindings = overridableSyncMethod.getTypeParameters();
        if (typeParameters.length > 0) {
            sb.append("<");
            int i = 0;
            while (i < typeParameters.length) {
                sb.append(typeParameters[i].getElementName());
                ITypeBinding typeParameterBinding = typeParameterBindings[i];
                ITypeBinding[] typeBounds = typeParameterBinding.getTypeBounds();
                if (typeBounds.length > 0) {
                    sb.append(" extends ");
                    int j = 0;
                    while (j < typeBounds.length) {
                        if (j != 0) {
                            sb.append(" & ");
                        }
                        NewAsyncRemoteServiceInterfaceCreationWizardPage.expandTypeBinding(typeBounds[j], sb, imports);
                        ++j;
                    }
                }
                ++i;
            }
            sb.append(">");
        }
        sb.append("void ");
        sb.append(overridableSyncMethod.getName());
        sb.append("(");
        String[] parameterNames = syncMethod.getParameterNames();
        ITypeBinding[] parameterTypes = overridableSyncMethod.getParameterTypes();
        int i = 0;
        while (i < parameterNames.length) {
            if (i != 0) {
                sb.append(", ");
            }
            NewAsyncRemoteServiceInterfaceCreationWizardPage.expandTypeBinding(parameterTypes[i], sb, imports);
            sb.append(" ");
            sb.append(parameterNames[i]);
            ++i;
        }
        if (parameterNames.length > 0) {
            sb.append(", ");
        }
        sb.append(imports.addImport("com.google.gwt.user.client.rpc.AsyncCallback"));
        sb.append("<");
        ITypeBinding syncReturnType = overridableSyncMethod.getReturnType();
        if (syncReturnType.isPrimitive()) {
            String wrapperTypeName = JavaASTUtils.getWrapperTypeName((String)syncReturnType.getName());
            sb.append(imports.addImport(wrapperTypeName));
        } else {
            NewAsyncRemoteServiceInterfaceCreationWizardPage.expandTypeBinding(syncReturnType, sb, imports);
        }
        sb.append("> ");
        sb.append(StringUtilities.computeUniqueName((String[])parameterNames, (String)"callback"));
        sb.append(");");
        return sb.toString();
    }

    static void expandTypeBinding(ITypeBinding typeBinding, StringBuilder sb, ImportManagerAdapter importsManager) {
        if (typeBinding.isParameterizedType()) {
            NewAsyncRemoteServiceInterfaceCreationWizardPage.expandTypeBinding(typeBinding.getErasure(), sb, importsManager);
            sb.append("<");
            ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
            int i = 0;
            while (i < typeArguments.length) {
                if (i != 0) {
                    sb.append(", ");
                }
                NewAsyncRemoteServiceInterfaceCreationWizardPage.expandTypeBinding(typeArguments[i], sb, importsManager);
                ++i;
            }
            sb.append(">");
        } else if (typeBinding.isWildcardType()) {
            ITypeBinding bound = typeBinding.getBound();
            if (bound == null) {
                sb.append("?");
            } else {
                if (typeBinding.isUpperbound()) {
                    sb.append("? extends ");
                } else {
                    sb.append("? super ");
                }
                NewAsyncRemoteServiceInterfaceCreationWizardPage.expandTypeBinding(bound, sb, importsManager);
            }
        } else if (typeBinding.isTypeVariable()) {
            sb.append(typeBinding.getName());
        } else if (typeBinding.isArray()) {
            NewAsyncRemoteServiceInterfaceCreationWizardPage.expandTypeBinding(typeBinding.getComponentType(), sb, importsManager);
            sb.append("[]");
        } else if (typeBinding.isPrimitive()) {
            sb.append(typeBinding.getName());
        } else {
            sb.append(importsManager.addImport(typeBinding));
        }
    }

    private static List<IMethodBinding> computeOverridableMethodsForInterface(ITypeBinding interfaceBinding) {
        assert (interfaceBinding.isInterface());
        ArrayList<ITypeBinding> superInterfaces = new ArrayList<ITypeBinding>();
        RemoteServiceUtilities.expandSuperInterfaces(interfaceBinding, superInterfaces);
        ArrayList<IMethodBinding> overridableMethods = new ArrayList<IMethodBinding>();
        for (ITypeBinding superInterface : superInterfaces) {
            IMethodBinding[] iMethodBindingArray = superInterface.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodBinding declaredMethod = iMethodBindingArray[n2];
                if (NewAsyncRemoteServiceInterfaceCreationWizardPage.findOverridingMethod(declaredMethod, overridableMethods) == null) {
                    overridableMethods.add(declaredMethod);
                }
                ++n2;
            }
        }
        return overridableMethods;
    }

    private static IMethodBinding findOverridingMethod(IMethodBinding method, List<IMethodBinding> allMethods) {
        for (IMethodBinding cur : allMethods) {
            if (!Bindings.areOverriddenMethods((IMethodBinding)cur, (IMethodBinding)method) && !Bindings.isSubsignature((IMethodBinding)cur, (IMethodBinding)method)) continue;
            return cur;
        }
        return null;
    }

    public NewAsyncRemoteServiceInterfaceCreationWizardPage(ITypeBinding syncTypeBinding) {
        this.syncTypeBinding = syncTypeBinding;
        this.syncTypeDialogField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
            }
        });
        this.syncTypeDialogField.setButtonLabel("Browse...");
        this.syncTypeDialogField.setLabelText("Synchronous type:");
        this.syncTypeDialogField.setEnabled(false);
        this.syncTypeDialogField.setText(syncTypeBinding.getQualifiedName());
        ImageDescriptor imageDescriptor = GWTPlugin.getDefault().getImageRegistry().getDescriptor("com.gwtplugins.gwt.eclipse.core.images.newAsyncInterfaceLarge");
        this.setImageDescriptor(imageDescriptor);
        this.setDescription("Create a new asynchronous remote service interface");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSyncTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_interface_wizard_page_context");
    }

    protected void createTypeMembers(IType newType, final NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        TypeDeclaration asyncTypeDeclaration = JavaASTUtils.findTypeDeclaration((IJavaProject)newType.getJavaProject(), (String)newType.getFullyQualifiedName('.'));
        ITypeBinding asyncTypeBinding = asyncTypeDeclaration.resolveBinding();
        ImportManagerAdapter importAdapter = new ImportManagerAdapter(){

            @Override
            public String addImport(ITypeBinding typeBinding) {
                return imports.addImport(typeBinding);
            }

            @Override
            public String addImport(String qualifiedTypeName) {
                return imports.addImport(qualifiedTypeName);
            }
        };
        List<IMethodBinding> syncMethodsToConvert = NewAsyncRemoteServiceInterfaceCreationWizardPage.computeSyncMethodsThatNeedAsyncVersions(this.syncTypeBinding, asyncTypeBinding);
        for (IMethodBinding overridableSyncMethod : syncMethodsToConvert) {
            String methodContents = NewAsyncRemoteServiceInterfaceCreationWizardPage.createMethodContents(newType, importAdapter, overridableSyncMethod, this.isAddComments());
            newType.createMethod(methodContents, null, false, monitor);
        }
    }

    private void createSyncTypeControls(Composite composite, int columns) {
        this.syncTypeDialogField.doFillIntoGrid(composite, columns);
        Text text = this.syncTypeDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
    }

    public static interface ImportManagerAdapter {
        public String addImport(ITypeBinding var1);

        public String addImport(String var1);
    }
}

