/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.datastore.samples;

import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.DatastoreException;
import com.google.api.services.datastore.client.DatastoreHelper;
import com.google.cloud.hadoop.io.datastore.DatastoreHadoopHelper;
import com.google.protobuf.ByteString;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;

public class WordCountSetUp {
    static final String ANCESTOR_ENTITY_VALUE = "ancestor";

    private static void printUsageAndExit() {
        System.out.println("Usage: hadoop jar datastore_wordcountsetup.jar [datasetId] [inputKindName] [outputKindName] [fileName].  Please enter all parameters");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            WordCountSetUp.printUsageAndExit();
        }
        String datasetId = args[0];
        String inputKindName = args[1];
        String outputKindName = args[2];
        String fileName = args[3];
        Datastore ds = null;
        try {
            DatastoreHadoopHelper helper = new DatastoreHadoopHelper(new Configuration());
            ds = helper.createDatastore(datasetId);
        }
        catch (IOException exception) {
            String string = String.valueOf(exception.getMessage());
            System.err.println(string.length() != 0 ? "I/O error connecting to the datastore: ".concat(string) : new String("I/O error connecting to the datastore: "));
            System.exit(1);
        }
        WordCountSetUp.deleteAllOfKind(inputKindName, ds);
        WordCountSetUp.deleteAllOfKind(outputKindName, ds);
        WordCountSetUp.checkDeleted(inputKindName, ds);
        WordCountSetUp.checkDeleted(outputKindName, ds);
        WordCountSetUp.populateDatastoreFromFile(inputKindName, fileName, ds);
    }

    public static void deleteAllOfKind(String kind, Datastore ds) {
        DatastoreV1.Query.Builder q = DatastoreV1.Query.newBuilder();
        DatastoreV1.KindExpression.Builder kindBuilder = DatastoreV1.KindExpression.newBuilder();
        kindBuilder.setName(kind);
        q.addKind(kindBuilder);
        DatastoreV1.RunQueryRequest request = DatastoreV1.RunQueryRequest.newBuilder().setQuery(q).build();
        DatastoreV1.RunQueryResponse response = null;
        try {
            response = ds.runQuery(request);
        }
        catch (DatastoreException e) {
            String string = String.valueOf(e.getMessage());
            System.out.println(string.length() != 0 ? "WARNING: can't erase root!".concat(string) : new String("WARNING: can't erase root!"));
        }
        List result = null;
        while (response != null) {
            result = response.getBatch().getEntityResultList();
            DatastoreV1.CommitRequest.Builder bwRequest = DatastoreV1.CommitRequest.newBuilder();
            for (int i = 0; i < result.size(); ++i) {
                DatastoreV1.Mutation.Builder mutation = DatastoreV1.Mutation.newBuilder();
                mutation.addDelete(((DatastoreV1.EntityResult)result.get(i)).getEntity().getKey());
                try {
                    ds.commit(bwRequest.setMutation(mutation).setMode(DatastoreV1.CommitRequest.Mode.NON_TRANSACTIONAL).build());
                    continue;
                }
                catch (DatastoreException e) {
                    String string = String.valueOf(e.getMessage());
                    String string2 = String.valueOf(Arrays.toString(e.getStackTrace()));
                    System.out.println(string2.length() != 0 ? string.concat(string2) : new String(string));
                }
            }
            if (response.getBatch().getMoreResults() == DatastoreV1.QueryResultBatch.MoreResultsType.NOT_FINISHED) {
                ByteString endCursor = response.getBatch().getEndCursor();
                q.setStartCursor(endCursor);
                try {
                    response = ds.runQuery(request);
                }
                catch (DatastoreException e) {
                    String string = String.valueOf(e.getMessage());
                    System.out.println(string.length() != 0 ? "Datastore Error:".concat(string) : new String("Datastore Error:"));
                }
                continue;
            }
            response = null;
        }
    }

    public static void checkDeleted(String kind, Datastore ds) throws InterruptedException {
        int count = 0;
        while (count > 1) {
            DatastoreV1.Query.Builder q = DatastoreV1.Query.newBuilder();
            DatastoreV1.KindExpression.Builder kindBuilder = DatastoreV1.KindExpression.newBuilder();
            kindBuilder.setName(kind);
            q.addKind(kindBuilder);
            DatastoreV1.RunQueryRequest request = DatastoreV1.RunQueryRequest.newBuilder().setQuery(q).build();
            DatastoreV1.RunQueryResponse response = null;
            try {
                response = ds.runQuery(request);
            }
            catch (DatastoreException e) {
                String string = String.valueOf(e.getMessage());
                System.out.println(string.length() != 0 ? "DatastoreError".concat(string) : new String("DatastoreError"));
            }
            List result = response.getBatch().getEntityResultList();
            int n = count = result.size();
            System.out.println(new StringBuilder(52).append("Waiting for Datastore to update! Records:").append(n).toString());
            Thread.sleep(10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateDatastoreFromFile(String kind, String fileName, Datastore ds) throws IOException, DatastoreException {
        FileInputStream fstream = new FileInputStream(fileName);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        DatastoreV1.Key ancestor = DatastoreHelper.makeKey((Object[])new Object[]{kind, ANCESTOR_ENTITY_VALUE}).build();
        DatastoreV1.CommitRequest.Builder request = DatastoreV1.CommitRequest.newBuilder();
        DatastoreV1.Mutation.Builder mutation = DatastoreV1.Mutation.newBuilder();
        try {
            String line = "";
            int count = 0;
            while ((line = br.readLine()) != null) {
                DatastoreV1.Entity.Builder e = DatastoreV1.Entity.newBuilder().setKey(DatastoreHelper.makeKey((Object[])new Object[]{ancestor, kind, count + 1}));
                DatastoreV1.Value.Builder value = DatastoreV1.Value.newBuilder().setStringValue(line);
                e.addProperty(DatastoreV1.Property.newBuilder().setName("line").setValue(value.setIndexed(false)));
                mutation.addInsert(e);
                ++count;
            }
        }
        finally {
            br.close();
        }
        ds.commit(request.setMutation(mutation).setMode(DatastoreV1.CommitRequest.Mode.NON_TRANSACTIONAL).build());
    }
}

