/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(targets={"net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement$Placer"})
public class JigsawPlacementMixin {
    @Final
    @Shadow
    private List<? super PoolElementStructurePiece> f_210319_;

    @Redirect(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;getShuffledTemplates(Ljava/util/Random;)Ljava/util/List;"))
    private List<StructurePoolElement> getShuffledTemplates(StructureTemplatePool pool, Random rand) {
        boolean hasWaystone = this.f_210319_.stream().map(piece -> ((PoolElementStructurePiece)piece).m_209918_().toString()).anyMatch(pieceName -> pieceName.contains("waystones:") && pieceName.contains("/waystone"));
        boolean forceWaystone = WaystonesConfig.getActive().forceSpawnInVillages();
        if (hasWaystone) {
            return pool.m_210588_(rand).stream().filter(piece -> {
                String pieceName = piece.toString();
                return !pieceName.contains("waystones:") || !pieceName.contains("/waystone");
            }).collect(Collectors.toList());
        }
        if (forceWaystone || Math.random() <= (double)((float)this.f_210319_.size() / 200.0f)) {
            StructurePoolElement waystonePiece = null;
            List original = pool.m_210588_(rand);
            ArrayList<StructurePoolElement> result = new ArrayList<StructurePoolElement>();
            for (StructurePoolElement piece2 : original) {
                String pieceName2 = piece2.toString();
                if (pieceName2.contains("waystones:") && pieceName2.contains("/waystone")) {
                    waystonePiece = piece2;
                    continue;
                }
                result.add(piece2);
            }
            if (waystonePiece != null) {
                result.add(0, waystonePiece);
            }
            return result;
        }
        return pool.m_210588_(rand);
    }
}

