/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters;

import iskallia.vault.gear.item.VaultGearItem;
import java.util.function.Function;
import net.joseph.vaultfilters.VFTests;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class DataFixers {
    public static String getModifierName(String modifier) {
        int firstSpace = modifier.indexOf(32);
        if (modifier.contains("Cloud")) {
            int lastSpace = modifier.lastIndexOf(32);
            if (firstSpace == lastSpace) {
                return modifier.substring(1);
            }
            return modifier.substring(1, firstSpace) + modifier.substring(lastSpace);
        }
        String name = modifier.substring(firstSpace + 1);
        return name.startsWith("to ") ? name.substring(3) : name;
    }

    public static Number parseLevel(String modifierName, String modifier) {
        String numberString;
        boolean isPercent;
        int firstSpace = modifier.indexOf(32);
        int startIndex = 0;
        if (modifier.contains("Cloud")) {
            String cloudNumber;
            int lastSpace = modifier.lastIndexOf(32);
            if (firstSpace == lastSpace) {
                return 1;
            }
            return switch (cloudNumber = modifier.substring(firstSpace + 1, lastSpace)) {
                case "II" -> 2;
                case "III" -> 3;
                case "IV" -> 4;
                case "V" -> 5;
                default -> 1;
            };
        }
        if (modifier.charAt(0) == '+') {
            startIndex = 1;
        }
        if (isPercent = modifier.contains("%")) {
            --firstSpace;
        }
        if ((numberString = modifier.substring(startIndex, firstSpace)).isBlank()) {
            return 1;
        }
        Number level = DataFixers.getLevelType(modifierName, isPercent).apply(numberString);
        if (!isPercent && modifier.contains("Attack Speed")) {
            return (Double)level - 4.0;
        }
        return level;
    }

    private static Function<String, ? extends Number> getLevelType(String modifierName, boolean isPercent) {
        return switch (modifierName) {
            case "Mana" -> {
                if (isPercent) {
                    yield DataFixers::parseFloatPercent;
                }
                yield Integer::parseInt;
            }
            case "Armor", "Durability", "Chaining Attack", "Size", "Hammer Size" -> {
                if (isPercent) {
                    yield DataFixers::parseIntPercent;
                }
                yield Integer::parseInt;
            }
            case "Attack Damage", "Reach", "Attack Range", "Attack Speed" -> {
                if (isPercent) {
                    yield DataFixers::parseDoublePercent;
                }
                yield Double::parseDouble;
            }
            default -> modifierName.contains("level of") ? Integer::parseInt : (isPercent ? DataFixers::parseFloatPercent : Float::parseFloat);
        };
    }

    private static Integer parseIntPercent(String string) {
        return Integer.parseInt(string) / 100;
    }

    private static Double parseDoublePercent(String string) {
        return Double.parseDouble(string) / 100.0;
    }

    private static Float parseFloatPercent(String string) {
        return Float.valueOf(Float.parseFloat(string) / 100.0f);
    }

    public static void clearNBTCache(ItemStack itemStack) {
        Tag tag;
        if (itemStack.m_41720_() instanceof VaultGearItem && (tag = itemStack.m_41784_().m_128423_("clientCache")) instanceof CompoundTag) {
            CompoundTag clientCache = (CompoundTag)tag;
            clientCache.m_128473_(VFTests.filterKey);
        }
    }
}

