/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ModPresence {
    private static final int RECEIVE_MESSAGE_TIMEOUT = 600;
    private static final Map<UUID, Integer> SERVER_LOGIN_TICKS = new HashMap<UUID, Integer>();
    private static final Set<UUID> PLAYERS_WITH_VAULT_FILTERS = new HashSet<UUID>();
    private static boolean serverHasVaultFilters = false;
    private static int clientLoginTicks = 0;
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("vaultfilters", "main"), () -> "1", o -> true, o -> true);

    public static void init() {
        CHANNEL.messageBuilder(Message.class, 0).encoder(Message::encoder).decoder(Message::decoder).consumer(Message::consumer).add();
    }

    public static boolean serverHasVaultFilters() {
        return Minecraft.m_91087_().m_91090_() || serverHasVaultFilters;
    }

    public static boolean playerHasVaultFilters(UUID uuid) {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().m_91090_(), () -> () -> PLAYERS_WITH_VAULT_FILTERS.contains(uuid));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientConnect(ClientPlayerNetworkEvent.LoggedInEvent event) {
        CHANNEL.sendToServer((Object)new Message("1.17.0"));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91089_() == null || minecraft.f_91074_ == null || serverHasVaultFilters || event.phase != TickEvent.Phase.END || clientLoginTicks == 600) {
            return;
        }
        if (++clientLoginTicks == 600) {
            MutableComponent cNoVFOnServer = new TextComponent("Valid Vault Filters version not detected on server, Vault Filters features are disabled").m_130940_(ChatFormatting.RED);
            minecraft.f_91074_.m_5661_((Component)cNoVFOnServer, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        serverHasVaultFilters = false;
        clientLoginTicks = 0;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new Message("1.17.0"));
            SERVER_LOGIN_TICKS.put(player2.m_142081_(), 0);
        }
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public static void onServerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.END || !((player = event.player) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID uuid = player2.m_142081_();
        Integer ticks = SERVER_LOGIN_TICKS.get(uuid);
        if (ticks == null) {
            return;
        }
        if (ticks < 600) {
            SERVER_LOGIN_TICKS.put(uuid, ticks + 1);
        } else {
            MutableComponent s2cNoVaultFilters = new TextComponent("This server has Vault Filters installed, please install Vault Filters version 1.17.0 to use its features").m_130940_(ChatFormatting.RED);
            player2.m_5661_((Component)s2cNoVaultFilters, false);
            SERVER_LOGIN_TICKS.remove(uuid);
        }
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PLAYERS_WITH_VAULT_FILTERS.remove(player2.m_142081_());
            SERVER_LOGIN_TICKS.remove(player2.m_142081_());
        }
    }

    public static class Message {
        protected final String version;

        public Message(String version) {
            this.version = version;
        }

        public void encoder(FriendlyByteBuf buf) {
            buf.m_130070_(this.version);
        }

        public static Message decoder(FriendlyByteBuf buf) {
            return new Message(buf.m_130277_());
        }

        public void consumer(Supplier<NetworkEvent.Context> ctx) {
            NetworkEvent.Context context = ctx.get();
            LogicalSide side = context.getDirection().getReceptionSide();
            DistExecutor.unsafeRunForDist(() -> () -> {
                if (side.isClient()) {
                    serverHasVaultFilters = this.version.equals("1.17.0");
                    clientLoginTicks = 600;
                }
                return null;
            }, () -> () -> {
                ServerPlayer player;
                if (side.isServer() && (player = context.getSender()) != null) {
                    UUID uuid = player.m_142081_();
                    if (this.version.equals("1.17.0")) {
                        PLAYERS_WITH_VAULT_FILTERS.add(uuid);
                    } else {
                        MutableComponent s2cVersionMismatch = new TextComponent("Vault Filters version mismatch with the server, please install version 1.17.0 to use Vault Filter's features").m_130940_(ChatFormatting.RED);
                        player.m_5661_((Component)s2cVersionMismatch, false);
                    }
                    SERVER_LOGIN_TICKS.remove(uuid);
                }
                return null;
            });
            context.setPacketHandled(true);
        }
    }
}

