/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters;

import iskallia.vault.item.BoosterPackItem;
import java.util.concurrent.ConcurrentHashMap;
import net.joseph.vaultfilters.VFTests;
import net.joseph.vaultfilters.configs.VFServerConfig;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class VFCache {
    private static final ConcurrentHashMap<Integer, VFCache> ITEM_CACHES = new ConcurrentHashMap();
    private static int ticks = 0;
    private final int itemHash;
    private final ConcurrentHashMap<Integer, Boolean> filterMap;
    private int ttk;

    public VFCache(int itemHash) {
        this.itemHash = itemHash;
        this.filterMap = new ConcurrentHashMap();
        this.ttk = (Integer)VFServerConfig.CACHE_TTK.get();
    }

    public VFCache addFilter(int filterHash, boolean result) {
        this.filterMap.put(filterHash, result);
        this.resetTTK();
        return this;
    }

    public Boolean result(int filterHash) {
        Boolean result = this.filterMap.get(filterHash);
        if (result != null) {
            this.resetTTK();
        }
        return result;
    }

    public void resetTTK() {
        this.ttk = (Integer)VFServerConfig.CACHE_TTK.get();
    }

    public void tick() {
        if (this.ttk == 0) {
            ITEM_CACHES.remove(this.itemHash);
            return;
        }
        --this.ttk;
    }

    public static boolean getOrCreateFilter(ItemStack stack, Object filterStack, Level level) {
        int itemHash = stack.hashCode();
        VFCache cache = ITEM_CACHES.get(itemHash);
        if (cache == null) {
            boolean result = stack.m_41720_() instanceof BoosterPackItem ? VFTests.testCardPack(stack, filterStack, level) : VFTests.basicFilterTest(stack, filterStack, level);
            ITEM_CACHES.put(itemHash, new VFCache(itemHash).addFilter(filterStack.hashCode(), result));
            return result;
        }
        int filterHash = filterStack.hashCode();
        Boolean cachedResult = cache.result(filterHash);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = VFTests.basicFilterTest(stack, filterStack, level);
        cache.addFilter(filterHash, result);
        return result;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++ticks >= 1200) {
            ITEM_CACHES.values().forEach(VFCache::tick);
            ticks = 0;
        }
    }
}

