/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters;

import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.item.BoosterPackItem;
import iskallia.vault.item.CardItem;
import iskallia.vault.item.InfusedCatalystItem;
import iskallia.vault.item.InscriptionItem;
import iskallia.vault.item.gear.CharmItem;
import iskallia.vault.item.gear.TrinketItem;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import net.joseph.vaultfilters.CreateVersion;
import net.joseph.vaultfilters.DataFixers;
import net.joseph.vaultfilters.VFCache;
import net.joseph.vaultfilters.VaultFilters;
import net.joseph.vaultfilters.configs.VFServerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class VFTests {
    public static String filterKey = "hashes";
    private static MethodHandle testMethodHandle;
    private static Level level;

    public static boolean checkFilter(ItemStack stack, Object filterStack, boolean useCache, Level level) {
        if (!useCache) {
            return VFTests.basicFilterTest(stack, filterStack, level);
        }
        Item stackItem = stack.m_41720_();
        if (!(stackItem instanceof VaultGearItem || stackItem instanceof InscriptionItem || stackItem instanceof InfusedCatalystItem || stackItem instanceof CharmItem || stackItem instanceof TrinketItem || stackItem instanceof CardItem || stackItem instanceof BoosterPackItem)) {
            return VFTests.basicFilterTest(stack, filterStack, level);
        }
        if (((Boolean)VFServerConfig.CACHE_DATAFIX.get()).booleanValue() && filterStack instanceof ItemStack) {
            DataFixers.clearNBTCache(stack);
        }
        return VFCache.getOrCreateFilter(stack, filterStack, level);
    }

    public static boolean testCardPack(ItemStack stack, Object filterStack, Level level) {
        List cardPack = BoosterPackItem.getOutcomes((ItemStack)stack);
        boolean packMatch = VFTests.basicFilterTest(stack, filterStack, level);
        if (cardPack == null || packMatch) {
            return packMatch;
        }
        for (ItemStack card : cardPack) {
            if (!VFTests.basicFilterTest(card, filterStack, level)) continue;
            return true;
        }
        return false;
    }

    public static boolean basicFilterTest(ItemStack stack, Object filterStack, Level level) {
        if (level == null) {
            level = (Level)DistExecutor.unsafeRunForDist(() -> VFTests::getClientLevel, () -> () -> level);
        }
        if (CreateVersion.getLoadedVersion() == CreateVersion.CREATE_051F) {
            if (filterStack instanceof ItemStack) {
                ItemStack stackFilter = (ItemStack)filterStack;
                return FilterItemStack.of((ItemStack)stackFilter).test(level, stack);
            }
            if (filterStack instanceof FilterItemStack) {
                FilterItemStack filterItemStack = (FilterItemStack)filterStack;
                return filterItemStack.test(level, stack);
            }
            VaultFilters.LOGGER.debug("[0.5.1.f] invalid filter entered");
            return false;
        }
        if (CreateVersion.getLoadedVersion() == CreateVersion.LEGACY) {
            return VFTests.basicFilterTestLegacy(filterStack, stack, level);
        }
        return false;
    }

    private static boolean basicFilterTestLegacy(Object filterStack, ItemStack stack, Level level) {
        if (testMethodHandle == null) {
            throw new IllegalStateException("[0.5.1.b-e] could not find test method");
        }
        try {
            return testMethodHandle.invoke(level, stack, filterStack);
        }
        catch (Throwable e) {
            VaultFilters.LOGGER.error("[0.5.1.b-e] could not invoke test method", e);
            throw new IllegalStateException(e);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        MinecraftServer server = event.getWorld().m_142572_();
        if (server != null) {
            level = server.m_129880_(Level.f_46428_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Level getClientLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    static {
        if (CreateVersion.getLoadedVersion() == CreateVersion.LEGACY) {
            try {
                MethodType methodType = MethodType.methodType(Boolean.TYPE, Level.class, ItemStack.class, ItemStack.class);
                testMethodHandle = MethodHandles.lookup().findStatic(FilterItem.class, "test", methodType);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                VaultFilters.LOGGER.error("[0.5.1.b-e] could not find test method", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
    }
}

