/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.abstracts;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.item.InfusedCatalystItem;
import java.util.ArrayList;
import java.util.List;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class CatalystModifierAttribute
extends StringAttribute {
    protected CatalystModifierAttribute(String value) {
        super(value);
    }

    public String getName(VaultModifier<?> modifier) {
        return modifier.getDisplayName();
    }

    public Iterable<VaultModifier<?>> getModifiers(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof InfusedCatalystItem)) {
            return new ArrayList();
        }
        List resourceLocations = InfusedCatalystItem.getModifiers((ItemStack)itemStack);
        if (resourceLocations.isEmpty()) {
            return new ArrayList();
        }
        ArrayList vaultModifiers = new ArrayList();
        for (ResourceLocation resourceLocation : resourceLocations) {
            VaultModifierRegistry.getOpt((ResourceLocation)resourceLocation).ifPresent(vaultModifiers::add);
        }
        return vaultModifiers;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof InfusedCatalystItem)) {
            return false;
        }
        Iterable<VaultModifier<?>> modifiers = this.getModifiers(itemStack);
        for (VaultModifier<?> modifier : modifiers) {
            if (!((String)this.value).equals(this.getName(modifier))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemAttribute withValue(VaultModifier<?> modifier) {
        String name = this.getName(modifier);
        return name.isBlank() ? null : this.withValue(name);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        return null;
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
        for (VaultModifier<?> modifier : this.getModifiers(itemStack)) {
            ItemAttribute itemAtt = this.withValue(modifier);
            if (itemAtt == null) continue;
            attributes.add(itemAtt);
        }
        return attributes;
    }
}

