/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.abstracts;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.joseph.vaultfilters.attributes.abstracts.VaultAttribute;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public abstract class IntAttribute
extends VaultAttribute<Integer> {
    private static final Map<Class<?>, Function<Integer, IntAttribute>> factories = new HashMap();

    protected IntAttribute(Integer value) {
        super(value);
    }

    public void register(Function<Integer, IntAttribute> factory) {
        factories.put(this.getClass(), factory);
        super.register();
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        Integer value = (Integer)this.getValue(itemStack);
        return value != null && value >= (Integer)this.value;
    }

    public IntAttribute withValue(Integer value) {
        return factories.getOrDefault(this.getClass(), ignored -> null).apply(value);
    }

    public void writeNBT(CompoundTag compoundTag) {
        compoundTag.m_128405_(this.getTranslationKey(), ((Integer)this.value).intValue());
    }

    public ItemAttribute readNBT(CompoundTag compoundTag) {
        String key = this.getTranslationKey();
        byte type = compoundTag.m_128435_(key);
        if (type == 3) {
            return this.withValue(compoundTag.m_128451_(key));
        }
        if (type == 8) {
            IntAttribute attribute = this.withValue(Integer.parseInt(compoundTag.m_128461_(key)));
            compoundTag.m_128405_(key, ((Integer)attribute.value).intValue());
            return attribute;
        }
        byte legacyType = compoundTag.m_128435_(this.getLegacyKey());
        if (legacyType == 8) {
            IntAttribute attribute = this.withValue(Integer.parseInt(compoundTag.m_128461_(this.getLegacyKey())));
            compoundTag.m_128405_(key, ((Integer)attribute.value).intValue());
            compoundTag.m_128473_(this.getLegacyKey());
            return attribute;
        }
        IntAttribute attribute = this.withValue(compoundTag.m_128451_(this.getLegacyKey()));
        compoundTag.m_128405_(key, ((Integer)attribute.value).intValue());
        compoundTag.m_128473_(this.getLegacyKey());
        return attribute;
    }
}

