/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.abstracts;

import com.simibubi.create.content.logistics.filter.ItemAttribute;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectAvoidanceGearAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectCloudAttribute;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import java.util.HashMap;
import java.util.Map;
import net.joseph.vaultfilters.DataFixers;
import net.joseph.vaultfilters.attributes.abstracts.AffixAttribute;
import net.joseph.vaultfilters.mixin.data.EffectCloudAccessor;
import net.joseph.vaultfilters.mixin.data.EffectCloudAttributeAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.function.TriFunction;

public abstract class NumberAffixAttribute
extends AffixAttribute {
    private static final Map<Class<?>, TriFunction<String, String, Number, ItemAttribute>> factories = new HashMap();
    protected final String name;
    protected final Number level;

    protected NumberAffixAttribute(String value, String name, Number level) {
        super(value);
        this.name = name;
        this.level = level;
    }

    @Override
    public boolean shouldList(VaultGearModifier<?> modifier) {
        return NumberAffixAttribute.getLevel(modifier) != null;
    }

    @Override
    public ItemAttribute withValue(VaultGearModifier<?> modifier) {
        String displayName = NumberAffixAttribute.getDisplayName(modifier, this.getAffixType());
        String name = NumberAffixAttribute.getName(modifier);
        Number level = NumberAffixAttribute.getLevel(modifier);
        return this.withValue(displayName, name, level);
    }

    public void register(TriFunction<String, String, Number, ItemAttribute> factory) {
        factories.put(this.getClass(), factory);
        super.register();
    }

    public ItemAttribute withValue(String displayName, String name, Number level) {
        return (ItemAttribute)factories.getOrDefault(this.getClass(), (TriFunction<String, String, Number, ItemAttribute>)((TriFunction)(o1, o2, o3) -> null)).apply((Object)displayName, (Object)name, (Object)level);
    }

    @Override
    public boolean checkModifier(VaultGearModifier<?> modifier) {
        Number level = NumberAffixAttribute.getLevel(modifier);
        return this.level.getClass().isInstance(level) && level.floatValue() >= this.level.floatValue() && this.name.equals(NumberAffixAttribute.getName(modifier));
    }

    public static <T> String getDisplayName(VaultGearModifier<T> modifier, VaultGearModifier.AffixType type) {
        VaultGearModifierReader reader = modifier.getAttribute().getReader();
        MutableComponent displayName = reader.getDisplay(modifier, type);
        return displayName == null ? NumberAffixAttribute.getName(modifier) : displayName.getString();
    }

    public static <T> Number getLevel(VaultGearModifier<T> modifier) {
        Object value = modifier.getValue();
        if (value instanceof EffectCloudAttribute) {
            EffectCloudAttribute cloudAttribute = (EffectCloudAttribute)value;
            EffectCloudAttribute.EffectCloud cloud = ((EffectCloudAttributeAccessor)cloudAttribute).getEffectCloud();
            String tooltip = ((EffectCloudAccessor)cloud).getTooltip();
            int index = tooltip.lastIndexOf(32);
            if (index == -1) {
                return 1;
            }
            return switch (tooltip.substring(index + 1)) {
                case "II" -> 2;
                case "III" -> 3;
                case "IV" -> 4;
                case "V" -> 5;
                default -> 1;
            };
        }
        if (value instanceof AbilityLevelAttribute) {
            AbilityLevelAttribute levelAttribute = (AbilityLevelAttribute)value;
            return levelAttribute.getLevelChange();
        }
        if (value instanceof EffectAvoidanceGearAttribute) {
            EffectAvoidanceGearAttribute avoidanceAttribute = (EffectAvoidanceGearAttribute)value;
            return Float.valueOf(avoidanceAttribute.getChance());
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number;
        }
        return null;
    }

    @Override
    public void writeNBT(CompoundTag compoundTag) {
        super.writeNBT(compoundTag);
        this.writeLevel(compoundTag, this.level);
        compoundTag.m_128359_(this.getTranslationKey() + "_simple", this.name);
    }

    public void writeLevel(CompoundTag compoundTag, Number level) {
        String levelKey = this.getTranslationKey() + "_level";
        if (level instanceof Float) {
            Float f = (Float)level;
            compoundTag.m_128350_(levelKey, f.floatValue());
        } else if (level instanceof Double) {
            Double d = (Double)level;
            compoundTag.m_128347_(levelKey, d.doubleValue());
        } else if (level instanceof Integer) {
            Integer i = (Integer)level;
            compoundTag.m_128405_(levelKey, i.intValue());
        }
    }

    @Override
    public ItemAttribute readNBT(CompoundTag compoundTag) {
        String key = this.getTranslationKey();
        if (compoundTag.m_128425_(this.getLegacyKey(), 8) && !compoundTag.m_128441_(key)) {
            return this.readLegacyNBT(compoundTag);
        }
        String simpleKey = key + "_simple";
        String levelKey = key + "_level";
        Number level = null;
        byte levelType = compoundTag.m_128435_(levelKey);
        if (levelType == 5) {
            level = Float.valueOf(compoundTag.m_128457_(levelKey));
        } else if (levelType == 6) {
            level = compoundTag.m_128459_(levelKey);
        } else if (levelType == 3) {
            level = compoundTag.m_128451_(levelKey);
        }
        return this.withValue(compoundTag.m_128461_(key), compoundTag.m_128461_(simpleKey), level);
    }

    public ItemAttribute readLegacyNBT(CompoundTag compoundTag) {
        String key = this.getTranslationKey();
        String simpleKey = key + "_simple";
        String displayName = compoundTag.m_128461_(this.getLegacyKey());
        String name = DataFixers.getModifierName(displayName);
        Number level = DataFixers.parseLevel(name, displayName);
        compoundTag.m_128473_(this.getLegacyKey());
        compoundTag.m_128359_(key, displayName);
        compoundTag.m_128359_(simpleKey, name);
        this.writeLevel(compoundTag, level);
        return this.withValue(displayName, name, level);
    }
}

