/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.card;

import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardModifier;
import iskallia.vault.core.card.GearCardModifier;
import iskallia.vault.core.card.TaskLootCardModifier;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.ability.AbilityLevelAttribute;
import iskallia.vault.gear.attribute.custom.effect.EffectAvoidanceGearAttribute;
import iskallia.vault.gear.attribute.talent.RandomVaultModifierAttribute;
import iskallia.vault.gear.reader.VaultGearModifierReader;
import iskallia.vault.item.CardItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.joseph.vaultfilters.attributes.abstracts.ModifierAttribute;
import net.joseph.vaultfilters.attributes.abstracts.Objects.Modifier;
import net.joseph.vaultfilters.attributes.card.CardModifierAttribute;
import net.joseph.vaultfilters.mixin.data.GearCardModifierAccesor;
import net.joseph.vaultfilters.mixin.data.TaskLootCardModifierAccessor;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class CardModifierNumberAttribute
extends ModifierAttribute {
    public CardModifierNumberAttribute(Modifier value) {
        super(value);
    }

    @Override
    public Modifier getValue(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof CardItem)) {
            return null;
        }
        Card card = CardItem.getCard((ItemStack)itemStack);
        List entries = card.getEntries();
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        CardEntry entry = (CardEntry)entries.get(0);
        CardModifier modifier = entry.getModifier();
        if (modifier == null) {
            return null;
        }
        String simpleName = null;
        String displayName = null;
        Number level = null;
        int tier = card.getTier();
        if (modifier instanceof GearCardModifier) {
            GearCardModifier gearModifier = (GearCardModifier)modifier;
            VaultGearAttribute attribute = gearModifier.getAttribute();
            if (attribute == null) {
                return null;
            }
            simpleName = CardModifierAttribute.getName(gearModifier);
            level = CardModifierNumberAttribute.getLevel(gearModifier, tier);
            displayName = CardModifierNumberAttribute.getDisplayName(gearModifier, tier);
        } else if (modifier instanceof TaskLootCardModifier) {
            TaskLootCardModifier lootModifier = (TaskLootCardModifier)modifier;
            simpleName = CardModifierAttribute.getName(lootModifier);
            level = CardModifierNumberAttribute.getLevel(lootModifier, tier);
            displayName = CardModifierNumberAttribute.getDisplayName(level, simpleName);
        }
        if (displayName == null && simpleName == null) {
            return null;
        }
        displayName = displayName == null ? simpleName : displayName;
        simpleName = simpleName == null ? displayName : simpleName;
        level = level == null ? (Number)0 : (Number)level;
        return new Modifier(displayName, simpleName, level);
    }

    public static <T> String getDisplayName(GearCardModifier<T> cardModifier, int tier) {
        Optional valueOpt = CardEntry.getForTier(((GearCardModifierAccesor)cardModifier).getValues(), (int)tier);
        if (valueOpt.isEmpty()) {
            return null;
        }
        Object valueFinal = valueOpt.get();
        VaultGearAttributeInstance modifier = new VaultGearAttributeInstance(cardModifier.getAttribute(), valueFinal);
        VaultGearModifierReader reader = modifier.getAttribute().getReader();
        MutableComponent displayName = reader.getDisplay(modifier, VaultGearModifier.AffixType.PREFIX);
        return displayName == null ? CardModifierAttribute.getName(cardModifier) : displayName.getString();
    }

    public static String getDisplayName(Number level, String simpleName) {
        if (simpleName == null || level == null) {
            return null;
        }
        return "+" + level + " " + simpleName;
    }

    public static <T> Number getLevel(GearCardModifier<T> cardModifier, int tier) {
        Optional valueOpt = CardEntry.getForTier(((GearCardModifierAccesor)cardModifier).getValues(), (int)tier);
        if (valueOpt.isEmpty()) {
            return null;
        }
        Object value = valueOpt.get();
        if (value instanceof AbilityLevelAttribute) {
            AbilityLevelAttribute levelAttribute = (AbilityLevelAttribute)value;
            return levelAttribute.getLevelChange();
        }
        if (value instanceof EffectAvoidanceGearAttribute) {
            EffectAvoidanceGearAttribute avoidanceAttribute = (EffectAvoidanceGearAttribute)value;
            return Float.valueOf(avoidanceAttribute.getChance());
        }
        if (value instanceof RandomVaultModifierAttribute) {
            RandomVaultModifierAttribute randomModAttribute = (RandomVaultModifierAttribute)value;
            return randomModAttribute.getTime();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number;
        }
        return null;
    }

    public static Number getLevel(TaskLootCardModifier lootModifier, int tier) {
        Map<Integer, Integer> counts = ((TaskLootCardModifierAccessor)lootModifier).getCounts();
        return counts.get(tier);
    }

    public String getTranslationKey() {
        return "card_modifier_number";
    }
}

