/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.card;

import iskallia.vault.core.card.Card;
import iskallia.vault.core.card.CardEntry;
import iskallia.vault.core.card.CardModifier;
import iskallia.vault.core.card.TaskLootCardModifier;
import iskallia.vault.item.CardItem;
import iskallia.vault.task.KillEntityTask;
import iskallia.vault.task.LootChestTask;
import iskallia.vault.task.Task;
import java.util.List;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.minecraft.world.item.ItemStack;

public class CardTaskAttribute
extends StringAttribute {
    public CardTaskAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof CardItem)) {
            return null;
        }
        Card card = CardItem.getCard((ItemStack)itemStack);
        List entries = card.getEntries();
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        CardEntry entry = (CardEntry)entries.get(0);
        if (entry == null) {
            return null;
        }
        CardModifier modifier = entry.getModifier();
        if (!(modifier instanceof TaskLootCardModifier)) {
            return null;
        }
        TaskLootCardModifier lootModifier = (TaskLootCardModifier)modifier;
        Task task = lootModifier.getTask();
        if (task instanceof KillEntityTask) {
            KillEntityTask killTask = (KillEntityTask)task;
            KillEntityTask.Config config = (KillEntityTask.Config)killTask.getConfig();
            if (config == null || config.filter == null) {
                return null;
            }
            return config.filter.toString();
        }
        if (task instanceof LootChestTask) {
            LootChestTask lootChestTask = (LootChestTask)task;
            LootChestTask.Config config = (LootChestTask.Config)lootChestTask.getConfig();
            if (config == null || config.filter == null) {
                return null;
            }
            return config.filter.toString();
        }
        return null;
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{CardTaskAttribute.nameFromRawPredicate((String)this.value)};
    }

    public static String nameFromRawPredicate(String val) {
        return switch (val) {
            case "@the_vault:mobs" -> "Mobs killed";
            case "@the_vault:fighter" -> "Dwellers killed";
            case "@the_vault:horde" -> "Horde Mobs killed";
            case "@the_vault:tank" -> "Tanks killed";
            case "@the_vault:assassin" -> "Assassins killed";
            case "@the_vault:chest" -> "chests looted";
            case "@the_vault:wooden" -> "Wooden Chests looted";
            case "@the_vault:gilded" -> "Gilded Chests looted";
            case "@the_vault:ornate" -> "Ornate Chests looted";
            case "@the_vault:living" -> "Living Chests looted";
            default -> val;
        };
    }

    public String getTranslationKey() {
        return "card_task";
    }
}

