/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.vaultfilters.attributes.gear;

import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.tool.JewelItem;
import java.util.Locale;
import java.util.Optional;
import net.joseph.vaultfilters.attributes.abstracts.StringAttribute;
import net.joseph.vaultfilters.attributes.gear.IsUnidentifiedAttribute;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public class GearRarityAttribute
extends StringAttribute {
    public GearRarityAttribute(String value) {
        super(value);
    }

    @Override
    public String getValue(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof JewelItem || !(itemStack.m_41720_() instanceof VaultGearItem)) {
            return null;
        }
        if (Boolean.TRUE.equals(IsUnidentifiedAttribute.isUnidentified(itemStack))) {
            int rollLength;
            Optional roll = AttributeGearData.read((ItemStack)itemStack).getFirstValue(ModGearAttributes.GEAR_ROLL_TYPE);
            if (roll.isEmpty()) {
                return null;
            }
            String rollType = (String)roll.get();
            return rollType.charAt((rollLength = rollType.length()) - 1) == '+' ? rollType.substring(0, rollLength - 1) : rollType;
        }
        VaultGearData data = VaultGearData.read((ItemStack)itemStack);
        return StringUtils.capitalize((String)data.getRarity().toString().toLowerCase(Locale.ROOT));
    }

    public String getTranslationKey() {
        return "gear_rarity";
    }

    @Override
    public String getLegacyKey() {
        return "gearRarity";
    }
}

