/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.client.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.shiftthedev.vaultcoinpouch.VCPRegistry;
import com.shiftthedev.vaultcoinpouch.item.CoinPouchItem;
import iskallia.vault.client.atlas.TextureAtlasRegion;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.element.spi.AbstractSpatialElement;
import iskallia.vault.client.gui.framework.element.spi.IRenderedElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.IPosition;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class StacksElement<E extends StacksElement<E>>
extends AbstractSpatialElement<E>
implements IRenderedElement {
    private static final TextureAtlasRegion SLOT_BACKGROUND = ScreenTextures.INSET_ITEM_SLOT_BACKGROUND;
    private ItemRenderer itemRenderer;
    private int coinpouchSlot;
    private Player player;
    private boolean fromCurios;
    private boolean visible;

    public StacksElement(IPosition position, Player player, int coinpouchSlot) {
        super((ISpatial)Spatials.positionXYZ((IPosition)position).size(18, 72));
        this.coinpouchSlot = coinpouchSlot;
        this.player = player;
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
        if (coinpouchSlot == -1) {
            this.fromCurios = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).isPresent();
        }
        this.setVisible(coinpouchSlot != -1 || this.fromCurios);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void render(IElementRenderer renderer, @NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        ItemStack[] coins = this.getCoins();
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = coins[i];
            renderer.render(SLOT_BACKGROUND, poseStack, this.worldSpatial.x() + 5, i * 18 + this.worldSpatial.y() + 5, this.worldSpatial.z());
            if (stack.m_41619_()) continue;
            this.renderItemStack(stack, this.worldSpatial.x() + 6, i * 18 + this.worldSpatial.y() + 6, this.worldSpatial.z() + 1);
        }
    }

    private ItemStack[] getCoins() {
        if (this.fromCurios) {
            return CoinPouchItem.getContainedStacks(((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)this.player, (Item)VCPRegistry.COIN_POUCH).get()).stack());
        }
        return CoinPouchItem.getContainedStacks(this.player.m_150109_().m_8020_(this.coinpouchSlot));
    }

    private void renderItemStack(ItemStack itemStack, int x, int y, int z) {
        RenderSystem.m_69465_();
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        RenderSystem.m_157182_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        this.itemRenderer.f_115093_ = 100.0f;
        RenderSystem.m_69482_();
        assert (Minecraft.m_91087_().f_91074_ != null);
        this.itemRenderer.m_174229_((LivingEntity)Minecraft.m_91087_().f_91074_, itemStack, x, y, x + y);
        this.itemRenderer.m_115174_(Minecraft.m_91087_().f_91062_, itemStack, x, y, this.getCount(itemStack.m_41613_()));
        this.itemRenderer.f_115093_ = 0.0f;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
    }

    private String getCount(int count) {
        if (count > 1000000000) {
            return Math.floorDiv(count, 1000000000) + "B";
        }
        if (count > 1000000) {
            return Math.floorDiv(count, 1000000) + "M";
        }
        if (count > 1000) {
            return Math.floorDiv(count, 1000) + "K";
        }
        return String.valueOf(count);
    }
}

