/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.client_helpers;

import com.shiftthedev.vaultcoinpouch.VCPRegistry;
import com.shiftthedev.vaultcoinpouch.item.CoinPouchItem;
import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.container.SpiritExtractorContainer;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class SpiritExtractorClientHelper {
    public static boolean setDisabled_coinpouch(SpiritExtractorContainer menu, Inventory inventory) {
        return !menu.hasSpirit() || !SpiritExtractorClientHelper.coinsCoverTotalCost_coinpouch(menu.m_38853_(36), menu.getTotalCost(), inventory.f_35978_) || menu.isSpewingItems();
    }

    public static boolean setDisabled_vh(SpiritExtractorContainer menu) {
        return !menu.coinsCoverTotalCost() || menu.isSpewingItems();
    }

    public static List<Component> getPurchaseButtonTooltipLines(SpiritExtractorContainer menu) {
        ArrayList<Component> purchaseButtonTooltips = new ArrayList<Component>();
        SpiritExtractorTileEntity.RecoveryCost recoveryCost = menu.getRecoveryCost();
        ItemStack totalCost = recoveryCost.getTotalCost();
        if (totalCost.m_41613_() > 0) {
            float rescuedBonus;
            float heroDiscount;
            if (menu.hasSpirit()) {
                purchaseButtonTooltips.add((Component)new TextComponent("Cost for recovering items"));
                int paymentStackCount = SpiritExtractorClientHelper.getPouchCoinsCount(menu);
                ChatFormatting textColor = paymentStackCount < totalCost.m_41613_() ? ChatFormatting.RED : ChatFormatting.YELLOW;
                float var10000 = (float)paymentStackCount / (float)totalCost.m_41613_();
                String percentString = (int)(var10000 * 100.0f) + "%";
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.total_cost", new Object[]{percentString, totalCost.m_41720_().m_7626_(totalCost).getString(), totalCost.m_41613_()}).m_130940_(textColor));
            } else {
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.would_be_cost", new Object[]{totalCost.m_41613_(), totalCost.m_41720_().m_7626_(totalCost).getString()}).m_130940_(ChatFormatting.GREEN));
            }
            purchaseButtonTooltips.add(TextComponent.f_131282_);
            float baseCostCount = recoveryCost.getBaseCount();
            int levels = Math.max(1, menu.getPlayerLevel());
            purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.base_cost", new Object[]{String.format("%.0f", Float.valueOf(baseCostCount * (float)levels)), String.format("%.2f", Float.valueOf(baseCostCount)), levels}).m_130940_(ChatFormatting.GRAY));
            recoveryCost.getStackCost().forEach(t -> purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.item_cost", new Object[]{t.m_14419_(), ((ItemStack)t.m_14418_()).m_41786_()}).m_130940_(ChatFormatting.GRAY)));
            float multiplier = menu.getMultiplier();
            if (!Mth.m_14033_((float)multiplier, (float)1.0f)) {
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.multiplier", new Object[]{String.format("%.2f", Float.valueOf(multiplier))}).m_130940_(ChatFormatting.GRAY));
            }
            if ((double)(heroDiscount = menu.getHeroDiscount()) >= 0.01) {
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.hero_discount", new Object[]{String.format("%.0f%%", Float.valueOf(heroDiscount * 100.0f))}).m_130940_(ChatFormatting.GRAY));
            }
            if ((rescuedBonus = menu.getRescuedBonus()) > 0.0f) {
                purchaseButtonTooltips.add((Component)new TranslatableComponent("screen.the_vault.spirit_extractor.tooltip.rescued_bonus", new Object[]{String.format("%.0f%%", Float.valueOf(rescuedBonus * 100.0f))}).m_130940_(ChatFormatting.GRAY));
            }
        }
        return purchaseButtonTooltips;
    }

    private static int getPouchCoinsCount(SpiritExtractorContainer menu) {
        Player player = menu.getPlayer();
        SpiritExtractorTileEntity.RecoveryCost recoveryCost = menu.getRecoveryCost();
        ItemStack totalCost = recoveryCost.getTotalCost();
        int paymentStackCount = menu.m_38853_(36).m_7993_().m_41613_();
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).isPresent()) {
            paymentStackCount += CoinPouchItem.getCoinCount(((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).get()).stack(), totalCost);
        }
        for (ItemStack plStack : player.m_150109_().f_35974_) {
            if (plStack.m_150930_((Item)ModBlocks.VAULT_GOLD)) {
                paymentStackCount += plStack.m_41613_();
                continue;
            }
            if (!plStack.m_150930_((Item)VCPRegistry.COIN_POUCH)) continue;
            paymentStackCount += CoinPouchItem.getCoinCount(plStack, totalCost);
        }
        return paymentStackCount;
    }

    private static boolean coinsCoverTotalCost_coinpouch(Slot slot, ItemStack costStack, Player player) {
        int totalCost = costStack.m_41613_();
        if (totalCost <= 0) {
            return true;
        }
        int toRemove = 0;
        if (SpiritExtractorClientHelper.canMerge(costStack, slot.m_7993_())) {
            if (slot.m_7993_().m_41613_() >= totalCost) {
                return true;
            }
            toRemove = Math.min(totalCost, slot.m_7993_().m_41613_());
            totalCost -= toRemove;
        }
        if (totalCost <= 0) {
            return true;
        }
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).isPresent()) {
            ItemStack pouchStack = ((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).get()).stack();
            toRemove = Math.min(totalCost, CoinPouchItem.getCoinCount(pouchStack, costStack));
            totalCost -= toRemove;
        }
        Iterator it = player.m_150109_().f_35974_.iterator();
        while (it.hasNext() && totalCost > 0) {
            ItemStack plStack = (ItemStack)it.next();
            if (SpiritExtractorClientHelper.canMerge(plStack, costStack)) {
                toRemove = Math.min(totalCost, plStack.m_41613_());
                totalCost -= toRemove;
                continue;
            }
            if (!plStack.m_150930_((Item)VCPRegistry.COIN_POUCH)) continue;
            toRemove = Math.min(totalCost, CoinPouchItem.getCoinCount(plStack, costStack));
            totalCost -= toRemove;
        }
        return totalCost <= 0;
    }

    private static boolean canMerge(ItemStack stack, ItemStack other) {
        return stack.m_41720_() == other.m_41720_() && ItemStack.m_41658_((ItemStack)stack, (ItemStack)other);
    }
}

