/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.client_helpers;

import com.shiftthedev.vaultcoinpouch.VCPRegistry;
import com.shiftthedev.vaultcoinpouch.item.CoinPouchItem;
import iskallia.vault.container.VaultArtisanStationContainer;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationAction;
import iskallia.vault.gear.modification.GearModificationCost;
import iskallia.vault.gear.tooltip.GearTooltip;
import iskallia.vault.gear.tooltip.VaultGearTooltipItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class VaultArtisanStationClientHelper {
    public static List<Component> tooltip(VaultArtisanStationContainer container, GearModification modification, Random rand) {
        GearModification.Result result;
        GearModificationAction action = container.getModificationAction(modification);
        if (action == null) {
            return Collections.emptyList();
        }
        ItemStack inputItem = ItemStack.f_41583_;
        Slot inputSlot = action.getCorrespondingSlot(container);
        if (inputSlot != null && !inputSlot.m_7993_().m_41619_()) {
            inputItem = inputSlot.m_7993_();
        }
        ItemStack gearStack = container.getGearInputSlot().m_7993_();
        AttributeGearData itemData = AttributeGearData.read((ItemStack)gearStack);
        int potential = itemData.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).orElse(Integer.MIN_VALUE);
        int max_potential = itemData.getFirstValue(ModGearAttributes.MAX_CRAFTING_POTENTIAL).orElse(Integer.MIN_VALUE);
        boolean hasInput = !gearStack.m_41619_() && potential != Integer.MIN_VALUE;
        boolean failedModification = false;
        ArrayList<Component> tooltip = new ArrayList<Component>(modification.getDescription(inputItem));
        if (hasInput && !itemData.isModifiable()) {
            return List.of(new TranslatableComponent("the_vault.gear_modification.unmodifiable").m_130940_(ChatFormatting.RED));
        }
        if (hasInput && !inputItem.m_41619_() && !(result = action.modification().canApply(gearStack, inputItem, container.getPlayer(), rand)).success()) {
            tooltip.add((Component)result.getError(action.modification()));
            failedModification = true;
        }
        if (!failedModification && hasInput) {
            MutableComponent focusCmp = !inputItem.m_41619_() ? new TextComponent("- ").m_7220_(modification.getDisplayStack().m_41786_()).m_130946_(" x1").m_130946_(" [%s]".formatted(inputItem.m_41613_())) : new TextComponent("Requires ").m_7220_(modification.getDisplayStack().m_41786_());
            focusCmp.m_130940_(inputItem.m_41619_() ? ChatFormatting.RED : ChatFormatting.GREEN);
            tooltip.add((Component)focusCmp);
        }
        if (hasInput) {
            if (!failedModification && !inputItem.m_41619_()) {
                VaultGearData data = VaultGearData.read((ItemStack)gearStack);
                String rollType = (String)data.get(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearAttributeTypeMerger.firstNonNull());
                GearModificationCost cost = GearModificationCost.getCost((int)potential, (float)max_potential, (GearModification)modification);
                ItemStack plating = container.getPlatingSlot().m_7993_();
                ItemStack bronze = container.getBronzeSlot().m_7993_();
                MutableComponent var10001 = new TextComponent("- ").m_7220_(new ItemStack((ItemLike)ModItems.VAULT_PLATING).m_41786_());
                int var10002 = cost.costPlating();
                tooltip.add((Component)var10001.m_130946_(" x" + var10002).m_130946_(" [%s]".formatted(plating.m_41613_())).m_130940_(cost.costPlating() > plating.m_41613_() ? ChatFormatting.RED : ChatFormatting.GREEN));
                var10001 = new TextComponent("- ").m_7220_(new ItemStack((ItemLike)ModBlocks.VAULT_BRONZE).m_41786_());
                var10002 = cost.costBronze();
                int bronzeAmount = bronze.m_41613_();
                if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)container.getPlayer(), (Item)VCPRegistry.COIN_POUCH).isPresent()) {
                    bronzeAmount += CoinPouchItem.getCoinCount(((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)container.getPlayer(), (Item)VCPRegistry.COIN_POUCH).get()).stack());
                }
                for (ItemStack plStack : container.getPlayer().m_150109_().f_35974_) {
                    if (plStack.m_150930_((Item)VCPRegistry.COIN_POUCH)) {
                        bronzeAmount += CoinPouchItem.getCoinCount(plStack);
                        continue;
                    }
                    if (!plStack.m_150930_((Item)ModBlocks.VAULT_BRONZE)) continue;
                    bronzeAmount += plStack.m_41613_();
                }
                tooltip.add((Component)var10001.m_130946_(" x" + var10002).m_130946_(" [%s]".formatted(bronzeAmount)).m_130940_(cost.costBronze() > bronzeAmount ? ChatFormatting.RED : ChatFormatting.GREEN));
            }
            tooltip.add(TextComponent.f_131282_);
            tooltip.add(gearStack.m_41786_());
            Item patt5642$temp = gearStack.m_41720_();
            if (patt5642$temp instanceof VaultGearTooltipItem) {
                VaultGearTooltipItem gearTooltipItem = (VaultGearTooltipItem)patt5642$temp;
                tooltip.addAll(gearTooltipItem.createTooltip(gearStack, GearTooltip.craftingView()));
            }
        }
        return tooltip;
    }
}

