/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public class VCPConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final String CONFIG_PATH = "config/shift_mods/coinpouch/coinpouch-common.shift";
    private static final String OLD_PATH = "config/vaultcoinpouch-common.toml";
    private static CommentedFileConfig CONFIG_FILE;
    public static ForgeConfigSpec CONFIG;
    public static final General GENERAL;

    public static void initConfig() {
        Path path = Paths.get(CONFIG_PATH, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
                CommentedFileConfig defaults = (CommentedFileConfig)CommentedFileConfig.builder((Path)path, (ConfigFormat)TomlFormat.instance()).writingMode(WritingMode.REPLACE).build();
                defaults.set("version.versionvalue", (Object)1);
                defaults.save();
                defaults.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to create coin pouch config file", ex);
            }
        }
        CONFIG_FILE = (CommentedFileConfig)CommentedFileConfig.builder((Path)path, (ConfigFormat)TomlFormat.instance()).writingMode(WritingMode.REPLACE).build();
        CONFIG_FILE.load();
        Path oldPath = Paths.get(OLD_PATH, new String[0]);
        if (Files.exists(oldPath, new LinkOption[0])) {
            CommentedFileConfig old_config = (CommentedFileConfig)CommentedFileConfig.builder((String)OLD_PATH).writingMode(WritingMode.REPLACE).build();
            old_config.load();
            CONFIG_FILE.set("General.enableSoulbound", old_config.get("General.enableSoulbound"));
            VCPConfig.saveConfig();
            old_config.close();
            try {
                Files.delete(oldPath);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to delete old coin pouch config file", ex);
            }
        }
        CONFIG.setConfig((CommentedConfig)CONFIG_FILE);
    }

    public static void reloadConfig() {
        CONFIG_FILE.load();
        CONFIG.setConfig((CommentedConfig)CONFIG_FILE);
    }

    public static void updateFromServer(Map<String, Boolean> serverConfigs) {
        serverConfigs.forEach((arg_0, arg_1) -> ((CommentedFileConfig)CONFIG_FILE).set(arg_0, arg_1));
        CONFIG.setConfig((CommentedConfig)CONFIG_FILE);
    }

    public static void saveConfig() {
        CONFIG_FILE.save();
    }

    static {
        GENERAL = new General(BUILDER);
        CONFIG = BUILDER.build();
    }

    public static class General {
        private ForgeConfigSpec.ConfigValue<Boolean> enableSoulbound;
        private ForgeConfigSpec.ConfigValue<Boolean> shopPedestalInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> vaultForgeInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> toolStationInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> inscriptionTableInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> modifierWorkbenchInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> alchemyTableInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> transmogTableInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> vaultArtisanStationInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> jewelCraftingTableInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> spiritExtractorInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> paradoxDoorInteraction;
        private ForgeConfigSpec.ConfigValue<Boolean> showCoinCountInInventoryHud;
        private ForgeConfigSpec.ConfigValue<Boolean> useShortCoinCountInInventoryHud;
        private ForgeConfigSpec.ConfigValue<Boolean> horizontalAlignInInventoryHud;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.enableSoulbound = builder.comment("Enable / Disable the possibility to add Soulbound to the pouch.").define("enableSoulbound", true);
            this.vaultForgeInteraction = builder.comment("Enable / Disable interaction with Vault Forge without taking coins out of the pouch.").define("vaultForgeInteraction", true);
            this.toolStationInteraction = builder.comment("Enable / Disable interaction with Tool Station without taking coins out of the pouch.").define("toolStationInteraction", true);
            this.inscriptionTableInteraction = builder.comment("Enable / Disable interaction with Inscription Table without taking coins out of the pouch.").define("inscriptionTableInteraction", true);
            this.modifierWorkbenchInteraction = builder.comment("Enable / Disable interaction with Modifier Workbench without taking coins out of the pouch.").define("modifierWorkbenchInteraction", true);
            this.alchemyTableInteraction = builder.comment("Enable / Disable interaction with Alchemy Table without taking coins out of the pouch.").define("alchemyTableInteraction", true);
            this.shopPedestalInteraction = builder.comment("Enable / Disable interaction with Shop Pedestal without taking coins out of the pouch.").define("shopPedestalInteraction", true);
            this.transmogTableInteraction = builder.comment("Enable / Disable interaction with Transmog Table without taking coins out of the pouch.").define("transmogTableInteraction", true);
            this.vaultArtisanStationInteraction = builder.comment("Enable / Disable interaction with Vault Artisan Station without taking coins out of the pouch.").define("vaultArtisanStationInteraction", true);
            this.jewelCraftingTableInteraction = builder.comment("Enable / Disable interaction with Jewel Crafting Station without taking coins out of the pouch.").define("jewelCraftingTableInteraction", true);
            this.spiritExtractorInteraction = builder.comment("Enable / Disable interaction with Spirit Extractor without taking coins out of the pouch.").define("spiritExtractorInteraction", true);
            this.paradoxDoorInteraction = builder.comment("Enable / Disable interaction with Paradox Doors without taking coins out of the pouch.").define("paradoxDoorInteraction", true);
            this.showCoinCountInInventoryHud = builder.comment("Enable / Disable coin display in the Inventory HUD overlay.").define("showCoinCountInInventoryHud", true);
            this.useShortCoinCountInInventoryHud = builder.comment("Display 1k instead of 1000.").define("useShortCoinCountInInventoryHud", true);
            this.horizontalAlignInInventoryHud = builder.comment("How should coin display be align.").define("horizontalAlignInInventoryHud", false);
            builder.pop();
        }

        public boolean soulboundEnabled() {
            return (Boolean)this.enableSoulbound.get();
        }

        public void cycleSoulbound() {
            this.enableSoulbound.set((Object)((Boolean)this.enableSoulbound.get() == false ? 1 : 0));
        }

        public boolean vaultForgeEnabled() {
            return (Boolean)this.vaultForgeInteraction.get();
        }

        public boolean toolStationEnabled() {
            return (Boolean)this.toolStationInteraction.get();
        }

        public boolean inscriptionTableEnabled() {
            return (Boolean)this.inscriptionTableInteraction.get();
        }

        public boolean modifierWorkbenchEnabled() {
            return (Boolean)this.modifierWorkbenchInteraction.get();
        }

        public boolean alchemyTableEnabled() {
            return (Boolean)this.alchemyTableInteraction.get();
        }

        public boolean shopPedestalEnabled() {
            return (Boolean)this.shopPedestalInteraction.get();
        }

        public boolean transmogTableEnabled() {
            return (Boolean)this.transmogTableInteraction.get();
        }

        public boolean vaultArtisanStationEnabled() {
            return (Boolean)this.vaultArtisanStationInteraction.get();
        }

        public boolean jewelCraftingTableEnabled() {
            return (Boolean)this.jewelCraftingTableInteraction.get();
        }

        public boolean spiritExtractorEnabled() {
            return (Boolean)this.spiritExtractorInteraction.get();
        }

        public boolean paradoxDoorsEnabled() {
            return (Boolean)this.paradoxDoorInteraction.get();
        }

        public void cycleVaultForge() {
            this.vaultForgeInteraction.set((Object)((Boolean)this.vaultForgeInteraction.get() == false ? 1 : 0));
        }

        public void cycleToolStation() {
            this.toolStationInteraction.set((Object)((Boolean)this.toolStationInteraction.get() == false ? 1 : 0));
        }

        public void cycleInscriptionTable() {
            this.inscriptionTableInteraction.set((Object)((Boolean)this.inscriptionTableInteraction.get() == false ? 1 : 0));
        }

        public void cycleModifierWorkbench() {
            this.modifierWorkbenchInteraction.set((Object)((Boolean)this.modifierWorkbenchInteraction.get() == false ? 1 : 0));
        }

        public void cycleAlchemyTable() {
            this.alchemyTableInteraction.set((Object)((Boolean)this.alchemyTableInteraction.get() == false ? 1 : 0));
        }

        public void cycleShopPedestal() {
            this.shopPedestalInteraction.set((Object)((Boolean)this.shopPedestalInteraction.get() == false ? 1 : 0));
        }

        public void cycleTransmogTable() {
            this.transmogTableInteraction.set((Object)((Boolean)this.transmogTableInteraction.get() == false ? 1 : 0));
        }

        public void cycleVaultArtisanStation() {
            this.vaultArtisanStationInteraction.set((Object)((Boolean)this.vaultArtisanStationInteraction.get() == false ? 1 : 0));
        }

        public void cycleJewelCraftingStation() {
            this.jewelCraftingTableInteraction.set((Object)((Boolean)this.jewelCraftingTableInteraction.get() == false ? 1 : 0));
        }

        public void cycleSpiritExtractor() {
            this.spiritExtractorInteraction.set((Object)((Boolean)this.spiritExtractorInteraction.get() == false ? 1 : 0));
        }

        public void cycleParadoxDoors() {
            this.paradoxDoorInteraction.set((Object)((Boolean)this.paradoxDoorInteraction.get() == false ? 1 : 0));
        }

        public boolean invCoinsEnabled() {
            return (Boolean)this.showCoinCountInInventoryHud.get();
        }

        public boolean invShortEnabled() {
            return (Boolean)this.useShortCoinCountInInventoryHud.get();
        }

        public boolean invHorizontalEnabled() {
            return (Boolean)this.horizontalAlignInInventoryHud.get();
        }

        public void cycleInvCoins() {
            this.showCoinCountInInventoryHud.set((Object)((Boolean)this.showCoinCountInInventoryHud.get() == false ? 1 : 0));
        }

        public void cycleInvShort() {
            this.useShortCoinCountInInventoryHud.set((Object)((Boolean)this.useShortCoinCountInInventoryHud.get() == false ? 1 : 0));
        }

        public void cycleHorizontal() {
            this.horizontalAlignInInventoryHud.set((Object)((Boolean)this.horizontalAlignInInventoryHud.get() == false ? 1 : 0));
        }
    }
}

