/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.container;

import com.shiftthedev.vaultcoinpouch.VCPRegistry;
import com.shiftthedev.vaultcoinpouch.container.CompactingSlot;
import com.shiftthedev.vaultcoinpouch.item.CoinPouchItem;
import iskallia.vault.container.oversized.OverSizedSlotContainer;
import iskallia.vault.container.slot.ConditionalReadSlot;
import iskallia.vault.init.ModBlocks;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class CoinPouchContainer
extends OverSizedSlotContainer {
    private final int pouchSlot;
    private final boolean fromCurios;
    private final Inventory inventory;

    public CoinPouchContainer(int id, Inventory playerInventory, int pouchSlot) {
        super(VCPRegistry.COIN_POUCH_CONTAINER, id, playerInventory.f_35978_);
        this.inventory = playerInventory;
        this.pouchSlot = pouchSlot;
        boolean bl = this.fromCurios = pouchSlot == -1;
        if (!this.hasPouch(playerInventory.f_35978_)) {
            return;
        }
        playerInventory.f_35978_.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(playerHandler -> {
            ItemStack pouch = ItemStack.f_41583_;
            pouch = this.fromCurios ? ((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)playerInventory.f_35978_, (Item)VCPRegistry.COIN_POUCH).get()).stack() : this.inventory.m_8020_(this.pouchSlot);
            if (pouch.m_41619_()) {
                return;
            }
            pouch.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(pouchHandler -> this.initSlots((IItemHandler)playerHandler, (IItemHandler)pouchHandler));
        });
    }

    private void initSlots(IItemHandler playerHandler, IItemHandler pouchHandler) {
        int hotbarSlot;
        for (hotbarSlot = 0; hotbarSlot < 3; ++hotbarSlot) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_((Slot)new ConditionalReadSlot(playerHandler, column + hotbarSlot * 9 + 9, 8 + column * 18, 55 + hotbarSlot * 18, this::canAccess));
            }
        }
        for (hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_((Slot)new ConditionalReadSlot(playerHandler, hotbarSlot, 8 + hotbarSlot * 18, 113, this::canAccess));
        }
        Slot bronze = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 0, 50, 16, this, ModBlocks.BRONZE_COIN_PILE.m_5456_()));
        Slot silver = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 1, 70, 24, this, ModBlocks.SILVER_COIN_PILE.m_5456_()));
        Slot gold = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 2, 90, 16, this, ModBlocks.GOLD_COIN_PILE.m_5456_()));
        Slot plat = this.m_38897_((Slot)new CompactingSlot(pouchHandler, 3, 110, 24, this, ModBlocks.PLATINUM_COIN_PILE.m_5456_()));
        ((CompactingSlot)bronze).setupSlots(null, silver);
        ((CompactingSlot)silver).setupSlots(bronze, gold);
        ((CompactingSlot)gold).setupSlots(silver, plat);
        ((CompactingSlot)plat).setupSlots(gold, null);
    }

    public boolean m_6875_(Player player) {
        return this.hasPouch(player);
    }

    public boolean canAccess(int slot, ItemStack slotStack) {
        return !(slotStack.m_41720_() instanceof CoinPouchItem);
    }

    public boolean hasPouch(Player player) {
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).isPresent()) {
            return true;
        }
        if (this.pouchSlot == -1) {
            return false;
        }
        ItemStack pouchStack = this.inventory.m_8020_(this.pouchSlot);
        return !pouchStack.m_41619_() && pouchStack.m_41720_() instanceof CoinPouchItem;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index >= 0 && index < 36 && this.m_38903_(slotStack, 36, 40, false)) {
                return itemStack;
            }
            if (index >= 0 && index < 27 ? !this.m_38903_(slotStack, 27, 36, false) : (index >= 27 && index < 36 ? !this.m_38903_(slotStack, 0, 27, false) : !this.m_38903_(slotStack, 0, 36, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return itemStack;
    }
}

