/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.item;

import com.shiftthedev.vaultcoinpouch.config.VCPConfig;
import com.shiftthedev.vaultcoinpouch.container.CoinPouchContainer;
import iskallia.vault.block.CoinPileDecorBlock;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoinPouchItem
extends Item {
    public CoinPouchItem(String id) {
        super(new Item.Properties().m_41487_(1).m_41491_(ModItems.VAULT_MOD_GROUP));
        this.setRegistryName(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag p_41424_) {
        super.m_7373_(stack, level, tooltip, p_41424_);
        tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.info").m_130940_(ChatFormatting.GRAY));
        ItemStack[] contained = CoinPouchItem.getContainedStacks(stack);
        if (Screen.m_96638_()) {
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.bronze", new Object[]{contained[0].m_41613_()}).m_130948_(Style.f_131099_.m_178520_(14712607)));
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.silver", new Object[]{contained[1].m_41613_()}).m_130948_(Style.f_131099_.m_178520_(0xC0C0C0)));
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.gold", new Object[]{contained[2].m_41613_()}).m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.platinum", new Object[]{contained[3].m_41613_()}).m_130948_(Style.f_131099_.m_178520_(0xF5F5F5)));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.bronze", new Object[]{this.getCount(contained[0].m_41613_())}).m_130948_(Style.f_131099_.m_178520_(14712607)));
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.silver", new Object[]{this.getCount(contained[1].m_41613_())}).m_130948_(Style.f_131099_.m_178520_(0xC0C0C0)));
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.gold", new Object[]{this.getCount(contained[2].m_41613_())}).m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.platinum", new Object[]{this.getCount(contained[3].m_41613_())}).m_130948_(Style.f_131099_.m_178520_(0xF5F5F5)));
        }
        if (!VCPConfig.GENERAL.soulboundEnabled()) {
            return;
        }
        if (AttributeGearData.read((ItemStack)stack).hasAttribute(ModGearAttributes.SOULBOUND)) {
            tooltip.add((Component)new TextComponent("\n" + ModGearAttributes.SOULBOUND.getReader().getModifierName()).m_130948_(ModGearAttributes.SOULBOUND.getReader().getColoredTextStyle()));
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.vaultcoinpouch.soulbound").m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private String getCount(int count) {
        if (count > 1000000000) {
            return Math.floorDiv(count, 1000000000) + "B";
        }
        if (count > 1000000) {
            return Math.floorDiv(count, 1000000) + "M";
        }
        if (count > 1000) {
            return Math.floorDiv(count, 1000) + "K";
        }
        return String.valueOf(count);
    }

    public static int getCoinCount(ItemStack pouch) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        return invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
    }

    public static int extractCoins(ItemStack pouch, int currency) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        int bronzeCount = invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
        int left = bronzeCount - currency;
        if (left >= 0) {
            CoinPouchItem.setContainedStack(pouch, 0, left);
            return currency;
        }
        CoinPouchItem.setContainedStack(pouch, 0, 0);
        return currency - bronzeCount;
    }

    public static int getCoinCount(ItemStack pouch, ItemStack coin) {
        Item item = coin.m_41720_();
        if (!(item instanceof BlockItem)) {
            return 0;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.m_40614_() instanceof CoinPileDecorBlock)) {
            return 0;
        }
        CompoundTag invTag = pouch.m_41698_("Inventory");
        if (blockItem.m_40614_() == ModBlocks.BRONZE_COIN_PILE) {
            return invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
        }
        if (blockItem.m_40614_() == ModBlocks.SILVER_COIN_PILE) {
            return invTag.m_128441_("SilverStackSize") ? invTag.m_128451_("SilverStackSize") : 0;
        }
        if (blockItem.m_40614_() == ModBlocks.GOLD_COIN_PILE) {
            return invTag.m_128441_("GoldStackSize") ? invTag.m_128451_("GoldStackSize") : 0;
        }
        if (blockItem.m_40614_() == ModBlocks.PLATINUM_COIN_PILE) {
            return invTag.m_128441_("PlatinumStackSize") ? invTag.m_128451_("PlatinumStackSize") : 0;
        }
        return 0;
    }

    public static void extractCoins(ItemStack pouch, ItemStack coin, int currency) {
        Item item = coin.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!(blockItem.m_40614_() instanceof CoinPileDecorBlock)) {
            return;
        }
        int coinAmount = blockItem.m_40614_() == ModBlocks.BRONZE_COIN_PILE ? currency : (blockItem.m_40614_() == ModBlocks.SILVER_COIN_PILE ? currency * 9 : (blockItem.m_40614_() == ModBlocks.GOLD_COIN_PILE ? currency * 81 : (blockItem.m_40614_() == ModBlocks.PLATINUM_COIN_PILE ? currency * 729 : 0)));
        CompoundTag invTag = pouch.m_41698_("Inventory");
        int bronzeCount = invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
        int left = bronzeCount - coinAmount;
        if (left >= 0) {
            CoinPouchItem.setContainedStack(pouch, 0, left);
            return;
        }
        CoinPouchItem.setContainedStack(pouch, 0, 0);
    }

    public static ItemStack[] getContainedStacks(ItemStack pouch) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        int bronzeCount = invTag.m_128441_("BronzeStackSize") ? invTag.m_128451_("BronzeStackSize") : 0;
        int silverCount = invTag.m_128441_("SilverStackSize") ? invTag.m_128451_("SilverStackSize") : 0;
        int goldCount = invTag.m_128441_("GoldStackSize") ? invTag.m_128451_("GoldStackSize") : 0;
        int platinumCount = invTag.m_128441_("PlatinumStackSize") ? invTag.m_128451_("PlatinumStackSize") : 0;
        return new ItemStack[]{new ItemStack((ItemLike)ModBlocks.BRONZE_COIN_PILE, bronzeCount), new ItemStack((ItemLike)ModBlocks.SILVER_COIN_PILE, silverCount), new ItemStack((ItemLike)ModBlocks.GOLD_COIN_PILE, goldCount), new ItemStack((ItemLike)ModBlocks.PLATINUM_COIN_PILE, platinumCount)};
    }

    public static void setContainedStack(ItemStack pouch, int slot, int count) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        switch (slot) {
            case 0: {
                invTag.m_128405_("BronzeStackSize", count);
                invTag.m_128405_("SilverStackSize", Mth.m_14042_((int)count, (int)9));
                invTag.m_128405_("GoldStackSize", Mth.m_14042_((int)count, (int)81));
                invTag.m_128405_("PlatinumStackSize", Mth.m_14042_((int)count, (int)729));
                break;
            }
            case 1: {
                int newCount = invTag.m_128451_("BronzeStackSize");
                newCount -= Mth.m_14042_((int)newCount, (int)9) * 9;
                CoinPouchItem.setContainedStack(pouch, 0, newCount += count * 9);
                break;
            }
            case 2: {
                int newCount = invTag.m_128451_("BronzeStackSize");
                newCount -= Mth.m_14042_((int)newCount, (int)81) * 81;
                CoinPouchItem.setContainedStack(pouch, 0, newCount += count * 81);
                break;
            }
            case 3: {
                int newCount = invTag.m_128451_("BronzeStackSize");
                newCount -= Mth.m_14042_((int)newCount, (int)729) * 729;
                CoinPouchItem.setContainedStack(pouch, 0, newCount += count * 729);
            }
        }
    }

    public static void setContainedStackFromGUI(ItemStack pouch, int slot, ItemStack stack) {
        CompoundTag invTag = pouch.m_41698_("Inventory");
        switch (slot) {
            case 0: {
                invTag.m_128405_("BronzeStackSize", stack.m_41613_());
                break;
            }
            case 1: {
                invTag.m_128405_("SilverStackSize", stack.m_41613_());
                break;
            }
            case 2: {
                invTag.m_128405_("GoldStackSize", stack.m_41613_());
                break;
            }
            case 3: {
                invTag.m_128405_("PlatinumStackSize", stack.m_41613_());
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            int pouchSlot = hand == InteractionHand.OFF_HAND ? 40 : player.m_150109_().f_35977_;
            CoinPouchItem.openGUI(player, pouchSlot);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public static void openGUI(Player player, final int pouchSlot) {
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("item.vaultcoinpouch.coin_pouch");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                return new CoinPouchContainer(windowId, inventory, pouchSlot);
            }
        }, friendlyByteBuf -> friendlyByteBuf.writeInt(pouchSlot));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public static NonNullSupplier<IItemHandler> getInventorySupplier(final ItemStack itemStack) {
        return new NonNullSupplier<IItemHandler>(){

            @NotNull
            public IItemHandler get() {
                return new Handler(itemStack);
            }
        };
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(CoinPouchItem.getInventorySupplier(stack)).cast() : LazyOptional.empty();
            }
        };
    }

    public static class Handler
    extends ItemStackHandler {
        protected final ItemStack delegate;

        public Handler(ItemStack delegate) {
            this.delegate = delegate;
            ItemStack[] containedStacks = CoinPouchItem.getContainedStacks(this.delegate);
            this.setSize(containedStacks.length);
            for (int i = 0; i < containedStacks.length; ++i) {
                this.stacks.set(i, (Object)containedStacks[i]);
            }
        }

        protected void onContentsChanged(int slot) {
            CoinPouchItem.setContainedStack(this.delegate, slot, this.getStackInSlot(slot).m_41613_());
        }

        protected void onGuiContentChanged(int slot) {
            CoinPouchItem.setContainedStackFromGUI(this.delegate, slot, this.getStackInSlot(slot));
        }

        public void setStackInSlotGUI(int slot, @NotNull ItemStack stack) {
            this.validateSlotIndex(slot);
            this.stacks.set(slot, (Object)stack);
            this.onGuiContentChanged(slot);
        }

        public ItemStack extractItemGUI(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            this.validateSlotIndex(slot);
            ItemStack existing = (ItemStack)this.stacks.get(slot);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    this.stacks.set(slot, (Object)ItemStack.f_41583_);
                    this.onGuiContentChanged(slot);
                    return existing;
                }
                return existing.m_41777_();
            }
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
                this.onGuiContentChanged(slot);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }

        public int getSlotLimit(int slot) {
            return switch (slot) {
                case 0 -> 2147483097;
                case 1 -> 238609233;
                case 2 -> 26512137;
                case 3 -> 2945793;
                default -> 0;
            };
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return this.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_().m_5456_() == ModBlocks.BRONZE_COIN_PILE.m_5456_() && slot == 0 || stack.m_41720_().m_5456_() == ModBlocks.SILVER_COIN_PILE.m_5456_() && slot == 1 || stack.m_41720_().m_5456_() == ModBlocks.GOLD_COIN_PILE.m_5456_() && slot == 2 || stack.m_41720_().m_5456_() == ModBlocks.PLATINUM_COIN_PILE.m_5456_() && slot == 3;
        }
    }
}

