/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.mixins.forge;

import com.shiftthedev.vaultcoinpouch.client.elements.CoinPouchElement;
import com.shiftthedev.vaultcoinpouch.config.VCPConfig;
import com.shiftthedev.vaultcoinpouch.network.NetworkManager;
import com.shiftthedev.vaultcoinpouch.network.ShiftVaultForgeRequestCraftMessage;
import com.shiftthedev.vaultcoinpouch.server_helpers.ShiftInventoryUtils;
import iskallia.vault.block.entity.CatalystInfusionTableTileEntity;
import iskallia.vault.block.entity.InscriptionTableTileEntity;
import iskallia.vault.block.entity.JewelCraftingTableTileEntity;
import iskallia.vault.block.entity.ToolStationTileEntity;
import iskallia.vault.block.entity.VaultForgeTileEntity;
import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.client.gui.framework.element.spi.IElement;
import iskallia.vault.client.gui.framework.render.spi.IElementRenderer;
import iskallia.vault.client.gui.framework.render.spi.ITooltipRendererFactory;
import iskallia.vault.client.gui.framework.screen.AbstractElementContainerScreen;
import iskallia.vault.client.gui.framework.spatial.Spatials;
import iskallia.vault.client.gui.framework.spatial.spi.ISpatial;
import iskallia.vault.client.gui.screen.block.base.ForgeRecipeContainerScreen;
import iskallia.vault.container.spi.ForgeRecipeContainer;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ForgeRecipeContainerScreen.class}, remap=false, priority=1100)
public abstract class ForgeRecipeContainerScreenMixin<V extends ForgeRecipeTileEntity, T extends ForgeRecipeContainer<V>>
extends AbstractElementContainerScreen<T> {
    @Shadow
    private VaultForgeRecipe selectedRecipe;

    @Shadow
    public abstract Inventory getPlayerInventory();

    @Shadow
    protected abstract int getCraftedLevel();

    @Inject(method={"<init>(Liskallia/vault/container/spi/ForgeRecipeContainer;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;II)V"}, at={@At(value="TAIL")})
    private void init_coinpouch(ForgeRecipeContainer container, Inventory inventory, Component title, int height, int width, CallbackInfo ci) {
        if (((ForgeRecipeContainer)this.f_97732_).getTile() instanceof VaultForgeTileEntity) {
            this.addElement((IElement)new CoinPouchElement((ISpatial)Spatials.positionXYZ((int)-15, (int)104, (int)20), () -> Spatials.positionXY((int)-8, (int)(this.f_97736_ + 14)), inventory.f_35978_));
        } else if (!(((ForgeRecipeContainer)this.f_97732_).getTile() instanceof CatalystInfusionTableTileEntity)) {
            this.addElement((IElement)new CoinPouchElement((ISpatial)Spatials.positionXYZ((int)-30, (int)71, (int)20), () -> Spatials.positionXY((int)-8, (int)(this.f_97736_ + 14)), inventory.f_35978_));
        }
    }

    @Inject(method={"getMissingRecipeInputs"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMissingRecipeInputs_coinpouch(List<ItemStack> inputs, CallbackInfoReturnable<List<ItemStack>> cir) {
        ForgeRecipeTileEntity tile = ((ForgeRecipeContainer)this.f_97732_).getTile();
        if (tile == null) {
            cir.setReturnValue(inputs);
            cir.cancel();
            return;
        }
        if (tile instanceof VaultForgeTileEntity && VCPConfig.GENERAL.vaultForgeEnabled()) {
            cir.setReturnValue(ShiftInventoryUtils.getMissingInputs(inputs, this.getPlayerInventory(), tile.getInventory()));
            cir.cancel();
            return;
        }
        if (tile instanceof ToolStationTileEntity && VCPConfig.GENERAL.toolStationEnabled()) {
            cir.setReturnValue(ShiftInventoryUtils.getMissingInputs(inputs, this.getPlayerInventory(), tile.getInventory()));
            cir.cancel();
            return;
        }
        if (tile instanceof InscriptionTableTileEntity && VCPConfig.GENERAL.inscriptionTableEnabled()) {
            cir.setReturnValue(ShiftInventoryUtils.getMissingInputs(inputs, this.getPlayerInventory(), tile.getInventory()));
            cir.cancel();
            return;
        }
        if (tile instanceof JewelCraftingTableTileEntity && VCPConfig.GENERAL.jewelCraftingTableEnabled()) {
            cir.setReturnValue(ShiftInventoryUtils.getMissingInputs(inputs, this.getPlayerInventory(), tile.getInventory()));
            cir.cancel();
            return;
        }
    }

    @Inject(method={"onCraftClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCraftClick_coinpouch(CallbackInfo ci) {
        ForgeRecipeTileEntity tile;
        if (this.selectedRecipe != null && (tile = ((ForgeRecipeContainer)this.f_97732_).getTile()) != null) {
            if (tile instanceof VaultForgeTileEntity && VCPConfig.GENERAL.vaultForgeEnabled()) {
                NetworkManager.CHANNEL.sendToServer((Object)new ShiftVaultForgeRequestCraftMessage(this.selectedRecipe.getId(), this.getCraftedLevel()));
                ci.cancel();
                return;
            }
            if (tile instanceof ToolStationTileEntity && VCPConfig.GENERAL.toolStationEnabled()) {
                NetworkManager.CHANNEL.sendToServer((Object)new ShiftVaultForgeRequestCraftMessage(this.selectedRecipe.getId(), this.getCraftedLevel()));
                ci.cancel();
                return;
            }
            if (tile instanceof InscriptionTableTileEntity && VCPConfig.GENERAL.inscriptionTableEnabled()) {
                NetworkManager.CHANNEL.sendToServer((Object)new ShiftVaultForgeRequestCraftMessage(this.selectedRecipe.getId(), this.getCraftedLevel()));
                ci.cancel();
                return;
            }
            if (tile instanceof JewelCraftingTableTileEntity && VCPConfig.GENERAL.jewelCraftingTableEnabled()) {
                NetworkManager.CHANNEL.sendToServer((Object)new ShiftVaultForgeRequestCraftMessage(this.selectedRecipe.getId(), this.getCraftedLevel()));
                ci.cancel();
                return;
            }
        }
    }

    public ForgeRecipeContainerScreenMixin(T container, Inventory inventory, Component title, IElementRenderer elementRenderer, ITooltipRendererFactory<AbstractElementContainerScreen<T>> tooltipRendererFactory) {
        super(container, inventory, title, elementRenderer, tooltipRendererFactory);
    }
}

