/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.mixins.shop;

import com.shiftthedev.vaultcoinpouch.config.VCPConfig;
import com.shiftthedev.vaultcoinpouch.server_helpers.ShopPedestalHelper;
import iskallia.vault.block.ShopPedestalBlock;
import iskallia.vault.util.InventoryUtil;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShopPedestalBlock.class}, remap=false, priority=1100)
public abstract class ShopPedestalBlockMixin {
    @Inject(method={"hasEnoughCurrency"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasEnoughtCurrency_coinpouch(List<InventoryUtil.ItemAccess> allItems, ItemStack currency, CallbackInfoReturnable<Boolean> cir) {
        if (VCPConfig.GENERAL.shopPedestalEnabled()) {
            cir.setReturnValue((Object)ShopPedestalHelper.hasEnoughCurrency(allItems, currency));
            cir.cancel();
            return;
        }
    }

    @Inject(method={"extractCurrency"}, at={@At(value="HEAD")}, cancellable=true)
    private void extractCurrency_coinpouch(Player player, List<InventoryUtil.ItemAccess> allItems, ItemStack price, CallbackInfoReturnable<Boolean> cir) {
        if (VCPConfig.GENERAL.shopPedestalEnabled()) {
            cir.setReturnValue((Object)ShopPedestalHelper.extractCurrency(player, allItems, price));
            cir.cancel();
            return;
        }
    }
}

