/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.network;

import com.google.common.collect.Maps;
import com.shiftthedev.vaultcoinpouch.VaultCoinPouch;
import com.shiftthedev.vaultcoinpouch.config.VCPConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncMessage {
    private Map<String, Boolean> configs = Maps.newHashMap();

    public ConfigSyncMessage(VCPConfig.General server) {
        this.configs.put("General.enableSoulbound", server.soulboundEnabled());
        this.configs.put("General.shopPedestalInteraction", server.shopPedestalEnabled());
        this.configs.put("General.vaultForgeInteraction", server.vaultForgeEnabled());
        this.configs.put("General.toolStationInteraction", server.toolStationEnabled());
        this.configs.put("General.inscriptionTableInteraction", server.inscriptionTableEnabled());
        this.configs.put("General.modifierWorkbenchInteraction", server.modifierWorkbenchEnabled());
        this.configs.put("General.alchemyTableInteraction", server.alchemyTableEnabled());
        this.configs.put("General.transmogTableInteraction", server.transmogTableEnabled());
        this.configs.put("General.vaultArtisanStationInteraction", server.vaultArtisanStationEnabled());
        this.configs.put("General.jewelCuttingStationInteraction", server.jewelCraftingTableEnabled());
        this.configs.put("General.spiritExtractorInteraction", server.spiritExtractorEnabled());
        this.configs.put("General.paradoxDoorInteraction", server.paradoxDoorsEnabled());
    }

    public ConfigSyncMessage(Map<String, Boolean> configs) {
        this.configs = configs;
    }

    public static void encode(ConfigSyncMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.configs.size());
        message.configs.forEach((k, v) -> {
            buffer.m_130070_(k);
            buffer.writeBoolean(v.booleanValue());
        });
    }

    public static ConfigSyncMessage decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap temp = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String id = buffer.m_130136_(128);
            boolean value = buffer.readBoolean();
            temp.put(id, value);
        }
        return new ConfigSyncMessage(temp);
    }

    public static void handle(ConfigSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            VCPConfig.updateFromServer(message.configs);
            VaultCoinPouch.LOGGER.info("Received config from server.");
        });
        context.setPacketHandled(true);
    }
}

