/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.network;

import com.shiftthedev.vaultcoinpouch.server_helpers.ShiftInventoryUtils;
import iskallia.vault.block.entity.base.ForgeRecipeTileEntity;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.container.spi.ForgeRecipeContainer;
import iskallia.vault.event.event.ForgeGearEvent;
import iskallia.vault.gear.crafting.recipe.VaultForgeRecipe;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ForgeParticleMessage;
import iskallia.vault.util.SidedHelper;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ShiftVaultForgeRequestCraftMessage {
    private final ResourceLocation recipe;
    private final int level;

    public ShiftVaultForgeRequestCraftMessage(ResourceLocation recipe, int level) {
        this.recipe = recipe;
        this.level = level;
    }

    public static void encode(ShiftVaultForgeRequestCraftMessage message, FriendlyByteBuf buffer) {
        buffer.m_130085_(message.recipe);
        buffer.writeInt(message.level);
    }

    public static ShiftVaultForgeRequestCraftMessage decode(FriendlyByteBuf buffer) {
        return new ShiftVaultForgeRequestCraftMessage(buffer.m_130281_(), buffer.readInt());
    }

    public static void handle(ShiftVaultForgeRequestCraftMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ShiftVaultForgeRequestCraftMessage.enqueueWork(context, message));
        context.setPacketHandled(true);
    }

    private static void enqueueWork(NetworkEvent.Context context, ShiftVaultForgeRequestCraftMessage message) {
        AbstractContainerMenu patt2079$temp;
        ServerPlayer requester = context.getSender();
        if (requester != null && (patt2079$temp = requester.f_36096_) instanceof ForgeRecipeContainer) {
            ForgeRecipeContainer container = (ForgeRecipeContainer)patt2079$temp;
            if (!container.getResultSlot().m_7993_().m_41619_()) {
                return;
            }
            ForgeRecipeTileEntity tile = container.getTile();
            if (tile == null) {
                return;
            }
            VaultForgeRecipe recipe = null;
            for (ForgeRecipeType type : tile.getSupportedRecipeTypes()) {
                VaultForgeRecipe found = type.getRecipe(message.recipe);
                if (found == null || !found.canCraft((Player)requester)) continue;
                recipe = found;
                break;
            }
            if (recipe == null) {
                return;
            }
            Inventory playerInventory = requester.m_150109_();
            OverSizedInventory tileInventory = tile.getInventory();
            ArrayList<OverSizedItemStack> consumed = new ArrayList<OverSizedItemStack>();
            if (ShiftInventoryUtils.consumeInputs(recipe.getInputs(), playerInventory, tileInventory, true) && ShiftInventoryUtils.consumeInputs(recipe.getInputs(), playerInventory, tileInventory, false, consumed)) {
                int level = Mth.m_14045_((int)message.level, (int)0, (int)Math.min(ModConfigs.LEVELS_META.getMaxLevel(), SidedHelper.getVaultLevel((Player)requester)));
                container.getResultSlot().m_5852_(recipe.createOutput(consumed, requester, level));
                requester.f_19853_.m_46796_(1030, tile.m_58899_(), 0);
                container.m_38946_();
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ForgeParticleMessage(tile.m_58899_()));
                MinecraftForge.EVENT_BUS.post((Event)new ForgeGearEvent((Player)requester, recipe));
            }
            return;
        }
    }
}

