/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.server_helpers;

import com.shiftthedev.vaultcoinpouch.mixins.modifier.ModifierWorkbenchCraftMessageAccessor;
import com.shiftthedev.vaultcoinpouch.server_helpers.ShiftInventoryUtils;
import iskallia.vault.block.entity.ModifierWorkbenchTileEntity;
import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.gear.VaultGearModifierHelper;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.crafting.ModifierWorkbenchHelper;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.network.message.ModifierWorkbenchCraftMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ModifierWorkbenchServerHelper {
    public static void enqueueWork(NetworkEvent.Context context, ModifierWorkbenchCraftMessage message) {
        ModifierWorkbenchTileEntity workbenchTile;
        ItemStack input;
        ServerPlayer player = context.getSender();
        BlockPos pos = ((ModifierWorkbenchCraftMessageAccessor)message).getPos();
        BlockEntity tile = player.m_183503_().m_7702_(pos);
        if (tile instanceof ModifierWorkbenchTileEntity && !(input = (workbenchTile = (ModifierWorkbenchTileEntity)tile).getInventory().m_8020_(0)).m_41619_() && input.m_41720_() instanceof VaultGearItem && AttributeGearData.hasData((ItemStack)input) && VaultGearData.read((ItemStack)input).isModifiable()) {
            VaultGearWorkbenchConfig.getConfig((Item)input.m_41720_()).ifPresent(cfg -> ModifierWorkbenchServerHelper.getConfig(input, message, cfg, player, tile));
        }
    }

    private static void getConfig(ItemStack input, ModifierWorkbenchCraftMessage message, VaultGearWorkbenchConfig cfg, ServerPlayer player, BlockEntity tile) {
        ItemStack inputCopy = input.m_41777_();
        VaultGearModifier.AffixType targetAffix = null;
        VaultGearModifier createdModifier = null;
        ArrayList<ItemStack> cost = new ArrayList<ItemStack>();
        if (((ModifierWorkbenchCraftMessageAccessor)message).getCraftModifierIdentifier() == null) {
            if (!ModifierWorkbenchHelper.hasCraftedModifier((ItemStack)inputCopy)) {
                return;
            }
            cost.addAll(cfg.getCostRemoveCraftedModifiers());
        } else {
            VaultGearWorkbenchConfig.CraftableModifierConfig modifierConfig = cfg.getConfig(((ModifierWorkbenchCraftMessageAccessor)message).getCraftModifierIdentifier());
            if (modifierConfig == null) {
                return;
            }
            if (!modifierConfig.hasPrerequisites((Player)player)) {
                return;
            }
            boolean hadCraftedModifiers = ModifierWorkbenchHelper.hasCraftedModifier((ItemStack)inputCopy);
            ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)inputCopy);
            VaultGearData data = VaultGearData.read((ItemStack)inputCopy);
            if (data.getItemLevel() < modifierConfig.getMinLevel()) {
                return;
            }
            targetAffix = modifierConfig.getAffixGroup().getTargetAffixType();
            if (targetAffix == VaultGearModifier.AffixType.PREFIX ? !VaultGearModifierHelper.hasOpenPrefix((ItemStack)inputCopy) : !VaultGearModifierHelper.hasOpenSuffix((ItemStack)inputCopy)) {
                return;
            }
            createdModifier = modifierConfig.createModifier().orElse(null);
            if (createdModifier == null) {
                return;
            }
            Set existingModGroups = data.getExistingModifierGroups(VaultGearData.Type.EXPLICIT_MODIFIERS);
            if (existingModGroups.contains(createdModifier.getModifierGroup())) {
                return;
            }
            cost.addAll(modifierConfig.createCraftingCost(inputCopy));
            if (hadCraftedModifiers) {
                cost.addAll(cfg.getCostRemoveCraftedModifiers());
            }
        }
        List<ItemStack> missing = ShiftInventoryUtils.getMissingInputs(cost, player.m_150109_());
        if (missing.isEmpty() && ShiftInventoryUtils.consumeInputs(cost, player.m_150109_(), true) && ShiftInventoryUtils.consumeInputs(cost, player.m_150109_(), false)) {
            if (createdModifier == null) {
                ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)input);
            } else {
                createdModifier.addCategory(VaultGearModifier.AffixCategory.CRAFTED);
                createdModifier.setGameTimeAdded(player.m_183503_().m_46467_());
                ModifierWorkbenchHelper.removeCraftedModifiers((ItemStack)input);
                VaultGearData datax = VaultGearData.read((ItemStack)input);
                datax.addModifier(targetAffix, createdModifier);
                datax.write(input);
            }
            player.m_183503_().m_46796_(1030, tile.m_58899_(), 0);
        }
    }
}

