/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.server_helpers;

import com.shiftthedev.vaultcoinpouch.VCPRegistry;
import com.shiftthedev.vaultcoinpouch.item.CoinPouchItem;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class ShiftInventoryUtils {
    private static final Set<Item> COINS_TYPE = new HashSet<Item>();

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, boolean simulate) {
        return ShiftInventoryUtils.consumeInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY, simulate);
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory tileInv, boolean simulate) {
        return ShiftInventoryUtils.consumeInputs(recipeInputs, playerInventory, tileInv, simulate, new ArrayList<OverSizedItemStack>());
    }

    public static boolean consumeInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory tileInv, boolean simulate, List<OverSizedItemStack> consumed) {
        boolean success = true;
        NonNullList pouchStacks = NonNullList.m_122779_();
        CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)playerInventory.f_35978_, (Item)VCPRegistry.COIN_POUCH).ifPresent(slotResult -> pouchStacks.add((Object)slotResult.stack()));
        for (ItemStack input : recipeInputs) {
            ItemStack deducted;
            int deductedAmount;
            int neededCount = input.m_41613_();
            NonNullList overSizedContents = tileInv.getOverSizedContents();
            for (int slot = 0; slot < overSizedContents.size(); ++slot) {
                OverSizedItemStack overSized = (OverSizedItemStack)overSizedContents.get(slot);
                if (neededCount <= 0) break;
                if (!ShiftInventoryUtils.isEqualCrafting(input, overSized.stack())) continue;
                int deductedAmount2 = Math.min(neededCount, overSized.amount());
                if (!simulate) {
                    tileInv.setOverSizedStack(slot, overSized.addCopy(-deductedAmount2));
                    consumed.add(overSized.copyAmount(deductedAmount2));
                }
                neededCount -= overSized.amount();
            }
            if (neededCount <= 0) continue;
            NonNullList items = playerInventory.f_35974_;
            for (ItemStack plStack : items) {
                if (neededCount <= 0) break;
                if (ShiftInventoryUtils.isEqualCrafting(input, plStack)) {
                    deductedAmount = Math.min(neededCount, plStack.m_41613_());
                    if (!simulate) {
                        plStack.m_41774_(deductedAmount);
                        deducted = plStack.m_41777_();
                        deducted.m_41764_(deductedAmount);
                        consumed.add(OverSizedItemStack.of((ItemStack)deducted));
                    }
                    neededCount -= deductedAmount;
                }
                if (!COINS_TYPE.contains(input.m_41720_()) || !plStack.m_150930_((Item)VCPRegistry.COIN_POUCH)) continue;
                pouchStacks.add((Object)plStack);
            }
            if (neededCount <= 0) continue;
            if (COINS_TYPE.contains(input.m_41720_())) {
                for (ItemStack pouchStack : pouchStacks) {
                    deductedAmount = Math.min(neededCount, CoinPouchItem.getCoinCount(pouchStack, input));
                    if (!simulate) {
                        CoinPouchItem.extractCoins(pouchStack, input, deductedAmount);
                        deducted = input.m_41777_();
                        deducted.m_41764_(deductedAmount);
                        consumed.add(OverSizedItemStack.of((ItemStack)deducted));
                    }
                    neededCount -= deductedAmount;
                }
            }
            if (neededCount <= 0) continue;
            success = false;
        }
        return success;
    }

    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory) {
        return ShiftInventoryUtils.getMissingInputs(recipeInputs, playerInventory, OverSizedInventory.EMPTY);
    }

    public static List<ItemStack> getMissingInputs(List<ItemStack> recipeInputs, Inventory playerInventory, OverSizedInventory containerInventory) {
        ArrayList<ItemStack> missing = new ArrayList<ItemStack>();
        ItemStack curiosPouchStack = ItemStack.f_41583_;
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)playerInventory.f_35978_, (Item)VCPRegistry.COIN_POUCH).isPresent()) {
            curiosPouchStack = ((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)playerInventory.f_35978_, (Item)VCPRegistry.COIN_POUCH).get()).stack();
        }
        for (ItemStack input : recipeInputs) {
            int neededCount = input.m_41613_();
            for (OverSizedItemStack overSized : containerInventory.getOverSizedContents()) {
                if (!ShiftInventoryUtils.isEqualCrafting(input, overSized.stack())) continue;
                neededCount -= overSized.amount();
            }
            if (COINS_TYPE.contains(input.m_41720_()) && !curiosPouchStack.m_41619_()) {
                neededCount -= CoinPouchItem.getCoinCount(curiosPouchStack, input);
            }
            for (ItemStack plStack : playerInventory.f_35974_) {
                if (ShiftInventoryUtils.isEqualCrafting(input, plStack)) {
                    neededCount -= plStack.m_41613_();
                }
                if (COINS_TYPE.contains(input.m_41720_()) && plStack.m_150930_((Item)VCPRegistry.COIN_POUCH)) {
                    neededCount -= CoinPouchItem.getCoinCount(plStack, input);
                }
                if (neededCount > 0) continue;
                break;
            }
            if (neededCount <= 0) continue;
            missing.add(input);
        }
        return missing;
    }

    private static boolean isEqualCrafting(ItemStack thisStack, ItemStack thatStack) {
        return thisStack.m_41720_() == thatStack.m_41720_() && thisStack.m_41773_() == thatStack.m_41773_() && (thisStack.m_41783_() == null || thisStack.areShareTagsEqual(thatStack));
    }

    static {
        Collections.addAll(COINS_TYPE, ModBlocks.BRONZE_COIN_PILE.m_5456_(), ModBlocks.SILVER_COIN_PILE.m_5456_(), ModBlocks.GOLD_COIN_PILE.m_5456_(), ModBlocks.PLATINUM_COIN_PILE.m_5456_());
    }
}

