/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.server_helpers;

import com.shiftthedev.vaultcoinpouch.VCPRegistry;
import com.shiftthedev.vaultcoinpouch.item.CoinPouchItem;
import com.shiftthedev.vaultcoinpouch.utils.ShiftCoinDefinition;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.InventoryUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShopPedestalHelper {
    private static Map<Item, ShiftCoinDefinition> COIN_DEFINITIONS;

    public static boolean hasEnoughCurrency(List<InventoryUtil.ItemAccess> allItems, ItemStack currency) {
        return ShopPedestalHelper.getCoinDefinition(currency.m_41720_()).map(priceCoinDefinition -> ShopPedestalHelper.hasEnoughCoin(priceCoinDefinition, currency, allItems)).orElse(false);
    }

    private static boolean hasEnoughCoin(ShiftCoinDefinition priceCoinDefinition, ItemStack currency, List<InventoryUtil.ItemAccess> allItems) {
        int priceValue = priceCoinDefinition.coinValue() * currency.m_41613_();
        Iterator<InventoryUtil.ItemAccess> var4 = allItems.iterator();
        do {
            if (!var4.hasNext()) {
                return false;
            }
            InventoryUtil.ItemAccess itemAccess = var4.next();
            if (itemAccess.getStack().m_150930_((Item)VCPRegistry.COIN_POUCH)) {
                priceValue -= CoinPouchItem.getCoinCount(itemAccess.getStack());
                continue;
            }
            priceValue -= ShopPedestalHelper.getCoinDefinition(itemAccess.getStack().m_41720_()).map(coinDefinition -> coinDefinition.coinValue() * itemAccess.getStack().m_41613_()).orElse(0).intValue();
        } while (priceValue > 0);
        return true;
    }

    public static boolean extractCurrency(Player player, List<InventoryUtil.ItemAccess> allItems, ItemStack price) {
        ShopPedestalHelper.getCoinDefinition(price.m_41720_()).ifPresent(priceCoinDefinition -> ShopPedestalHelper.extractCoin(priceCoinDefinition, price, allItems, player));
        return true;
    }

    private static void extractCoin(ShiftCoinDefinition priceCoinDefinition, ItemStack price, List<InventoryUtil.ItemAccess> allItems, Player player) {
        int priceValue = priceCoinDefinition.coinValue() * price.m_41613_();
        if ((priceValue = ShopPedestalHelper.deductCoins(allItems, priceValue, priceCoinDefinition)) > 0) {
            priceValue = ShopPedestalHelper.payUsingLowerDenominations(allItems, priceValue, priceCoinDefinition);
            priceValue = ShopPedestalHelper.payUsingHigherDenominations(allItems, priceValue, priceCoinDefinition);
        }
        if (priceValue < 0) {
            int change = -priceValue;
            ShopPedestalHelper.returnChangeToPlayer(player, change);
        }
    }

    private static void returnChangeToPlayer(Player player, int change) {
        while (change > 0) {
            for (ShiftCoinDefinition definition : COIN_DEFINITIONS.values()) {
                if (definition.coinValue() > change || change / definition.coinValue() >= 9) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)definition.coinItem(), change / definition.coinValue()));
                change -= definition.coinValue() * (change / definition.coinValue());
            }
        }
    }

    private static int payUsingHigherDenominations(List<InventoryUtil.ItemAccess> allItems, int priceValue, ShiftCoinDefinition coinDefinition) {
        while (priceValue > 0 && coinDefinition.previousHigherDenomination() != null) {
            Optional<ShiftCoinDefinition> higherCoinDefinition = ShopPedestalHelper.getCoinDefinition(coinDefinition.previousHigherDenomination());
            if (!higherCoinDefinition.isPresent()) continue;
            coinDefinition = higherCoinDefinition.get();
            priceValue = ShopPedestalHelper.deductCoins(allItems, priceValue, coinDefinition);
        }
        return priceValue;
    }

    private static int payUsingLowerDenominations(List<InventoryUtil.ItemAccess> allItems, int priceValue, ShiftCoinDefinition coinDefinition) {
        while (priceValue > 0 && coinDefinition.nextLowerDenomination() != null) {
            Optional<ShiftCoinDefinition> lowerCoinDefinition = ShopPedestalHelper.getCoinDefinition(coinDefinition.nextLowerDenomination());
            if (!lowerCoinDefinition.isPresent()) continue;
            coinDefinition = lowerCoinDefinition.get();
            priceValue = ShopPedestalHelper.deductCoins(allItems, priceValue, coinDefinition);
        }
        return priceValue;
    }

    private static int deductCoins(List<InventoryUtil.ItemAccess> allItems, int priceValue, ShiftCoinDefinition coinDefinition) {
        Iterator var4 = allItems.iterator();
        NonNullList pouchStacks = NonNullList.m_122779_();
        while (var4.hasNext()) {
            int countToRemove;
            InventoryUtil.ItemAccess itemAccess = var4.next();
            ItemStack stack = itemAccess.getStack();
            if (stack.m_41720_() == coinDefinition.coinItem() && (countToRemove = (int)Math.ceil((double)Math.min(priceValue, stack.m_41613_() * coinDefinition.coinValue()) / (double)coinDefinition.coinValue())) > 0) {
                itemAccess.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - countToRemove)));
                if ((priceValue -= countToRemove * coinDefinition.coinValue()) <= 0) {
                    return priceValue;
                }
            }
            if (!stack.m_150930_((Item)VCPRegistry.COIN_POUCH)) continue;
            pouchStacks.add((Object)itemAccess);
        }
        for (InventoryUtil.ItemAccess pouch : pouchStacks) {
            ItemStack pouchStack = pouch.getStack();
            priceValue -= CoinPouchItem.extractCoins(pouchStack, priceValue);
            pouch.setStack(pouchStack.m_41777_());
            if (priceValue > 0) continue;
            break;
        }
        return priceValue;
    }

    public static Optional<ShiftCoinDefinition> getCoinDefinition(Item coin) {
        if (COIN_DEFINITIONS == null) {
            COIN_DEFINITIONS = new LinkedHashMap<Item, ShiftCoinDefinition>();
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_BRONZE, new ShiftCoinDefinition((Item)ModBlocks.VAULT_BRONZE, (Item)ModBlocks.VAULT_SILVER, null, 1));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_SILVER, new ShiftCoinDefinition((Item)ModBlocks.VAULT_SILVER, (Item)ModBlocks.VAULT_GOLD, (Item)ModBlocks.VAULT_BRONZE, 9));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_GOLD, new ShiftCoinDefinition((Item)ModBlocks.VAULT_GOLD, (Item)ModBlocks.VAULT_PLATINUM, (Item)ModBlocks.VAULT_SILVER, 81));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_PLATINUM, new ShiftCoinDefinition((Item)ModBlocks.VAULT_PLATINUM, null, (Item)ModBlocks.VAULT_GOLD, 729));
        }
        return Optional.ofNullable(COIN_DEFINITIONS.get(coin));
    }
}

