/*
 * Decompiled with CFR 0.152.
 */
package com.shiftthedev.vaultcoinpouch.server_helpers;

import com.shiftthedev.vaultcoinpouch.VCPRegistry;
import com.shiftthedev.vaultcoinpouch.item.CoinPouchItem;
import iskallia.vault.container.VaultArtisanStationContainer;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.modification.GearModification;
import iskallia.vault.gear.modification.GearModificationCost;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class VaultArtisanStationHelper {
    public static void apply(VaultArtisanStationContainer container, ServerPlayer player, Slot correspondingSlot, GearModification modification, Random rand) {
        if (VaultArtisanStationHelper.canApply(container, (Player)player, correspondingSlot, modification, rand)) {
            ItemStack gear = container.getGearInputSlot().m_7993_();
            VaultGearData data = VaultGearData.read((ItemStack)gear);
            int potential = data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).orElse(Integer.MIN_VALUE);
            int max_potential = data.getFirstValue(ModGearAttributes.MAX_CRAFTING_POTENTIAL).orElse(Integer.MIN_VALUE);
            Slot inSlot = correspondingSlot;
            if (inSlot != null) {
                Iterator it;
                ItemStack input = inSlot.m_7993_();
                ItemStack material = input.m_41777_();
                input.m_41774_(1);
                inSlot.m_5852_(input);
                String rollType = (String)data.get(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearAttributeTypeMerger.firstNonNull());
                GearModificationCost cost = GearModificationCost.getCost((int)potential, (float)max_potential, (GearModification)modification);
                ItemStack plating = container.getPlatingSlot().m_7993_();
                plating.m_41774_(cost.costPlating());
                container.getPlatingSlot().m_5852_(plating);
                ItemStack bronze = container.getBronzeSlot().m_7993_();
                int bronzeRemaining = cost.costBronze();
                int bronzeToTake = Math.min(bronzeRemaining, bronze.m_41613_());
                bronze.m_41774_(bronzeToTake);
                container.getBronzeSlot().m_5852_(bronze);
                if ((bronzeRemaining -= bronzeToTake) > 0 && CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).isPresent()) {
                    ItemStack pouchStack = ((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).get()).stack();
                    bronzeToTake = Math.min(bronzeRemaining, CoinPouchItem.getCoinCount(pouchStack));
                    CoinPouchItem.extractCoins(pouchStack, bronzeToTake);
                    bronzeRemaining -= bronzeToTake;
                }
                NonNullList pouchStacks = NonNullList.m_122779_();
                if (bronzeRemaining > 0) {
                    it = player.m_150109_().f_35974_.iterator();
                    while (it.hasNext() && bronzeRemaining > 0) {
                        ItemStack plStack = (ItemStack)it.next();
                        if (plStack.m_150930_((Item)ModBlocks.VAULT_BRONZE)) {
                            bronzeToTake = Math.min(bronzeRemaining, plStack.m_41613_());
                            plStack.m_41774_(bronzeToTake);
                            bronzeRemaining -= bronzeToTake;
                        }
                        if (!plStack.m_150930_((Item)VCPRegistry.COIN_POUCH)) continue;
                        pouchStacks.add((Object)plStack);
                    }
                }
                if (bronzeRemaining > 0 && !pouchStacks.isEmpty()) {
                    it = pouchStacks.iterator();
                    while (it.hasNext() && bronzeRemaining > 0) {
                        ItemStack pouchStack = (ItemStack)it.next();
                        bronzeToTake = Math.min(bronzeRemaining, CoinPouchItem.getCoinCount(pouchStack));
                        CoinPouchItem.extractCoins(pouchStack, bronzeToTake);
                        bronzeRemaining -= bronzeToTake;
                    }
                }
                modification.apply(gear, material, (Player)player, rand);
            }
        }
    }

    public static boolean canApply(VaultArtisanStationContainer container, Player player, Slot correspondingSlot, GearModification modification, Random rand) {
        Slot inSlot = correspondingSlot;
        if (inSlot == null) {
            return false;
        }
        ItemStack gear = container.getGearInputSlot().m_7993_();
        ItemStack in = inSlot.m_7993_();
        if (!in.m_41619_() && !gear.m_41619_() && modification.getStackFilter().test(in)) {
            VaultGearData data = VaultGearData.read((ItemStack)gear);
            int potential = data.getFirstValue(ModGearAttributes.CRAFTING_POTENTIAL).orElse(Integer.MIN_VALUE);
            int max_potential = data.getFirstValue(ModGearAttributes.MAX_CRAFTING_POTENTIAL).orElse(Integer.MIN_VALUE);
            String rollType = (String)data.get(ModGearAttributes.GEAR_ROLL_TYPE, VaultGearAttributeTypeMerger.firstNonNull());
            GearModificationCost cost = GearModificationCost.getCost((int)potential, (float)max_potential, (GearModification)modification);
            ItemStack plating = container.getPlatingSlot().m_7993_();
            if (plating.m_41613_() < cost.costPlating()) {
                return false;
            }
            int bronzeMissing = cost.costBronze();
            ItemStack bronze = container.getBronzeSlot().m_7993_();
            if ((bronzeMissing -= bronze.m_41613_()) <= 0) {
                return modification.canApply(gear, in, player, rand).success();
            }
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).isPresent()) {
                bronzeMissing -= CoinPouchItem.getCoinCount(((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)VCPRegistry.COIN_POUCH).get()).stack());
            }
            if (bronzeMissing <= 0) {
                return modification.canApply(gear, in, player, rand).success();
            }
            for (ItemStack plStack : player.m_150109_().f_35974_) {
                if (plStack.m_150930_((Item)VCPRegistry.COIN_POUCH)) {
                    bronzeMissing -= CoinPouchItem.getCoinCount(plStack);
                } else if (plStack.m_150930_((Item)ModBlocks.VAULT_BRONZE)) {
                    bronzeMissing -= plStack.m_41613_();
                }
                if (bronzeMissing > 0) continue;
                break;
            }
            return bronzeMissing <= 0 && modification.canApply(gear, in, player, rand).success();
        }
        return false;
    }
}

