/*
 * Decompiled with CFR 0.152.
 */
package net.joseph.ccvault.peripheral.custom;

import dan200.computercraft.api.detail.DetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import iskallia.vault.config.gear.VaultGearTierConfig;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.config.ConfigurableAttributeGenerator;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.data.InscriptionData;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.joseph.ccvault.blockEntity.custom.VaultReaderBlockEntity;
import net.joseph.ccvault.peripheral.Methods;
import net.joseph.ccvault.peripheral.TweakedPeripheral;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class VaultReaderBlockPeripheral
extends TweakedPeripheral<VaultReaderBlockEntity> {
    private final List<IComputerAccess> pcs = new LinkedList<IComputerAccess>();
    private IItemHandler inventory;
    private VaultReaderBlockEntity be;

    public VaultReaderBlockPeripheral(VaultReaderBlockEntity blockentity) {
        super("vaultreader", blockentity);
        this.inventory = blockentity.getItemHandler();
        this.be = blockentity;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        int inserted;
        ItemStack extracted = from.extractItem(fromSlot, limit, true);
        if (extracted.m_41619_()) {
            return 0;
        }
        int extractCount = Math.min(extracted.m_41613_(), limit);
        extracted.m_41764_(extractCount);
        ItemStack remainder = toSlot < 0 ? ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false) : to.insertItem(toSlot, extracted, false);
        int n = inserted = remainder.m_41619_() ? extractCount : extractCount - remainder.m_41613_();
        if (inserted <= 0) {
            return 0;
        }
        from.extractItem(fromSlot, inserted, false);
        return inserted;
    }

    private static IItemHandler extractHandler(@Nullable Object object) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = (provider = (ICapabilityProvider)object).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    @LuaFunction
    public final int size() {
        return this.inventory.getSlots();
    }

    @LuaFunction
    public final Map<Integer, Map<String, ?>> list() {
        HashMap result = new HashMap();
        int size = this.inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, DetailRegistries.ITEM_STACK.getBasicDetails((Object)stack));
        }
        return result;
    }

    @LuaFunction
    public final Map<String, ?> getItemDetail(int slot) throws LuaException {
        Methods.assertBetween(slot, 1.0, this.inventory.getSlots(), "Slot out of range (%s)");
        ItemStack stack = this.inventory.getStackInSlot(slot - 1);
        return stack.m_41619_() ? null : DetailRegistries.ITEM_STACK.getDetails((Object)stack);
    }

    @LuaFunction
    public final int getItemLimit(int slot) throws LuaException {
        Methods.assertBetween(slot, 1.0, this.inventory.getSlots(), "Slot out of range (%s)");
        return this.inventory.getSlotLimit(slot - 1);
    }

    @LuaFunction
    public final int pushItems(IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = VaultReaderBlockPeripheral.extractHandler(location.getTarget());
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        Methods.assertBetween(fromSlot, 1.0, this.inventory.getSlots(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            Methods.assertBetween(toSlot.get().intValue(), 1.0, to.getSlots(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return VaultReaderBlockPeripheral.moveItem(this.inventory, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    @LuaFunction
    public final int pullItems(IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IItemHandler from = VaultReaderBlockPeripheral.extractHandler(location.getTarget());
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        Methods.assertBetween(fromSlot, 1.0, from.getSlots(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            Methods.assertBetween(toSlot.get().intValue(), 1.0, this.inventory.getSlots(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return VaultReaderBlockPeripheral.moveItem(from, fromSlot - 1, this.inventory, toSlot.orElse(0) - 1, actualLimit);
    }

    public Optional<MutableComponent> getDisplay2(VaultGearModifier modifier, VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack, boolean displayDetail) {
        return Optional.ofNullable(modifier.getAttribute().getReader().getDisplay((VaultGearAttributeInstance)modifier, data, type, stack));
    }

    public Optional<MutableComponent> getDisplay(VaultGearModifier modifier, VaultGearData data, VaultGearModifier.AffixType type, ItemStack stack, boolean displayDetail) {
        VaultGearModifier.AffixCategory cat = modifier.getCategories() == null || modifier.getCategories().isEmpty() || modifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY) || modifier.hasCategory(VaultGearModifier.AffixCategory.CRAFTED) ? VaultGearModifier.AffixCategory.NONE : (VaultGearModifier.AffixCategory)modifier.getCategories().first();
        return this.getDisplay2(modifier, data, type, stack, displayDetail).map(cat.getModifierFormatter()).map(displayText -> {
            if (!modifier.hasGameTimeAdded()) {
                return displayText;
            }
            int showDuration = 600;
            long added = modifier.getGameTimeAdded();
            return displayText;
        }).map(displayText -> {
            MutableComponent rangeCmp;
            if (!displayDetail) {
                return displayText;
            }
            Style txtStyle = Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_131136_(Boolean.valueOf(false));
            String categoryInfo = cat.getTooltipDescriptor();
            VaultGearTierConfig.ModifierConfigRange configRange = VaultGearTierConfig.getConfig((ItemStack)stack).map(tierCfg -> tierCfg.getTierConfigRange(modifier, data.getItemLevel())).orElse(VaultGearTierConfig.ModifierConfigRange.empty());
            ConfigurableAttributeGenerator attributeGenerator = modifier.getAttribute().getGenerator();
            TextComponent cmpRangeDescriptor = new TextComponent(categoryInfo);
            if (configRange.minAvailableConfig() != null && configRange.maxAvailableConfig() != null && (rangeCmp = attributeGenerator.getConfigRangeDisplay(modifier.getAttribute().getReader(), configRange.minAvailableConfig(), configRange.maxAvailableConfig())) != null) {
                if (!cmpRangeDescriptor.getString().isBlank()) {
                    cmpRangeDescriptor.m_130946_(" ");
                }
                cmpRangeDescriptor.m_7220_((Component)rangeCmp);
                if (modifier.hasCategory(VaultGearModifier.AffixCategory.CRAFTED)) {
                    cmpRangeDescriptor.m_130946_(" [Crafted] ");
                }
                if (modifier.hasCategory(VaultGearModifier.AffixCategory.LEGENDARY)) {
                    cmpRangeDescriptor.m_130946_(" [Legendary] ");
                }
            }
            if (!cmpRangeDescriptor.getString().isBlank()) {
                displayText.m_7220_((Component)new TextComponent(" ").m_130948_(txtStyle).m_130946_("(").m_7220_((Component)cmpRangeDescriptor).m_130946_(")"));
            }
            return displayText;
        });
    }

    @LuaFunction
    public final int getItemLevel() {
        return VaultGearData.read((ItemStack)this.be.getItemStack()).getItemLevel();
    }

    @LuaFunction
    public final String getRarity() {
        return VaultGearData.read((ItemStack)this.be.getItemStack()).getRarity().toString();
    }

    @LuaFunction
    public final int getRepairSlots() {
        return VaultGearData.read((ItemStack)this.be.getItemStack()).getRepairSlots();
    }

    @LuaFunction
    public final int getUsedRepairSlots() {
        return VaultGearData.read((ItemStack)this.be.getItemStack()).getUsedRepairSlots();
    }

    @LuaFunction
    public final String getImplicit(int index) {
        VaultGearData data = VaultGearData.read((ItemStack)this.be.getItemStack());
        VaultGearModifier.AffixType type = VaultGearModifier.AffixType.IMPLICIT;
        ItemStack stack = this.be.getItemStack();
        Boolean displayDetail = true;
        List affixes = data.getModifiers(type);
        if (index >= affixes.size()) {
            return "null";
        }
        VaultGearModifier affix = (VaultGearModifier)affixes.get(index);
        MutableComponent component = this.getDisplay(affix, data, type, stack, displayDetail).get();
        return component.getString();
    }

    @LuaFunction
    public final String getPrefix(int index) {
        VaultGearData data = VaultGearData.read((ItemStack)this.be.getItemStack());
        VaultGearModifier.AffixType type = VaultGearModifier.AffixType.PREFIX;
        ItemStack stack = this.be.getItemStack();
        Boolean displayDetail = true;
        List affixes = data.getModifiers(type);
        if (affixes.size() > index) {
            VaultGearModifier affix = (VaultGearModifier)affixes.get(index);
            MutableComponent component = this.getDisplay(affix, data, type, stack, displayDetail).get();
            return component.getString();
        }
        if (this.getPrefixCount() > index) {
            return "empty";
        }
        return "null";
    }

    @LuaFunction
    public final String getSuffix(int index) {
        VaultGearData data = VaultGearData.read((ItemStack)this.be.getItemStack());
        VaultGearModifier.AffixType type = VaultGearModifier.AffixType.SUFFIX;
        ItemStack stack = this.be.getItemStack();
        Boolean displayDetail = true;
        List affixes = data.getModifiers(type);
        if (affixes.size() > index) {
            VaultGearModifier affix = (VaultGearModifier)affixes.get(index);
            MutableComponent component = this.getDisplay(affix, data, type, stack, displayDetail).get();
            return component.getString();
        }
        if (this.getSuffixCount() > index) {
            return "empty";
        }
        return "null";
    }

    @LuaFunction
    public final int getImplicitCount() {
        VaultGearData data = VaultGearData.read((ItemStack)this.be.getItemStack());
        return data.getModifiers(VaultGearModifier.AffixType.IMPLICIT).size();
    }

    @LuaFunction
    public final int getPrefixCount() {
        VaultGearData data = VaultGearData.read((ItemStack)this.be.getItemStack());
        return data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0);
    }

    @LuaFunction
    public final int getSuffixCount() {
        VaultGearData data = VaultGearData.read((ItemStack)this.be.getItemStack());
        return data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0);
    }

    public static boolean isNumber(String num) {
        if (num == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(num);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @LuaFunction
    public final double getModifierValue(String modifier) {
        boolean flag = false;
        int flagint = 0;
        for (int i = 0; i < modifier.length(); ++i) {
            if (!VaultReaderBlockPeripheral.isNumber(String.valueOf(modifier.charAt(i)))) continue;
            flag = true;
            flagint = i;
            i = 100000;
        }
        if (modifier.contains("IV")) {
            return 4.0;
        }
        if (modifier.contains("V")) {
            return 5.0;
        }
        if (modifier.contains("III")) {
            return 3.0;
        }
        if (modifier.contains("II")) {
            return 2.0;
        }
        if (!flag) {
            return 1.0;
        }
        Object tempnum = String.valueOf(modifier.charAt(flagint));
        for (int i = flagint + 1; i < modifier.length(); ++i) {
            if (VaultReaderBlockPeripheral.isNumber(String.valueOf(modifier.charAt(i))) || String.valueOf(modifier.charAt(i)).equals(".")) {
                tempnum = (String)tempnum + String.valueOf(modifier.charAt(i));
                continue;
            }
            i = 100000;
        }
        return Double.parseDouble((String)tempnum);
    }

    @LuaFunction
    public final double getMaximumRoll(String modifier) {
        if (!modifier.contains("-")) {
            return this.getModifierValue(modifier);
        }
        int baseIndex = modifier.indexOf(45) + 1;
        Object tempnum = String.valueOf(modifier.charAt(baseIndex));
        for (int i = baseIndex + 1; i < modifier.length(); ++i) {
            if (VaultReaderBlockPeripheral.isNumber(String.valueOf(modifier.charAt(i))) || String.valueOf(modifier.charAt(i)).equals(".")) {
                tempnum = (String)tempnum + String.valueOf(modifier.charAt(i));
                continue;
            }
            i = 100000;
        }
        return Double.parseDouble((String)tempnum);
    }

    @LuaFunction
    public final double getMinimumRoll(String modifier) {
        if (!modifier.contains("(")) {
            return this.getModifierValue(modifier);
        }
        int baseIndex = modifier.indexOf(40) + 1;
        Object tempnum = String.valueOf(modifier.charAt(baseIndex));
        for (int i = baseIndex + 1; i < modifier.length(); ++i) {
            if (VaultReaderBlockPeripheral.isNumber(String.valueOf(modifier.charAt(i))) || String.valueOf(modifier.charAt(i)).equals(".")) {
                tempnum = (String)tempnum + String.valueOf(modifier.charAt(i));
                continue;
            }
            i = 100000;
        }
        return Double.parseDouble((String)tempnum);
    }

    @LuaFunction
    public final String getName(String modifier) {
        Object toReturn = "";
        boolean isCloud = modifier.contains("Cloud");
        for (int i = 0; i < modifier.length(); ++i) {
            if (Character.isAlphabetic(modifier.charAt(i)) && (!isCloud || modifier.charAt(i) != 'I' && modifier.charAt(i) != 'V')) {
                toReturn = (String)toReturn + String.valueOf(modifier.charAt(i));
            }
            if (modifier.charAt(i) != '[' && modifier.charAt(i) != '(') continue;
            i = 10000;
        }
        return toReturn;
    }

    @LuaFunction
    public final String getType(String modifier) {
        char firstchar = modifier.charAt(0);
        if (firstchar == 'e') {
            return "empty";
        }
        if (firstchar == 'n') {
            return "null";
        }
        if (modifier.contains("Crafted")) {
            return "crafted";
        }
        if (modifier.contains("Legendary")) {
            return "legendary";
        }
        return "regular";
    }

    @LuaFunction
    public final String getRoom() {
        InscriptionData data = InscriptionData.from((ItemStack)this.be.getItemStack());
        if (data.getEntries().size() == 0) {
            return "Empty";
        }
        return ((InscriptionData.Entry)data.getEntries().get(0)).toRoomEntry().getName().getString();
    }
}

